/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.diagnos.personality.java.classfile.constants.DGFieldMethodRefConstant;
import com.wily.introscope.agent.db.ClassMethodId;
import com.wily.introscope.agent.db.DatabaseTransaction;
import com.wily.introscope.agent.db.IConnectionManager;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.feedback.Module;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class CompilerLogDatabaseTransaction
extends DatabaseTransaction {
    private static int countClassMethodInserted;
    private static int countClassMethodRetrieved;
    protected static final int kTraced = 1;
    protected static final int kSkipped = 2;
    private static final Module kModule;

    static {
        kModule = new Module("CompilerLogDatabaseTransaction");
    }

    public CompilerLogDatabaseTransaction(IConnectionManager s) {
        super(s);
    }

    protected void tryUpdateClass(String className, int classSkipStatus, ClassMethodId current) throws SQLException {
        if (current.getClassSkipStatus() != classSkipStatus) {
            PreparedStatement createClass = this.getPreparedStatement("classUpdate", "update class set skip_status = ? where class_id = ?");
            createClass.setInt(2, current.getClassId());
            createClass.setInt(1, classSkipStatus);
            createClass.execute();
            current.setClassSkipStatus(classSkipStatus);
        }
    }

    protected void tryUpdateProcessedClass(String className, int classProcessedStatus, boolean isInterface) throws SQLException {
        PreparedStatement createClass = this.getPreparedStatement("classUpdate", "update class set class_methods_processed = ?, is_interface = ? where class_name = ?");
        createClass.setString(3, className);
        createClass.setInt(1, classProcessedStatus);
        createClass.setInt(2, isInterface ? 1 : 0);
        createClass.execute();
    }

    protected boolean checkProcessedClass(String className) throws SQLException {
        PreparedStatement s1 = this.getPreparedStatement("classSelect", "select class_id, class_name, class_methods_processed from class where class_name = ?");
        s1.setString(1, className);
        ResultSet rs = s1.executeQuery();
        if (!rs.next()) {
            return false;
        }
        int isMethodsProcessed = rs.getInt(3);
        return isMethodsProcessed == 1;
    }

    protected ClassMethodId tryStoreClass(String className) throws SQLException {
        int classId = -1;
        int skipStatus = -1;
        PreparedStatement s1 = this.getPreparedStatement("classSelect", "select class_id, class_name, skip_status from class where class_name = ?");
        s1.setString(1, className);
        ResultSet rs = s1.executeQuery();
        if (!rs.next()) {
            PreparedStatement createClass = this.getPreparedStatement("classInsert", "insert into class values (DEFAULT, ?, ?, ?, ?)");
            createClass.setString(1, className);
            createClass.setInt(2, -1);
            createClass.setInt(3, 2);
            createClass.setInt(4, 0);
            createClass.execute();
            classId = this.getLastIdCreated();
        } else {
            classId = rs.getInt(1);
            skipStatus = rs.getInt(3);
        }
        ClassMethodId result = new ClassMethodId(classId);
        result.setClassSkipStatus(skipStatus);
        return result;
    }

    protected ClassMethodId tryStoreClassAndMethod(IModeledMethod method, List methodCalls, int classSkipStatus, int methodSkipStatus) throws SQLException {
        String className = method.getModeledClass().getClassName().getContainerAndPackageAndNameString();
        String methodName = method.getMethodName().getNameAndSignatureString();
        return this.tryStoreClassAndMethod(className, methodName, methodCalls, classSkipStatus, methodSkipStatus);
    }

    protected ClassMethodId tryStoreClassAndMethod(String className, String methodName, List methodCalls, int classSkipStatus, int methodSkipStatus) throws SQLException {
        ClassMethodId result = this.getClassMethodId(className, methodName);
        if (result.hasNoMethod()) {
            CompilerLogDatabaseTransaction.setCountClassMethodInserted(CompilerLogDatabaseTransaction.getCountClassMethodInserted() + 1);
            int methodId = -1;
            int classId = result.getClassId();
            methodId = this.storeMethod(methodSkipStatus, methodName, classId);
            result.setMethodId(methodId);
            this.tryStoreMethodCalls(methodCalls, methodId);
        } else {
            PreparedStatement methodInsertStatement = this.getPreparedStatement("methodUpdate", "update method set skip_status = ? where method_id = ? and skip_status <> ?");
            methodInsertStatement.setInt(2, result.getMethodId());
            methodInsertStatement.setInt(1, methodSkipStatus);
            methodInsertStatement.setInt(3, 1);
            methodInsertStatement.execute();
            this.tryStoreMethodCalls(methodCalls, result.getMethodId());
        }
        return result;
    }

    private int storeMethod(int methodSkipStatus, String methodName, int classId) throws SQLException {
        PreparedStatement methodInsertStatement = this.getPreparedStatement("methodInsert", "insert into method values (DEFAULT, ?, ?, ?)");
        methodInsertStatement.setString(1, methodName);
        methodInsertStatement.setInt(2, classId);
        methodInsertStatement.setInt(3, methodSkipStatus);
        methodInsertStatement.execute();
        int methodId = this.getLastIdCreated();
        return methodId;
    }

    private void tryStoreMethodCalls(List methodCalls, int methodId) throws SQLException {
        if (methodCalls != null) {
            PreparedStatement methodCallInsertStatement = this.getPreparedStatement("methodCallInsert", "insert into methodcall values (DEFAULT, ?, ?, ?, ?, ?)");
            int i = 0;
            while (i < methodCalls.size()) {
                DGFieldMethodRefConstant ref = (DGFieldMethodRefConstant)methodCalls.get(i);
                methodCallInsertStatement.setInt(1, methodId);
                methodCallInsertStatement.setInt(2, i);
                methodCallInsertStatement.setString(3, ref.getClassName());
                methodCallInsertStatement.setString(4, ref.getName());
                methodCallInsertStatement.setString(5, ref.getType());
                methodCallInsertStatement.execute();
                ++i;
            }
        }
    }

    protected ClassMethodId getClassMethodId(String className, String methodName) throws SQLException {
        CompilerLogDatabaseTransaction.setCountClassMethodRetrieved(CompilerLogDatabaseTransaction.getCountClassMethodRetrieved() + 1);
        ClassMethodId result = null;
        if (this.feedback.isTraceEnabled()) {
            this.feedback.trace(kModule, "Trying to get " + methodName + " in class " + className);
        }
        PreparedStatement s = this.getPreparedStatement("classMethodIdSelect", "select class.class_id, class.class_name, class.skip_status, method.method_id, method.method_name from class join method on (method.class_id = class.class_id) where class.class_name = ?  and method.method_name = ?");
        s.setString(2, methodName);
        s.setString(1, className);
        ResultSet rs = s.executeQuery();
        if (rs.next()) {
            int classId = rs.getInt(1);
            result = new ClassMethodId(classId);
            result.setClassSkipStatus(rs.getInt(3));
            result.setMethodId(rs.getInt(4));
        } else {
            result = this.tryStoreClass(className);
        }
        return result;
    }

    protected ClassMethodId getClassId(String className) throws SQLException {
        CompilerLogDatabaseTransaction.setCountClassMethodRetrieved(CompilerLogDatabaseTransaction.getCountClassMethodRetrieved() + 1);
        ClassMethodId result = null;
        if (this.feedback.isTraceEnabled()) {
            this.feedback.trace(kModule, "Trying to get class " + className);
        }
        PreparedStatement s = this.getPreparedStatement("classMethodIdSelect", "select class.class_id, class.class_name, class.skip_status from class where class.class_name = ?");
        s.setString(1, className);
        ResultSet rs = s.executeQuery();
        if (rs.next()) {
            int classId = rs.getInt(1);
            result = new ClassMethodId(classId);
            result.setClassSkipStatus(rs.getInt(3));
        } else {
            result = this.tryStoreClass(className);
        }
        return result;
    }

    protected ClassMethodId getClassMethodId(IModeledMethod method) throws SQLException {
        String className = method.getModeledClass().getClassName().getContainerAndPackageAndNameString();
        String methodName = method.getMethodName().getNameAndSignatureString();
        return this.getClassMethodId(className, methodName);
    }

    private static void setCountClassMethodInserted(int a) {
        countClassMethodInserted = a;
    }

    private static int getCountClassMethodInserted() {
        return countClassMethodInserted;
    }

    private static void setCountClassMethodRetrieved(int a) {
        countClassMethodRetrieved = a;
    }

    private static int getCountClassMethodRetrieved() {
        return countClassMethodRetrieved;
    }
}

