/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.db.DatabaseResult;
import com.wily.introscope.agent.db.DatabaseTransaction;
import com.wily.introscope.agent.db.IConnectionManager;
import com.wily.introscope.agent.db.IDynamicInstrumentationDatabaseConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;

public class ConnectionManager
implements IConnectionManager,
IDynamicInstrumentationDatabaseConstants {
    private static final String kDefaultDatabaseName = "dynamicDB";
    private static volatile boolean kInitializationResult = false;
    private static volatile boolean kHasFinishedInitializetion = false;
    private static volatile boolean kHasStartedInitializetion = false;
    private static volatile boolean kCanRerunInitialization = false;
    private static ConnectionManager sInstance;
    private static final String kCreateSuffix = ";create=true";
    private static final String kDriver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String kLogProperty = "derby.stream.error.file";
    private static final String kProtocol = "jdbc:derby:";
    private static String kPath;
    Connection c;
    Object connectionLock = new Object();
    String url;
    IModuleFeedbackChannel fFeedback;

    private ConnectionManager(IModuleFeedbackChannel feedback, String databaseConnectionString) throws Exception {
        this.fFeedback = feedback;
        this.url = databaseConnectionString;
        if (!this.loadDriver(feedback)) {
            throw new Exception("Unable to create a Connection Manager to Derby");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.c == null) {
            this.c = this.getPrivateConnection();
        }
        return this.c;
    }

    private Connection getPrivateConnection() throws SQLException {
        Connection newConn = this.getDriverManagerConnection();
        newConn.setAutoCommit(false);
        return newConn;
    }

    private Connection getDriverManagerConnection() throws SQLException {
        try {
            Connection newConn = DriverManager.getConnection(kProtocol + this.url);
            return newConn;
        }
        catch (SQLException sQLException) {
            Connection newConn = DriverManager.getConnection(kProtocol + this.url);
            return newConn;
        }
    }

    void shutdownDatabase() {
        try {
            try {
                DriverManager.getConnection(kProtocol + this.url + ";shutdown=true");
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                    this.fFeedback.info("Derby shut down normally");
                } else if (se.getErrorCode() == 45000 && "08006".equals(se.getSQLState())) {
                    this.fFeedback.info("Derby shut down normally");
                } else {
                    this.fFeedback.error("Derby did not shut down normally: " + se.getErrorCode());
                    this.fFeedback.debug((Throwable)se);
                }
                this.cleanConnections(this.fFeedback);
            }
        }
        finally {
            this.cleanConnections(this.fFeedback);
        }
    }

    private void cleanConnections(IModuleFeedbackChannel feedback) {
        try {
            if (this.c != null) {
                this.c.close();
            }
        }
        catch (SQLException e) {
            feedback.error(e.getMessage());
            feedback.debug((Throwable)e);
        }
        this.c = null;
    }

    private DatabaseResult createDatabase() {
        DatabaseResult result = null;
        Connection newConn = null;
        try {
            this.fFeedback.info("Creating database " + this.url);
            newConn = DriverManager.getConnection(kProtocol + this.url + kCreateSuffix, new Properties());
        }
        catch (SQLException e) {
            result = new DatabaseResult(e);
            result.setRecoverable(true);
            return result;
        }
        try {
            try {
                this.fFeedback.info("Connected to and created database " + this.url);
                newConn.setAutoCommit(false);
                this.listExistingTables(newConn);
                result = new DatabaseTransaction(this.fFeedback, newConn){

                    @Override
                    protected void defineTransaction() throws SQLException {
                        Statement s = this.getStatement();
                        s.execute("create table class(class_id int generated by default as identity, class_name varChar(5120), skip_status int, class_methods_processed int, is_interface int)");
                        s.execute("create index classNameIndex on class (class_name)");
                        s.execute("create index classIdIndex on class (class_id)");
                        s.execute("create table method(method_id int generated by default as identity, method_Name varChar(5120), class_id int, skip_status int)");
                        s.execute("create index methodNameIndex on method (method_Name)");
                        s.execute("create index methodClassIdIndex on method (class_id)");
                        s.execute("create index methodIdIndex on method (method_id)");
                        s.execute("create table method_trace(tracer_name varChar(5120), tracer_group_name varChar(5120), class_id int, method_id int, tracer_parameters varChar(2024), tracer_class varChar(2024), tracer_resource varchar(2048))");
                        s.execute("create index methodIdTraceIndex on method_trace (class_id)");
                        s.execute("create table methodcall(method_call_id int generated by default as identity, method_id int, call_order int, class_name varChar(5120), method_name varchar(5120), method_Type varChar(5120))");
                        s.execute("create table di_skip(skip_id int generated by default as identity, class_Name varchar(5120), method_Name varchar(5120), skip_Time timestamp, skip_Cause int )");
                        s.execute("create table di_skip_details(detail_Name varchar(5120), detail_Value varchar(512), skip_id int)");
                        s.execute("create table directive(directive_id int generated by default as identity, directive_type int, class_id int, method_id int, resource_name varchar(512), tracer_type varchar(512), group_name varchar(512), label varchar(512), is_active int, is_permanent int, is_static_active int, calling_method_id int)");
                        this.feedback.info("Created tables");
                    }
                }.executeTransaction();
            }
            catch (SQLException e) {
                this.fFeedback.debug((Throwable)e);
                try {
                    newConn.rollback();
                }
                catch (Exception e1) {
                    this.fFeedback.debug((Throwable)e1);
                }
                result = new DatabaseResult(e);
                try {
                    if (newConn != null) {
                        newConn.close();
                    }
                    newConn = null;
                }
                catch (Exception e2) {
                    this.fFeedback.debug((Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (newConn != null) {
                    newConn.close();
                }
                newConn = null;
            }
            catch (Exception e) {
                this.fFeedback.debug((Throwable)e);
            }
        }
        return result;
    }

    private void listExistingTables(Connection conn) throws SQLException {
        if (this.fFeedback.isDebugEnabled()) {
            ResultSet set = conn.getMetaData().getTables(null, null, null, null);
            int max = set.getMetaData().getColumnCount();
            boolean wroteHeader = false;
            while (set.next()) {
                if (!wroteHeader) {
                    this.fFeedback.debug("List of Tables existing in the database");
                    wroteHeader = true;
                }
                StringBuilder sb = new StringBuilder();
                int i = 1;
                while (i <= max) {
                    sb.append(set.getObject(i)).append(";");
                    ++i;
                }
                this.fFeedback.debug(sb.toString());
            }
            if (!wroteHeader) {
                this.fFeedback.debug("No tables in the database");
                wroteHeader = true;
            }
        }
    }

    private boolean loadDriver(IModuleFeedbackChannel feedback) {
        boolean success = false;
        try {
            Class.forName(kDriver, true, ConnectionManager.class.getClassLoader()).newInstance();
            feedback.info("Loaded the appropriate driver");
            success = true;
        }
        catch (ClassNotFoundException cnfe) {
            feedback.error("\nUnable to load the JDBC driver org.apache.derby.jdbc.EmbeddedDriver");
            feedback.error("Please check your CLASSPATH.");
            feedback.verbose((Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            feedback.error("\nUnable to instantiate the JDBC driver org.apache.derby.jdbc.EmbeddedDriver");
            feedback.verbose((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            feedback.error("\nNot allowed to access the JDBC driver org.apache.derby.jdbc.EmbeddedDriver");
            feedback.verbose((Throwable)iae);
        }
        return success;
    }

    private static void setLogDirectory(String value) {
        Properties p = System.getProperties();
        p.put(kLogProperty, value);
    }

    static void setPath(String input) {
        kPath = input;
    }

    static void initialize() throws AgentNotAvailableException {
        IAgent myAgent = AgentShim.getAgent();
        IModuleFeedbackChannel feedback = myAgent.IAgent_getModuleFeedback();
        String name = myAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationService().getRepositoryName();
        ConnectionManager.initialize(feedback, name, kPath);
    }

    static void initialize(String name) throws AgentNotAvailableException {
        IAgent myAgent = AgentShim.getAgent();
        IModuleFeedbackChannel feedback = myAgent.IAgent_getModuleFeedback();
        ConnectionManager.initialize(feedback, name, kPath);
    }

    static void initialize(String name, String path) throws AgentNotAvailableException {
        IAgent myAgent = AgentShim.getAgent();
        IModuleFeedbackChannel feedback = myAgent.IAgent_getModuleFeedback();
        ConnectionManager.initialize(feedback, name, path);
    }

    private static void initialize(IModuleFeedbackChannel feedback, String applicationName, String path) {
        kHasStartedInitializetion = true;
        kCanRerunInitialization = false;
        feedback.info("Agent Connection Manager is initializing");
        if (feedback.isDebugEnabled()) {
            feedback.debug("Agent Connection Manager is initializing by thread " + Thread.currentThread().getName());
        }
        final String dbName = applicationName == null ? kDefaultDatabaseName : applicationName;
        File currentLogPath = new File(path);
        String pathParent = currentLogPath.getParent();
        feedback.info("Agent Connection Manager thinks that it will find the database here:" + pathParent);
        File currentLogDir = new File(pathParent);
        if (currentLogDir != null && currentLogDir.isDirectory()) {
            feedback.info("Agent Connection Manager has the location:" + pathParent);
            feedback.info("Setting derby log:[" + pathParent + File.separatorChar + "Derby.log]");
            ConnectionManager.setLogDirectory(String.valueOf(pathParent) + File.separatorChar + "Derby.log");
            File[] files = currentLogDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dbName != null && dbName.equals(name);
                }
            });
            boolean reuse = false;
            String name = dbName;
            if (files != null && files.length > 0) {
                reuse = true;
            } else if (files != null && files.length == 0) {
                reuse = false;
            } else {
                reuse = false;
                name = String.valueOf(dbName) + "-" + new Date().getTime();
            }
            try {
                sInstance = new ConnectionManager(feedback, String.valueOf(pathParent) + File.separatorChar + name);
            }
            catch (Exception e) {
                feedback.info("Agent Connection Manager is unable to use database log", (Throwable)e);
            }
            if (sInstance != null) {
                if (reuse) {
                    DatabaseResult cleanResult = sInstance.cleanDatabase();
                    if (!cleanResult.isError()) {
                        sInstance.shutdownDatabase();
                        kInitializationResult = true;
                    } else {
                        kCanRerunInitialization = cleanResult.isRecoverable();
                        feedback.error("Unable to clean dynamic instrumentation database");
                    }
                } else {
                    DatabaseResult createResult = sInstance.createDatabase();
                    if (!createResult.isError()) {
                        sInstance.shutdownDatabase();
                        kInitializationResult = true;
                    } else {
                        kCanRerunInitialization = createResult.isRecoverable();
                        feedback.error("Unable to create dynamic instrumentation database");
                    }
                }
                try {
                    sInstance.getConnection();
                }
                catch (SQLException sQLException) {
                    feedback.error("Unable to create dynamic instrumentation database");
                    kInitializationResult = false;
                }
            }
        } else {
            feedback.error("Unable to find a place for database log");
        }
        kHasFinishedInitializetion = true;
    }

    DatabaseResult cleanDatabase() {
        DatabaseResult result = null;
        Connection newConn = null;
        try {
            this.fFeedback.info("Cleaning database " + this.url);
            newConn = DriverManager.getConnection(kProtocol + this.url, new Properties());
        }
        catch (SQLException e) {
            result = new DatabaseResult(e);
            result.setRecoverable(true);
            return result;
        }
        try {
            try {
                this.fFeedback.info("Connected to database " + this.url);
                newConn.setAutoCommit(false);
                this.listExistingTables(newConn);
                result = new DatabaseTransaction(this.fFeedback, newConn){

                    @Override
                    protected void defineTransaction() throws SQLException {
                        Statement s = this.getStatement();
                        s.execute("delete from class");
                        s.execute("delete from method");
                        s.execute("delete from method_trace");
                        s.execute("delete from methodCall");
                        s.execute("delete from di_skip");
                        s.execute("delete from di_skip_details");
                        s.execute("delete from directive");
                    }
                }.executeTransaction();
            }
            catch (SQLException e) {
                this.fFeedback.debug((Throwable)e);
                result = new DatabaseResult(e);
                try {
                    if (newConn != null) {
                        newConn.close();
                    }
                    newConn = null;
                }
                catch (SQLException e2) {
                    this.fFeedback.debug((Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (newConn != null) {
                    newConn.close();
                }
                newConn = null;
            }
            catch (SQLException e) {
                this.fFeedback.debug((Throwable)e);
            }
        }
        return result;
    }

    public static IConnectionManager Instance() {
        if (sInstance != null && sInstance.isInitialized()) {
            return sInstance;
        }
        return NullConnectionManager.Instance();
    }

    @Override
    public synchronized boolean isInitialized() {
        if (!kHasStartedInitializetion || kCanRerunInitialization) {
            try {
                ConnectionManager.initialize();
                kInitializationResult = true;
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                kInitializationResult = false;
            }
        }
        return kInitializationResult;
    }

    @Override
    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    static class NullConnectionManager
    implements IConnectionManager {
        static NullConnectionManager instance = new NullConnectionManager();

        NullConnectionManager() {
        }

        public static IConnectionManager Instance() {
            return instance;
        }

        @Override
        public Connection getConnection() throws SQLException {
            throw new SQLException("Initialization of dynamic instrumentation database was not successfull");
        }

        public Connection getSerializedTransactionConnection() throws SQLException {
            throw new SQLException("Initialization of dynamic instrumentation database was not successfull");
        }

        @Override
        public IModuleFeedbackChannel getFeedback() {
            try {
                IAgent myAgent = AgentShim.getAgent();
                IModuleFeedbackChannel feedback = myAgent.IAgent_getModuleFeedback();
                return feedback;
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                return null;
            }
        }

        public Connection getPrivateConnection() throws SQLException {
            throw new SQLException("Initialization of dynamic instrumentation database was not successfull");
        }

        @Override
        public boolean isInitialized() {
            return false;
        }
    }
}

