/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.bit;

public class BitPacking {
    static int[] kBitMask;
    static int[] kCleanMask;
    private static final int[] kNumberOfBits;

    public static int bitLengthOfByte(int byteValue) {
        return kNumberOfBits[byteValue];
    }

    public static int bitLengthOfInt(int val) {
        int tmp = val >> 24 & 0xFF;
        if (tmp != 0) {
            return kNumberOfBits[tmp] + 24;
        }
        tmp = val >> 16 & 0xFF;
        if (tmp != 0) {
            return kNumberOfBits[tmp] + 16;
        }
        tmp = val >> 8 & 0xFF;
        if (tmp != 0) {
            return kNumberOfBits[tmp] + 8;
        }
        tmp = val & 0xFF;
        return kNumberOfBits[tmp];
    }

    public static int bitLengthOfLong(long val) {
        int hiPart = (int)(val >> 32 & 0xFFFFFFFFFFFFFFFFL);
        if (hiPart != 0) {
            return BitPacking.bitLengthOfInt(hiPart) + 32;
        }
        int lowPart = (int)(val & 0xFFFFFFFFFFFFFFFFL);
        return BitPacking.bitLengthOfInt(lowPart);
    }

    public static int getIntBufferSize(int numBits) {
        return numBits + 31 >> 5;
    }

    public static void writeBytes(int[] buf, int bitIndex, byte[] bytes) {
        int iter = 0;
        while (iter < bytes.length) {
            BitPacking.writeInt(buf, bitIndex, 8, (int)bytes[iter]);
            ++iter;
            bitIndex += 8;
        }
    }

    public static byte[] readBytes(int[] buf, int bitIndex, int numBytes) {
        byte[] bytes = new byte[numBytes];
        int iter = 0;
        while (iter < numBytes) {
            bytes[iter] = (byte)BitPacking.readInt(buf, bitIndex, 8);
            ++iter;
            bitIndex += 8;
        }
        return bytes;
    }

    public static void writeInt(int[] dst, int bitIndex, int bitLength, int paramVal) {
        int val = paramVal << 32 - bitLength;
        int arrayIndex = bitIndex >> 5;
        if ((bitIndex &= 0x1F) != 0) {
            int currentVal = dst[arrayIndex];
            int newValue = currentVal | val >>> bitIndex;
            dst[arrayIndex++] = newValue;
            bitLength -= 32 - bitIndex;
            val <<= 32 - bitIndex;
        }
        if (bitLength > 0) {
            dst[arrayIndex] = val;
        }
    }

    public static void writeLong(int[] dst, int bitIndex, int bitLength, long val) {
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            BitPacking.writeInt(dst, bitIndex, numHighBits, (int)(val >> 32));
            bitIndex += numHighBits;
            bitLength = 32;
        }
        BitPacking.writeInt(dst, bitIndex, bitLength, (int)(val & 0xFFFFFFFFFFFFFFFFL));
    }

    public static void writeInt(byte[] b, int bitIndex, int bitLength, int paramVal) {
        int newValue;
        int val = paramVal << 32 - bitLength;
        int byteIndex = bitIndex >> 3;
        int dstShift = bitIndex & 7;
        if (dstShift != 0) {
            int currentVal = b[byteIndex] & 0xFF;
            newValue = currentVal | val >>> 24 + dstShift;
            b[byteIndex++] = (byte)(newValue & 0xFF);
            bitLength -= 8 - dstShift;
            val <<= 8 - dstShift;
        }
        while (bitLength > 0) {
            newValue = val >>> 24;
            b[byteIndex++] = (byte)(newValue & 0xFF);
            bitLength -= 8;
            val <<= 8;
        }
    }

    public static void writeLong(byte[] b, int bitIndex, int bitLength, long val) {
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            BitPacking.writeInt(b, bitIndex, numHighBits, (int)(val >> 32));
            bitIndex += numHighBits;
            bitLength = 32;
        }
        BitPacking.writeInt(b, bitIndex, bitLength, (int)(val & 0xFFFFFFFFFFFFFFFFL));
    }

    public static int readInt(int[] src, int bitIndex, int bitLength) {
        int result = 0;
        int arrayIndex = bitIndex >> 5;
        int maxFirstLength = 32 - (bitIndex &= 0x1F);
        int getLength = BitPacking.min(maxFirstLength, bitLength);
        result = src[arrayIndex] << bitIndex >>> 32 - getLength;
        if ((bitLength -= getLength) > 0) {
            result = result << bitLength | src[++arrayIndex] >>> 32 - bitLength;
        }
        return result;
    }

    public static int readInt(byte[] b, int bitIndex, int bitLength) {
        int newValue;
        int result = 0;
        int byteIndex = bitIndex >> 3;
        int byteOffset = bitIndex & 7;
        if (byteOffset != 0) {
            int bitsToGet = 8 - byteOffset;
            newValue = b[byteIndex++] & kBitMask[bitsToGet];
            if (bitLength < bitsToGet) {
                newValue >>>= bitsToGet - bitLength;
                bitsToGet = bitLength;
            }
            result = newValue;
            bitLength -= bitsToGet;
        }
        while (bitLength > 8) {
            newValue = b[byteIndex++] & 0xFF;
            result = result << 8 | newValue;
            bitLength -= 8;
        }
        if (bitLength > 0) {
            newValue = (b[byteIndex] & 0xFF) >>> 8 - bitLength;
            result = result << bitLength | newValue;
        }
        return result;
    }

    public static long readLong(byte[] b, int bitIndex, int bitLength) {
        long result = 0L;
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            int hiVal = BitPacking.readInt(b, bitIndex, numHighBits);
            result = (long)hiVal << 32;
            bitIndex += numHighBits;
            bitLength = 32;
        }
        return result |= (long)BitPacking.readInt(b, bitIndex, bitLength) & 0xFFFFFFFFL;
    }

    public static long readLong(int[] dst, int bitIndex, int bitLength) {
        long result = 0L;
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            int hiVal = BitPacking.readInt(dst, bitIndex, numHighBits);
            result = (long)hiVal << 32;
            bitIndex += numHighBits;
            bitLength = 32;
        }
        return result |= (long)BitPacking.readInt(dst, bitIndex, bitLength) & 0xFFFFFFFFL;
    }

    public static void writeBytes(byte[] buf, int bitIndex, int bitLength, byte[] bytes) {
    }

    public static byte[] readBytes(byte[] buf, int bitIndex, int bitLength) {
        return null;
    }

    private static int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    static {
        int i;
        kBitMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
        kCleanMask = new int[32];
        kNumberOfBits = new int[256];
        int shift = 1;
        for (i = 0; i < 256; ++i) {
            if (i == 1 << shift) {
                // empty if block
            }
            BitPacking.kNumberOfBits[i] = ++shift;
        }
        for (i = 1; i < 32; ++i) {
            BitPacking.kCleanMask[i] = Integer.MIN_VALUE >> i - 1;
        }
    }
}

