/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteResultByNamedProxyTransformationBuilder;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public class SubstituteResultByNamedProxyTransformation
extends AEveryMethodTransformation {
    private TracerGroup tracerGroup;
    private IMethodName sourceMethod;
    private String substituterName;
    private IMethodMatcher methodMatcher;
    private IClassName instrumentationClass;

    public SubstituteResultByNamedProxyTransformation(ICompilerLog log, IClassName instrumentationClass, IMethodName sourceMethod, String substituterName) {
        this(log, instrumentationClass, null, sourceMethod, substituterName);
    }

    public SubstituteResultByNamedProxyTransformation(ICompilerLog log, IClassName instrumentationClass, TracerGroup tracerGroup, IMethodName sourceMethod, String substituterName) {
        super(log);
        this.instrumentationClass = instrumentationClass;
        this.tracerGroup = tracerGroup;
        this.sourceMethod = sourceMethod;
        this.substituterName = substituterName;
        this.methodMatcher = new NamedMethodMatcher(this.getSourceMethod());
    }

    public IClassName getInstrumentationClass() {
        return this.instrumentationClass;
    }

    private TracerGroup getTracerGroup() {
        return this.tracerGroup;
    }

    private IMethodName getSourceMethod() {
        return this.sourceMethod;
    }

    public String getSubstituterName() {
        return this.substituterName;
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new SubstituteResultByNamedProxyTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getSourceMethod(), this.getSubstituterName());
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newSubstituteResultByNamedProxyMethodMutation(settings, targetMethod, this);
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return this.methodMatcher.IMethodMatcher_matches(targetMethod) && targetMethod.hasBytecode();
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && this.getTracerGroup().getClassMatcher().IClassMatcher_matches(targetClass);
    }
}

