/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.errors;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStack;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.errors.ErrorReportingService;
import com.wily.introscope.agent.errors.IErrorSnapshotFeature;
import com.wily.introscope.agent.errors.Log;
import com.wily.introscope.agent.errors.Throttle;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.spec.server.transactiontrace.AgentSideErrorTransactionTraceFilter;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ErrorSnapshotFeature
implements IBlameStackFeature,
IErrorSnapshotFeature {
    private BlameStackFeatureBlameStack stack;
    private Throttle throttle;
    private String errorString;
    public static final String NoErrorString = "NoError";
    private final ComponentTracer fComponentTracer;
    private IAgent fAgent;
    public IConfigurationListener fListener;
    private Set errorStrings;

    public ErrorSnapshotFeature(Throttle throttle, BlameStackFeatureBlameStack blameStack, ComponentTracer componentTracer) {
        this.throttle = throttle;
        this.stack = blameStack;
        this.fComponentTracer = componentTracer;
        this.errorStrings = new HashSet();
        this.errorString = NoErrorString;
        try {
            this.fAgent = AgentShim.getAgent();
            this.fListener = new IConfigurationListener(){

                @Override
                public void onChange(IndexedProperties props) {
                    ErrorSnapshotFeature.this.updateThrottleCount(props);
                }
            };
            this.fAgent.addConfigurationListener(this.fListener);
        }
        catch (AgentNotAvailableException anae) {
            AgentShim.handleError("ErrorSnapshotFeature cannot access agent through AgentShim", anae);
        }
    }

    @Override
    public void onBeforePush(BlameStackFeatureStackEntry entry) {
    }

    @Override
    public void onAfterPop(BlameStackFeatureStackEntry poppedEntry, BlameStackFeatureStackEntry newTopEntry) {
        if (this.errorString != NoErrorString) {
            if (ErrorReportingService.fIsSnapshotEnabled) {
                this.sendErrorSnapshot(poppedEntry);
            }
            this.errorString = NoErrorString;
        }
    }

    @Override
    public boolean flagErrorInManagedApplication(String errorMessage) {
        boolean result = false;
        if (!this.stack.IBlameStack_isEmpty() && this.errorString == NoErrorString && this.errorStrings.add(errorMessage)) {
            this.errorString = errorMessage;
            AgentSideErrorTransactionTraceFilter.AnyErrorFlag.set(Boolean.TRUE);
            this.annotateFrameWithError(errorMessage);
            result = true;
        }
        return result;
    }

    private void sendErrorSnapshot(BlameStackFeatureStackEntry poppedEntry) {
        if (!this.throttle.request()) {
            Log.out.debug("Throttling an error snapshot");
            return;
        }
        Log.out.debug("Sending an error snapshot");
        HashMap<String, String> rootParams = new HashMap<String, String>();
        rootParams.put("Trace Type", "ErrorSnapshot");
        this.stack.makeAndSendSnapshot(poppedEntry, rootParams);
    }

    @Override
    public void tearDown() {
    }

    @Override
    public void setFrontBoundary(String component) {
    }

    @Override
    public void setEndBoundary(String component) {
    }

    public void annotateFrameWithError(String string) {
        String limitedString = InvocationData.limitSize(string);
        this.fComponentTracer.addExtraParameter("Error Message", limitedString);
    }

    @Override
    public void reset() {
        this.errorStrings.clear();
    }

    @Override
    public void setThrottle(Throttle throttle) {
        this.throttle = throttle;
    }

    public void updateThrottleCount(IndexedProperties indexedProps) {
        int throttleCount = indexedProps.safeGetPositiveIntProperty("introscope.agent.errorsnapshots.throttle", 10, this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer());
        this.throttle.setThrottle(throttleCount);
    }
}

