/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.INotAnOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IStackElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.clock.MasterClock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class VirtualStackFeatureHelper {
    public static TransactionComponentData getTransactionSnapshotFromStack(IStackElement data, Runnable t, Throwable error, String errorMessage) {
        final Stack stack = new Stack();
        IStackElement cursorData = data;
        StackRecursionHelper.staticSafeRecurseAccessParent(cursorData, new IStackElementCallbackOnRecursion(){

            @Override
            public boolean doOnElement(IStackElement pivot) {
                if (!(pivot instanceof INotAnOldModeStallSubscriber) && !(pivot instanceof WrappedInvocationData)) {
                    stack.push(pivot);
                }
                return false;
            }
        });
        IStackElement popped = (IStackElement)stack.pop();
        Throwable errorForData = null;
        errorForData = popped == data ? error : null;
        TransactionComponentData root = null;
        long eventTime = MasterClock.currentTimeMillis();
        root = popped instanceof InvocationData ? VirtualStackFeatureHelper.getTransanctionSnapShotFromInvocationData(t, errorMessage, errorForData, (InvocationData)popped, eventTime) : VirtualStackFeatureHelper.getTransanctionSnapshotFromStackElement(t, errorMessage, errorForData, popped, eventTime);
        if (root == null) {
            return null;
        }
        TransactionComponentData cursor = null;
        cursor = VirtualStackFeatureHelper.getLastComponent(root);
        if (cursor != null) {
            TransactionComponentData bizDefComponent;
            while (!stack.isEmpty()) {
                popped = (IStackElement)stack.pop();
                errorForData = popped == data ? error : null;
                TransactionComponentData child = null;
                child = popped instanceof InvocationData ? VirtualStackFeatureHelper.getTransanctionSnapShotFromInvocationData(t, errorMessage, errorForData, (InvocationData)popped, eventTime) : VirtualStackFeatureHelper.getTransanctionSnapshotFromStackElement(t, errorMessage, errorForData, popped, eventTime);
                if (child == null) continue;
                cursor.tempChildren.add(child);
                VirtualStackFeatureHelper.realizeSubcomponent(cursor);
                cursor = VirtualStackFeatureHelper.getLastComponent(child);
            }
            if (!root.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(root)) != null) {
                VirtualStackFeatureHelper.realizeSubcomponent(bizDefComponent);
                root = bizDefComponent;
            }
            root.setParameterValue("Trace Type", "ErrorSnapshot");
        }
        return root;
    }

    private static TransactionComponentData getLastComponent(TransactionComponentData root) {
        TransactionComponentData temp = root;
        while (temp.getSubNodeCount() > 0) {
            temp = (TransactionComponentData)temp.getSubNode(0);
        }
        return temp;
    }

    private static void fillComponentParams(TransactionComponentData component, InvocationData data, Runnable t, String errorMessage, Throwable error) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        component.setParameters(parameters);
        parameters.put("Method", data.getProbeInformation().getProbeIdentification().getProbeMethodName());
        parameters.put("Method Descriptor", data.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor());
        parameters.put("Class", data.getProbeInformation().getProbeIdentification().getRuntimeFullClassName());
        String lineInfo = data.getProbeInformation().getProbeIdentification().getSourceFileLine();
        if (lineInfo != null) {
            parameters.put("Source Line", lineInfo);
        }
        parameters.put("Resource Name", component.getResource());
        data.addParameterCallbacks(parameters);
        IFactoryLevelParameterCallback[] staticCallbacks = data.getProbeInformation().getCallbacks();
        int i = 0;
        while (i < staticCallbacks.length) {
            if (staticCallbacks[i] != null) {
                staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
            }
            ++i;
        }
        if (t instanceof Thread) {
            Thread thread = (Thread)t;
            ThreadGroup tg = thread.getThreadGroup();
            if (tg == null) {
                try {
                    if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                        AgentShim.getAgent().IAgent_getModuleFeedback().debug("Threadgroup for thread is null");
                    }
                }
                catch (AgentNotAvailableException agentNotAvailableException) {}
            } else {
                String threadGroupName;
                String threadName = InvocationData.limitSize(thread.getName());
                if (threadName != null) {
                    parameters.put("Thread Name", threadName);
                }
                if ((threadGroupName = InvocationData.limitSize(tg.getName())) != null) {
                    parameters.put("Thread Group Name", threadGroupName);
                }
            }
        } else if (t != null) {
            String threadName = InvocationData.limitSize(t.toString());
            if (threadName != null) {
                parameters.put("Thread Name", threadName);
            }
            parameters.put("Thread Group Name", "NA");
        }
        if (errorMessage != null) {
            parameters.put("Error Message", InvocationData.limitSize(errorMessage));
            parameters.put("Trace Type", "ErrorSnapshot");
            if (error != null) {
                parameters.put("Exception", InvocationData.limitSize(errorMessage));
            }
        }
    }

    public static TransactionComponentData getTransanctionSnapShotFromInvocationData(Runnable t, String errorMessage, Throwable error, InvocationData data, long eventTime) {
        if (data.getCursor() == null) {
            return null;
        }
        long startTime = data.getWallClockStartTime();
        long roughlyDuration = eventTime - startTime;
        TransactionComponentData root = null;
        TransactionComponentData curComponent = null;
        TransactionComponentData nextComponent = null;
        boolean isRootComponentAlreadySet = false;
        int i = 0;
        while (i < data.getStartCursorsCount()) {
            ITransactionElement element = data.getStartCursorAt(i);
            if (element instanceof BlameTransactionElement) {
                nextComponent = TransactionComponentData.createMilliSecTransactionComponentData(((BlameTransactionElement)element).getComponentName(), startTime, roughlyDuration);
                VirtualStackFeatureHelper.fillComponentParams(nextComponent, data, t, errorMessage, error);
                nextComponent.tempChildren = new ArrayList(4);
                if (!isRootComponentAlreadySet) {
                    curComponent = root = nextComponent;
                    isRootComponentAlreadySet = true;
                } else {
                    curComponent.tempChildren.add(nextComponent);
                    curComponent = nextComponent;
                }
            }
            ++i;
        }
        VirtualStackFeatureHelper.realizeSubcomponent(root);
        return root;
    }

    public static TransactionComponentData getTransanctionSnapshotFromStackElement(Runnable t, String errorMessage, Throwable error, IStackElement data, long eventTime) {
        long startTime = data.getWallClockStartTime();
        long duration = eventTime - startTime;
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(data.getComponentName(), startTime, duration);
        HashMap<String, String> parameters = new HashMap<String, String>();
        component.setParameters(parameters);
        if (data != null) {
            VirtualStack.addParameterCallbacks(parameters, data);
            data.addParameterCallbacks(parameters);
        }
        if (error != null) {
            parameters.put("Exception", error.getMessage());
        }
        if (errorMessage != null) {
            parameters.put("Error Message", errorMessage);
        }
        component.tempChildren = new ArrayList(4);
        return component;
    }

    public static void realizeSubcomponent(TransactionComponentData root) {
        List tempChildren = root.tempChildren;
        int size = tempChildren.size();
        if (size == 0) {
            root.setSubNodes(TransactionComponentData.kNoCalledComponents);
        } else {
            TransactionComponentData[] subComponent = new TransactionComponentData[size];
            root.setSubNodes(tempChildren.toArray(subComponent));
            int j = 0;
            while (j < size) {
                VirtualStackFeatureHelper.realizeSubcomponent(subComponent[j]);
                ++j;
            }
        }
    }
}

