/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stat;

import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.CumulativeCounterDataAccumulator;
import com.wily.introscope.agent.stat.DeterministicIntegerDataAccumulator;
import com.wily.introscope.agent.stat.IConstantDataAccumulator;
import com.wily.introscope.agent.stat.ICumulativeCounterDataAccumulator;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IDataAccumulatorTracker;
import com.wily.introscope.agent.stat.IDeterministicDataAccumulator;
import com.wily.introscope.agent.stat.IDeterministicIntegerDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerConstantDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerMonotonicallyIncreasingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerSaturationDataAccumulator;
import com.wily.introscope.agent.stat.ILongAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongConstantDataAccumulator;
import com.wily.introscope.agent.stat.ILongCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongMonotonicallyIncreasingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringConstantDataAccumulator;
import com.wily.introscope.agent.stat.IStringDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.agent.stat.IntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IntegerConstantDataAccumulator;
import com.wily.introscope.agent.stat.IntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IntegerMonotonicallyIncreasingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IntegerRateDataAccumulator;
import com.wily.introscope.agent.stat.IntegerSaturationDataAccumulator;
import com.wily.introscope.agent.stat.LongAverageDataAccumulator;
import com.wily.introscope.agent.stat.LongConstantDataAccumulator;
import com.wily.introscope.agent.stat.LongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.LongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.stat.LongMonotonicallyIncreasingCounterDataAccumulator;
import com.wily.introscope.agent.stat.NullAccumulatorInvocationHandler;
import com.wily.introscope.agent.stat.StringConstantDataAccumulator;
import com.wily.introscope.agent.stat.StringEveryEventDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.spec.metric.ConstantValueCannotChangeException;
import com.wily.introscope.spec.metric.InternalException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.util.StringUtils;
import com.wily.util.adt.WeakWeakIdentityHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DataAccumulatorFactory {
    private static final int kSafeMetricNameArbitraryCeiling = 100;
    private static final Module kModule = new Module("DataAccumulatorFactory");
    private final IDataAccumulatorTracker fTracker;
    private final IModuleFeedbackChannel fFeedbackChannel;
    private final IStringLocalizer fStringLocalizer;
    private final AccumulatorCache fCache;
    private int fAccumulatorClamp;
    private static final IDataAccumulator kNullDataAccumulator = new NullAccumulatorImpl();
    private IDeterministicDataAccumulator fNullDeterministicDataAccumulator;
    private NullAccumulatorInvocationHandler fNullAccumulatorInvocationHandler;
    private static int fRemovalMetricKey;
    private static volatile int metricRemovedCount;

    static {
        metricRemovedCount = 0;
    }

    public DataAccumulatorFactory(IDataAccumulatorTracker tracker, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.fTracker = tracker;
        this.fFeedbackChannel = feedback;
        this.fStringLocalizer = localizer;
        this.fCache = new AccumulatorCache();
        this.fAccumulatorClamp = -1;
        this.fNullAccumulatorInvocationHandler = new NullAccumulatorInvocationHandler();
    }

    private IDataAccumulatorTracker getDataAccumulatorTracker() {
        return this.fTracker;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedbackChannel;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public final IIntegerConstantDataAccumulator safeGetIntegerConstantDataAccumulator(String metricName, int value) {
        return this.safeGetIntegerConstantDataAccumulator(metricName, value, 17);
    }

    public final ILongConstantDataAccumulator safeGetLongConstantDataAccumulator(String metricName, long value) {
        return this.safeGetLongConstantDataAccumulator(metricName, value, 18);
    }

    public final ILongConstantDataAccumulator safeGetTimestampConstantDataAccumulator(String metricName, long value) {
        return this.safeGetLongConstantDataAccumulator(metricName, value, 2066);
    }

    public final IStringConstantDataAccumulator safeGetStringConstantDataAccumulator(String metricName, String value) {
        return this.safeGetStringConstantDataAccumulator(metricName, value, 21);
    }

    public final IIntegerAverageDataAccumulator safeGetIntegerAverageDataAccumulator(String metricName) {
        return this.safeGetIntegerAverageDataAccumulator(metricName, 1025);
    }

    public final IIntegerAverageDataAccumulator safeGetFrontendIntegerAverageDataAccumulator(String metricName) {
        return this.safeGetIntegerAverageDataAccumulator(metricName, 0x10000401);
    }

    public final IIntegerAverageDataAccumulator safeGetBackendIntegerAverageDataAccumulator(String metricName) {
        return this.safeGetIntegerAverageDataAccumulator(metricName, 536871937);
    }

    public final IIntegerAverageDataAccumulator safeGetBizTrxIntegerAverageDataAccumulator(String metricName) {
        return this.safeGetIntegerAverageDataAccumulator(metricName, 0x40000401);
    }

    public final IIntegerAverageDataAccumulator safeGetIntegerPercentageDataAccumulator(String metricName) {
        return this.safeGetIntegerAverageDataAccumulator(metricName, 4097);
    }

    public final IIntegerAverageDataAccumulator safeGetIntegerPercentageDataAccumulator(String metricName, int modifiers) {
        return this.safeGetIntegerAverageDataAccumulator(metricName, 0x1001 | modifiers);
    }

    public final IIntegerRateDataAccumulator safeGetIntegerRateDataAccumulator(String metricName) {
        return this.safeGetIntegerRateDataAccumulator(metricName, 513);
    }

    public final IIntegerSaturationDataAccumulator safeGetIntegerSaturationDataAccumulator(String metricName) {
        return this.safeGetIntegerSaturationDataAccumulator(metricName, 16385);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetIntegerFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerFluctuatingCounterDataAccumulator(metricName, 257);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetFrontendIntegerFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerFluctuatingCounterDataAccumulator(metricName, 0x10000101);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetBackendIntegerFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerFluctuatingCounterDataAccumulator(metricName, 0x20000101);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetBizTrxIntegerFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerFluctuatingCounterDataAccumulator(metricName, 0x40000101);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(metricName, 385);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetFrontendIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(metricName, 0x10000181);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetBackendIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(metricName, 536871297);
    }

    public final IIntegerFluctuatingCounterDataAccumulator safeGetBizTrxIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(metricName, 1073742209);
    }

    public final IDeterministicIntegerDataAccumulator safeGetDeterministicIntegerFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetDeterministicIntegerDataAccumulator(metricName, 257);
    }

    public final IIntegerMonotonicallyIncreasingCounterDataAccumulator safeGetIntegerMonotonicallyIncreasingCounterDataAccumulator(String metricName) {
        return this.safeGetIntegerMonotonicallyIncreasingCounterDataAccumulator(metricName, 0x100101);
    }

    public final ILongAverageDataAccumulator safeGetLongAverageDataAccumulator(String metricName) {
        return this.safeGetLongAverageDataAccumulator(metricName, 1026);
    }

    public final ILongAverageDataAccumulator NON_UNIQUE_NAME_safeGetLongAverageDataAccumulator(String metricName) {
        return this.safeGetLongAverageDataAccumulator(metricName, 1026, false);
    }

    public final ILongFluctuatingCounterDataAccumulator safeGetLongFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetLongFluctuatingCounterDataAccumulator(metricName, 258);
    }

    public final ILongFluctuatingCounterDataAccumulator NON_UNIQUE_NAME_safeGetLongFluctuatingCounterDataAccumulator(String metricName) {
        return this.safeGetLongFluctuatingCounterDataAccumulator(metricName, 258, false);
    }

    public final ILongMonotonicallyIncreasingCounterDataAccumulator safeGetLongMonotonicallyIncreasingCounterDataAccumulator(String metricName) {
        return this.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(metricName, 0x100102);
    }

    public final ILongMonotonicallyIncreasingCounterDataAccumulator safeGetTimestampDataAccumulator(String metricName) {
        return this.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(metricName, 2050);
    }

    public final ILongIntervalCounterDataAccumulator safeGetLongIntervalCounterDataAccumulator(String metricName) {
        return this.safeGetLongIntervalCounterDataAccumulator(metricName, 8194);
    }

    public final ICumulativeCounterDataAccumulator safeGetCumulativeCounterDataAccumulator(String metricName) {
        return this.safeGetCumulativeCounterDataAccumulator(metricName, 0x802002);
    }

    public final ILongIntervalCounterDataAccumulator safeGetFrontendLongIntervalCounterDataAccumulator(String metricName) {
        return this.safeGetLongIntervalCounterDataAccumulator(metricName, 0x10002002);
    }

    public final ILongIntervalCounterDataAccumulator safeGetBackendLongIntervalCounterDataAccumulator(String metricName) {
        return this.safeGetLongIntervalCounterDataAccumulator(metricName, 0x20002002);
    }

    public final ILongIntervalCounterDataAccumulator safeGetBizTrxLongIntervalCounterDataAccumulator(String metricName) {
        return this.safeGetLongIntervalCounterDataAccumulator(metricName, 0x40002002);
    }

    public final ILongIntervalCounterDataAccumulator NON_UNIQUE_NAME_safeGetLongIntervalCounterDataAccumulator(String metricName) {
        return this.safeGetLongIntervalCounterDataAccumulator(metricName, 8194, false);
    }

    private ILongIntervalCounterDataAccumulator safeGetLongIntervalCounterDataAccumulator(String metricName, int metricType, boolean requireUniqueName) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric", requireUniqueName);
            return (ILongIntervalCounterDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    public final IStringEveryEventDataAccumulator safeGetStringEveryEventDataAccumulator(String metricName) {
        return this.safeGetStringEveryEventDataAccumulator(metricName, 4101);
    }

    public final IStringEveryEventDataAccumulator safeGetSystemLogDataAccumulator(String metricName) {
        return this.safeGetStringEveryEventDataAccumulator(metricName, 8453);
    }

    public final IStringEveryEventDataAccumulator safeGetThrownExceptionDataAccumulator(String metricName) {
        return this.safeGetStringEveryEventDataAccumulator(metricName, 4613);
    }

    public final IStringEveryEventDataAccumulator safeGetCaughtExceptionDataAccumulator(String metricName) {
        return this.safeGetStringEveryEventDataAccumulator(metricName, 5125);
    }

    public final IIntegerConstantDataAccumulator getIntegerConstantDataAccumulator(String metricName, int value) throws BadlyFormedNameException, ConflictingTypesException, ConstantValueCannotChangeException {
        return this.getIntegerConstantDataAccumulator(metricName, value, 17);
    }

    public final ILongConstantDataAccumulator getLongConstantDataAccumulator(String metricName, long value) throws BadlyFormedNameException, ConflictingTypesException, ConstantValueCannotChangeException {
        return this.getLongConstantDataAccumulator(metricName, value, 18);
    }

    public final ILongConstantDataAccumulator getTimestampConstantDataAccumulator(String metricName, long value) throws BadlyFormedNameException, ConflictingTypesException, ConstantValueCannotChangeException {
        return this.getLongConstantDataAccumulator(metricName, value, 2066);
    }

    public final IStringConstantDataAccumulator getStringConstantDataAccumulator(String metricName, String value) throws BadlyFormedNameException, ConflictingTypesException, ConstantValueCannotChangeException {
        return this.getStringConstantDataAccumulator(metricName, value, 21);
    }

    public final IIntegerAverageDataAccumulator getIntegerAverageDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getIntegerAverageDataAccumulator(metricName, 1025);
    }

    public final IIntegerAverageDataAccumulator getIntegerPercentageDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getIntegerAverageDataAccumulator(metricName, 4097);
    }

    public final IIntegerRateDataAccumulator getIntegerRateDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getIntegerRateDataAccumulator(metricName, 513);
    }

    public final IIntegerFluctuatingCounterDataAccumulator getIntegerFluctuatingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getIntegerFluctuatingCounterDataAccumulator(metricName, 257);
    }

    public final IDeterministicIntegerDataAccumulator getDeterministicIntegerFluctuatingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getDeterministicIntegerDataAccumulator(metricName, 257);
    }

    public final IIntegerMonotonicallyIncreasingCounterDataAccumulator getIntegerMonotonicallyIncreasingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getIntegerMonotonicallyIncreasingCounterDataAccumulator(metricName, 0x100101);
    }

    public final ILongAverageDataAccumulator getLongAverageDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getLongAverageDataAccumulator(metricName, 1026);
    }

    public final ILongFluctuatingCounterDataAccumulator getLongFluctuatingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getLongFluctuatingCounterDataAccumulator(metricName, 258);
    }

    public final ILongMonotonicallyIncreasingCounterDataAccumulator getLongMonotonicallyIncreasingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getLongMonotonicallyIncreasingCounterDataAccumulator(metricName, 0x100102);
    }

    public final IIntegerSaturationDataAccumulator getIntegerSaturationDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, 16385);
            return (IIntegerSaturationDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    public final ILongMonotonicallyIncreasingCounterDataAccumulator getTimestampDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getLongMonotonicallyIncreasingCounterDataAccumulator(metricName, 2050);
    }

    public final ILongIntervalCounterDataAccumulator getLongIntervalCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getLongIntervalCounterDataAccumulator(metricName, 8194);
    }

    public final IStringEveryEventDataAccumulator getStringEveryEventDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getStringEveryEventDataAccumulator(metricName, 4101);
    }

    public final IStringEveryEventDataAccumulator getSystemLogDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getStringEveryEventDataAccumulator(metricName, 8453);
    }

    public final IStringEveryEventDataAccumulator getThrownExceptionDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getStringEveryEventDataAccumulator(metricName, 4613);
    }

    public final IStringEveryEventDataAccumulator getCaughtExceptionDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException {
        return this.getStringEveryEventDataAccumulator(metricName, 5125);
    }

    public final IIntegerConstantDataAccumulator createIntegerConstantDataAccumulator(String metricName, int value) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createIntegerConstantDataAccumulator(metricName, value, 17);
    }

    public final ILongConstantDataAccumulator createLongConstantDataAccumulator(String metricName, long value) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createLongConstantDataAccumulator(metricName, value, 18);
    }

    public final ILongConstantDataAccumulator createTimestampConstantDataAccumulator(String metricName, long value) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createLongConstantDataAccumulator(metricName, value, 2066);
    }

    public final IStringConstantDataAccumulator createStringConstantDataAccumulator(String metricName, String value) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createStringConstantDataAccumulator(metricName, value, 21);
    }

    public final IIntegerAverageDataAccumulator createIntegerAverageDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createIntegerAverageDataAccumulator(metricName, 1025);
    }

    public final IIntegerAverageDataAccumulator createIntegerPercentageDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createIntegerAverageDataAccumulator(metricName, 4097);
    }

    public final IIntegerRateDataAccumulator createIntegerRateDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createIntegerRateDataAccumulator(metricName, 513);
    }

    public final IIntegerFluctuatingCounterDataAccumulator createIntegerFluctuatingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createIntegerFluctuatingCounterDataAccumulator(metricName, 257);
    }

    public final IDeterministicIntegerDataAccumulator createDeterministicIntegerFluctuatingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createDeterministicIntegerDataAccumulator(metricName, 257);
    }

    public final IIntegerMonotonicallyIncreasingCounterDataAccumulator createIntegerMonotonicallyIncreasingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createIntegerMonotonicallyIncreasingCounterDataAccumulator(metricName, 0x100101);
    }

    public final IIntegerSaturationDataAccumulator createIntegerSaturationDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, 16385);
            return (IIntegerSaturationDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    public final ILongAverageDataAccumulator createLongAverageDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createLongAverageDataAccumulator(metricName, 1026);
    }

    public final ILongFluctuatingCounterDataAccumulator createLongFluctuatingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createLongFluctuatingCounterDataAccumulator(metricName, 258);
    }

    public final ILongMonotonicallyIncreasingCounterDataAccumulator createLongMonotonicallyIncreasingCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createLongMonotonicallyIncreasingCounterDataAccumulator(metricName, 0x100102);
    }

    public final ILongMonotonicallyIncreasingCounterDataAccumulator createTimestampDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createLongMonotonicallyIncreasingCounterDataAccumulator(metricName, 2050);
    }

    public final ILongIntervalCounterDataAccumulator createLongIntervalCounterDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createLongIntervalCounterDataAccumulator(metricName, 8194);
    }

    public final IStringEveryEventDataAccumulator createStringEveryEventDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createStringEveryEventDataAccumulator(metricName, 4101);
    }

    public final IStringEveryEventDataAccumulator createSystemLogDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createStringEveryEventDataAccumulator(metricName, 8453);
    }

    public final IStringEveryEventDataAccumulator createThrownExceptionDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createStringEveryEventDataAccumulator(metricName, 4613);
    }

    public final IStringEveryEventDataAccumulator createCaughtExceptionDataAccumulator(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.createStringEveryEventDataAccumulator(metricName, 5125);
    }

    public final void removeMetric(String fullMetricName) throws BadlyFormedNameException, MetricNotFoundException {
        AgentMetric metric = AgentMetric.removeAgentMetric(fullMetricName);
        this.untrackAccumulatorForMetric(metric);
    }

    public final void removeMetric(AgentMetric metric) {
        metric.remove();
        this.untrackAccumulatorForMetric(metric);
    }

    public final void removeMetricCache(AgentMetric metric) {
        metric.remove();
        this.untrackAccumulatorForMetricCache(metric);
    }

    public final void removeDataAccumulator(IDataAccumulator accumulator) {
        try {
            AgentMetric metric = accumulator.IDataAccumulator_getMetric();
            if (metric != null) {
                metric.remove();
                this.untrackAccumulatorForMetric(metric);
            }
        }
        catch (NullPointerException ex) {
            this.getFeedbackChannel().debug(kModule, "IDataAccumulator object is null", ex);
        }
    }

    private IIntegerConstantDataAccumulator safeGetIntegerConstantDataAccumulator(String metricName, int value, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer constant metric");
            return this.safeGetIntegerConstantDataAccumulator(metric, value);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongConstantDataAccumulator safeGetLongConstantDataAccumulator(String metricName, long value, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long constant metric");
            return this.safeGetLongConstantDataAccumulator(metric, value);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IStringConstantDataAccumulator safeGetStringConstantDataAccumulator(String metricName, String value, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a string constant metric");
            return this.safeGetStringConstantDataAccumulator(metric, value);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IDeterministicIntegerDataAccumulator safeGetDeterministicIntegerDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a deterministic integer metric");
            return (IDeterministicIntegerDataAccumulator)this.getDeterministicDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerAverageDataAccumulator safeGetIntegerAverageDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
            return (IIntegerAverageDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerRateDataAccumulator safeGetIntegerRateDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer rate metric");
            return (IIntegerRateDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerSaturationDataAccumulator safeGetIntegerSaturationDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer saturation metric");
            return (IIntegerSaturationDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerFluctuatingCounterDataAccumulator safeGetIntegerFluctuatingCounterDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
            IDataAccumulator result = this.getDataAccumulator(metric);
            return (IIntegerFluctuatingCounterDataAccumulator)result;
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerFluctuatingCounterDataAccumulator safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
            IDataAccumulator result = this.getDataAccumulator(metric);
            return (IIntegerFluctuatingCounterDataAccumulator)result;
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerMonotonicallyIncreasingCounterDataAccumulator safeGetIntegerMonotonicallyIncreasingCounterDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer monotonically increasing counter metric");
            return (IIntegerMonotonicallyIncreasingCounterDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongAverageDataAccumulator safeGetLongAverageDataAccumulator(String metricName, int metricType) {
        return this.safeGetLongAverageDataAccumulator(metricName, metricType, true);
    }

    private ILongAverageDataAccumulator safeGetLongAverageDataAccumulator(String metricName, int metricType, boolean requireUniqueName) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long duration metric", requireUniqueName);
            return (ILongAverageDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongFluctuatingCounterDataAccumulator safeGetLongFluctuatingCounterDataAccumulator(String metricName, int metricType) {
        return this.safeGetLongFluctuatingCounterDataAccumulator(metricName, metricType, true);
    }

    private ILongFluctuatingCounterDataAccumulator safeGetLongFluctuatingCounterDataAccumulator(String metricName, int metricType, boolean requireUniqueName) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long fluctuating counter metric", requireUniqueName);
            return (ILongFluctuatingCounterDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongMonotonicallyIncreasingCounterDataAccumulator safeGetLongMonotonicallyIncreasingCounterDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long monotonically increasing counter metric");
            return (ILongMonotonicallyIncreasingCounterDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongIntervalCounterDataAccumulator safeGetLongIntervalCounterDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
            return (ILongIntervalCounterDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ICumulativeCounterDataAccumulator safeGetCumulativeCounterDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long cumulative counter metric");
            return (ICumulativeCounterDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IStringEveryEventDataAccumulator safeGetStringEveryEventDataAccumulator(String metricName, int metricType) {
        try {
            AgentMetric metric = this.safeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a string metric");
            return (IStringEveryEventDataAccumulator)this.getDataAccumulator(metric);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerConstantDataAccumulator getIntegerConstantDataAccumulator(String metricName, int value, int metricType) throws BadlyFormedNameException, ConflictingTypesException, ConstantValueCannotChangeException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return this.getIntegerConstantDataAccumulator(metric, value, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongConstantDataAccumulator getLongConstantDataAccumulator(String metricName, long value, int metricType) throws BadlyFormedNameException, ConflictingTypesException, ConstantValueCannotChangeException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return this.getLongConstantDataAccumulator(metric, value, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IStringConstantDataAccumulator getStringConstantDataAccumulator(String metricName, String value, int metricType) throws BadlyFormedNameException, ConflictingTypesException, ConstantValueCannotChangeException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return this.getStringConstantDataAccumulator(metric, value, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IDeterministicIntegerDataAccumulator getDeterministicIntegerDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IDeterministicIntegerDataAccumulator)this.getDeterministicDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerAverageDataAccumulator getIntegerAverageDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerAverageDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerRateDataAccumulator getIntegerRateDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerRateDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerFluctuatingCounterDataAccumulator getIntegerFluctuatingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerFluctuatingCounterDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerMonotonicallyIncreasingCounterDataAccumulator getIntegerMonotonicallyIncreasingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerMonotonicallyIncreasingCounterDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongAverageDataAccumulator getLongAverageDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongAverageDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongFluctuatingCounterDataAccumulator getLongFluctuatingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongFluctuatingCounterDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongMonotonicallyIncreasingCounterDataAccumulator getLongMonotonicallyIncreasingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongMonotonicallyIncreasingCounterDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongIntervalCounterDataAccumulator getLongIntervalCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongIntervalCounterDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IStringEveryEventDataAccumulator getStringEveryEventDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IStringEveryEventDataAccumulator)this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerConstantDataAccumulator createIntegerConstantDataAccumulator(String metricName, int value, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return this.getIntegerConstantDataAccumulator(metric, value, false);
        }
        catch (ConstantValueCannotChangeException cvcce) {
            throw new InternalException(cvcce);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongConstantDataAccumulator createLongConstantDataAccumulator(String metricName, long value, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return this.getLongConstantDataAccumulator(metric, value, false);
        }
        catch (ConstantValueCannotChangeException cvcce) {
            throw new InternalException(cvcce);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IStringConstantDataAccumulator createStringConstantDataAccumulator(String metricName, String value, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return this.getStringConstantDataAccumulator(metric, value, false);
        }
        catch (ConstantValueCannotChangeException cvcce) {
            throw new InternalException(cvcce);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IDeterministicIntegerDataAccumulator createDeterministicIntegerDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IDeterministicIntegerDataAccumulator)this.getDeterministicDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerAverageDataAccumulator createIntegerAverageDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerAverageDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerRateDataAccumulator createIntegerRateDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerRateDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerFluctuatingCounterDataAccumulator createIntegerFluctuatingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerFluctuatingCounterDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerMonotonicallyIncreasingCounterDataAccumulator createIntegerMonotonicallyIncreasingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IIntegerMonotonicallyIncreasingCounterDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongAverageDataAccumulator createLongAverageDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongAverageDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongFluctuatingCounterDataAccumulator createLongFluctuatingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongFluctuatingCounterDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongMonotonicallyIncreasingCounterDataAccumulator createLongMonotonicallyIncreasingCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongMonotonicallyIncreasingCounterDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private ILongIntervalCounterDataAccumulator createLongIntervalCounterDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (ILongIntervalCounterDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IStringEveryEventDataAccumulator createStringEveryEventDataAccumulator(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        try {
            AgentMetric metric = this.getMetricOfType(metricName, metricType);
            return (IStringEveryEventDataAccumulator)this.getDataAccumulator(metric, false);
        }
        catch (ClassCastException cce) {
            throw new InternalException(cce);
        }
    }

    private IIntegerConstantDataAccumulator safeGetIntegerConstantDataAccumulator(AgentMetric metric, int value) {
        try {
            return this.getIntegerConstantDataAccumulator(metric, value, true, true, false);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ConstantValueCannotChangeException cvcce) {
            throw new InternalException(cvcce);
        }
    }

    private IIntegerConstantDataAccumulator getIntegerConstantDataAccumulator(AgentMetric metric, int value, boolean allowDuplicates) throws AccumulatorAlreadyExistsException, ConstantValueCannotChangeException {
        return this.getIntegerConstantDataAccumulator(metric, value, allowDuplicates, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIntegerConstantDataAccumulator getIntegerConstantDataAccumulator(AgentMetric metric, int value, boolean allowDuplicates, boolean shouldLog, boolean shouldThrow) throws AccumulatorAlreadyExistsException, ConstantValueCannotChangeException {
        if (metric == AgentMetric.kNullAgentMetric) {
            return (IIntegerConstantDataAccumulator)kNullDataAccumulator;
        }
        IIntegerConstantDataAccumulator accumulator = (IIntegerConstantDataAccumulator)this.lookupAccumulator(metric);
        if (accumulator == null) {
            boolean created = false;
            DataAccumulatorFactory dataAccumulatorFactory = this;
            synchronized (dataAccumulatorFactory) {
                accumulator = (IIntegerConstantDataAccumulator)this.lookupAccumulator(metric);
                if (accumulator == null) {
                    accumulator = new IntegerConstantDataAccumulator(metric, value);
                    created = true;
                } else if (shouldThrow && !allowDuplicates) {
                    this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
                }
                if (created) {
                    this.trackAccumulatorForMetric(metric, accumulator);
                }
            }
        } else if (shouldThrow && !allowDuplicates) {
            this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
        }
        int existingValue = accumulator.IIntegerConstantDataAccumulator_getIntegerValue();
        if (existingValue != value) {
            if (shouldLog) {
                this.logConstantValueChangeAttempt(metric.getAttributeName(), String.valueOf(existingValue), String.valueOf(value));
            }
            if (shouldThrow) {
                this.throwConstantValueCannotChangeExceptionForMetric(metric, String.valueOf(existingValue), String.valueOf(value));
            }
        }
        return accumulator;
    }

    private ILongConstantDataAccumulator safeGetLongConstantDataAccumulator(AgentMetric metric, long value) {
        try {
            return this.getLongConstantDataAccumulator(metric, value, true, true, false);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ConstantValueCannotChangeException cvcce) {
            throw new InternalException(cvcce);
        }
    }

    private ILongConstantDataAccumulator getLongConstantDataAccumulator(AgentMetric metric, long value, boolean allowDuplicates) throws AccumulatorAlreadyExistsException, ConstantValueCannotChangeException {
        return this.getLongConstantDataAccumulator(metric, value, allowDuplicates, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILongConstantDataAccumulator getLongConstantDataAccumulator(AgentMetric metric, long value, boolean allowDuplicates, boolean shouldLog, boolean shouldThrow) throws AccumulatorAlreadyExistsException, ConstantValueCannotChangeException {
        if (metric == AgentMetric.kNullAgentMetric) {
            return (ILongConstantDataAccumulator)kNullDataAccumulator;
        }
        ILongConstantDataAccumulator accumulator = (ILongConstantDataAccumulator)this.lookupAccumulator(metric);
        if (accumulator == null) {
            boolean created = false;
            DataAccumulatorFactory dataAccumulatorFactory = this;
            synchronized (dataAccumulatorFactory) {
                accumulator = (ILongConstantDataAccumulator)this.lookupAccumulator(metric);
                if (accumulator == null) {
                    accumulator = new LongConstantDataAccumulator(metric, value);
                    created = true;
                } else if (shouldThrow && !allowDuplicates) {
                    this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
                }
                if (created) {
                    this.trackAccumulatorForMetric(metric, accumulator);
                }
            }
        } else if (shouldThrow && !allowDuplicates) {
            this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
        }
        long existingValue = accumulator.ILongConstantDataAccumulator_getLongValue();
        if (existingValue != value) {
            if (shouldLog) {
                this.logConstantValueChangeAttempt(metric.getAttributeName(), String.valueOf(existingValue), String.valueOf(value));
            }
            if (shouldThrow) {
                this.throwConstantValueCannotChangeExceptionForMetric(metric, String.valueOf(existingValue), String.valueOf(value));
            }
        }
        return accumulator;
    }

    private IStringConstantDataAccumulator safeGetStringConstantDataAccumulator(AgentMetric metric, String value) {
        try {
            return this.getStringConstantDataAccumulator(metric, value, true, true, false);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
        catch (ConstantValueCannotChangeException cvcce) {
            throw new InternalException(cvcce);
        }
    }

    private IStringConstantDataAccumulator getStringConstantDataAccumulator(AgentMetric metric, String value, boolean allowDuplicates) throws AccumulatorAlreadyExistsException, ConstantValueCannotChangeException {
        return this.getStringConstantDataAccumulator(metric, value, allowDuplicates, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStringConstantDataAccumulator getStringConstantDataAccumulator(AgentMetric metric, String value, boolean allowDuplicates, boolean shouldLog, boolean shouldThrow) throws AccumulatorAlreadyExistsException, ConstantValueCannotChangeException {
        if (metric == AgentMetric.kNullAgentMetric) {
            return (IStringConstantDataAccumulator)kNullDataAccumulator;
        }
        IStringConstantDataAccumulator accumulator = (IStringConstantDataAccumulator)this.lookupAccumulator(metric);
        if (accumulator == null) {
            boolean created = false;
            DataAccumulatorFactory dataAccumulatorFactory = this;
            synchronized (dataAccumulatorFactory) {
                accumulator = (IStringConstantDataAccumulator)this.lookupAccumulator(metric);
                if (accumulator == null) {
                    accumulator = new StringConstantDataAccumulator(metric, value);
                    created = true;
                } else if (shouldThrow && !allowDuplicates) {
                    this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
                }
                if (created) {
                    this.trackAccumulatorForMetric(metric, accumulator);
                }
            }
        } else if (shouldThrow && !allowDuplicates) {
            this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
        }
        String existingValue = accumulator.IStringConstantDataAccumulator_getStringValue();
        if (!StringUtils.nullHandlingEquals(existingValue, value)) {
            if (shouldLog) {
                this.logConstantValueChangeAttempt(metric.getAttributeName(), existingValue, value);
            }
            if (shouldThrow) {
                this.throwConstantValueCannotChangeExceptionForMetric(metric, existingValue, value);
            }
        }
        return accumulator;
    }

    private IDeterministicDataAccumulator getDeterministicDataAccumulator(AgentMetric metric) {
        try {
            return this.getDeterministicDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDeterministicDataAccumulator getDeterministicDataAccumulator(AgentMetric metric, boolean allowDuplicates) throws AccumulatorAlreadyExistsException {
        IDataAccumulator accumulator = null;
        if (metric != AgentMetric.kNullAgentMetric) {
            accumulator = this.lookupAccumulator(metric);
        }
        if (accumulator == null) {
            boolean created = false;
            DataAccumulatorFactory dataAccumulatorFactory = this;
            synchronized (dataAccumulatorFactory) {
                accumulator = this.lookupAccumulator(metric);
                if (accumulator == null) {
                    if (metric != AgentMetric.kNullAgentMetric) {
                        accumulator = DataAccumulatorFactory.createDeterministicDataAccumulator(metric);
                        created = true;
                    } else {
                        if (this.fNullDeterministicDataAccumulator == null) {
                            this.fNullDeterministicDataAccumulator = this.getNullDeterministicAccumulator();
                        }
                        accumulator = this.fNullDeterministicDataAccumulator;
                    }
                } else if (!allowDuplicates) {
                    this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
                }
                Assertion.wilyAssert(false);
                if (created) {
                    this.trackAccumulatorForMetric(metric, accumulator);
                }
            }
        }
        return (IDeterministicDataAccumulator)accumulator;
    }

    private IDataAccumulator getDataAccumulator(AgentMetric metric) {
        try {
            return this.getDataAccumulator(metric, true);
        }
        catch (AccumulatorAlreadyExistsException aaee) {
            throw new InternalException(aaee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataAccumulator getDataAccumulator(AgentMetric metric, boolean allowDuplicates) throws AccumulatorAlreadyExistsException {
        if (metric == AgentMetric.kNullAgentMetric) {
            return kNullDataAccumulator;
        }
        IDataAccumulator accumulator = this.lookupAccumulator(metric);
        if (accumulator != null && !allowDuplicates) {
            this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
        }
        if (accumulator == null) {
            boolean created = false;
            DataAccumulatorFactory dataAccumulatorFactory = this;
            synchronized (dataAccumulatorFactory) {
                accumulator = this.lookupAccumulator(metric);
                if (accumulator == null) {
                    accumulator = DataAccumulatorFactory.createDataAccumulator(metric);
                    created = true;
                } else if (!allowDuplicates) {
                    this.throwAccumulatorAlreadyExistsExceptionForMetric(metric);
                }
                Assertion.wilyAssert(false);
                if (created) {
                    this.trackAccumulatorForMetric(metric, accumulator);
                }
            }
        }
        return accumulator;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IDataAccumulator createDataAccumulator(AgentMetric metric) {
        void var1_13;
        Object var1_1 = null;
        TypeInquisitor typeInfo = new TypeInquisitor(metric.getAttributeType());
        if (typeInfo.isConstant()) {
            throw new InternalException("unsupported constant types in createDataAccumulator");
        }
        if (typeInfo.isString()) {
            StringEveryEventDataAccumulator stringEveryEventDataAccumulator = new StringEveryEventDataAccumulator(metric);
            return var1_13;
        } else if (typeInfo.isInteger()) {
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                IntegerMonotonicallyIncreasingCounterDataAccumulator integerMonotonicallyIncreasingCounterDataAccumulator = new IntegerMonotonicallyIncreasingCounterDataAccumulator(metric);
                return var1_13;
            } else if (typeInfo.isFluctuatingCounter()) {
                IntegerFluctuatingCounterDataAccumulator integerFluctuatingCounterDataAccumulator = new IntegerFluctuatingCounterDataAccumulator(metric);
                return var1_13;
            } else if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                IntegerAverageDataAccumulator integerAverageDataAccumulator = new IntegerAverageDataAccumulator(metric);
                return var1_13;
            } else if (typeInfo.isRate()) {
                IntegerRateDataAccumulator integerRateDataAccumulator = new IntegerRateDataAccumulator(metric);
                return var1_13;
            } else {
                if (!typeInfo.isSaturation()) throw new InternalException("unsupported integer type in createDataAccumulator");
                IntegerSaturationDataAccumulator integerSaturationDataAccumulator = new IntegerSaturationDataAccumulator(metric);
            }
            return var1_13;
        } else {
            if (!typeInfo.isLong()) throw new InternalException("unsupported type in createDataAccumulator");
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                LongMonotonicallyIncreasingCounterDataAccumulator longMonotonicallyIncreasingCounterDataAccumulator = new LongMonotonicallyIncreasingCounterDataAccumulator(metric);
                return var1_13;
            } else if (typeInfo.isFluctuatingCounter()) {
                LongFluctuatingCounterDataAccumulator longFluctuatingCounterDataAccumulator = new LongFluctuatingCounterDataAccumulator(metric);
                return var1_13;
            } else if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                LongAverageDataAccumulator longAverageDataAccumulator = new LongAverageDataAccumulator(metric);
                return var1_13;
            } else if (typeInfo.isCumulativeCounter()) {
                CumulativeCounterDataAccumulator cumulativeCounterDataAccumulator = new CumulativeCounterDataAccumulator(metric);
                return var1_13;
            } else {
                if (!typeInfo.isIntervalCounter()) throw new InternalException("unsupported long type in createDataAccumulator");
                LongIntervalCounterDataAccumulator longIntervalCounterDataAccumulator = new LongIntervalCounterDataAccumulator(metric);
            }
        }
        return var1_13;
    }

    private static IDeterministicDataAccumulator createDeterministicDataAccumulator(AgentMetric metric) {
        DeterministicIntegerDataAccumulator accumulator = null;
        TypeInquisitor typeInfo = new TypeInquisitor(metric.getAttributeType());
        if (typeInfo.isConstant()) {
            throw new InternalException("unsupported constant types in createDeterministicDataAccumulator");
        }
        if (!typeInfo.isInteger()) {
            throw new InternalException("unsupported type in createDeterministicDataAccumulator");
        }
        accumulator = new DeterministicIntegerDataAccumulator(metric);
        return accumulator;
    }

    public AgentMetric safeGetMetricOfType(String metricName, int metricType, String safeFallbackName) {
        return this.safeGetMetricOfType(metricName, metricType, safeFallbackName, true);
    }

    private AgentMetric safeGetMetricOfType(String metricName, int metricType, String safeFallbackName, boolean requireUniqueName) {
        String name = metricName;
        int count = 1;
        while (count <= 100) {
            try {
                return this.getMetricOfType(name, metricType, requireUniqueName);
            }
            catch (BadlyFormedNameException bfne) {
                this.logBadName(bfne, name);
                name = metricName = safeFallbackName;
            }
            catch (ConflictingTypesException cte) {
                this.logTypeConflict(cte, name);
                name = String.valueOf(metricName) + " (conflicting type " + String.valueOf(count) + " )";
            }
            ++count;
        }
        throw new InternalException("Unable to find a unique metric name");
    }

    private AgentMetric getMetricOfType(String metricName, int metricType) throws BadlyFormedNameException, ConflictingTypesException {
        return AgentMetric.getUniqueNameAgentMetric(metricName, metricType);
    }

    private AgentMetric getMetricOfType(String metricName, int metricType, boolean requireUniqueName) throws BadlyFormedNameException, ConflictingTypesException {
        if (requireUniqueName) {
            return AgentMetric.getUniqueNameAgentMetric(metricName, metricType);
        }
        return AgentMetric.getAgentMetric(metricName, metricType);
    }

    private void logBadName(BadlyFormedNameException bfne, String metricName) {
        try {
            String message = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Accumulator_Factory_Bad_Metric_Name_Error_Message", metricName);
            IModuleFeedbackChannel feedback = this.getFeedbackChannel();
            feedback.error(message);
            feedback.verbose(bfne);
        }
        catch (Throwable throwable) {}
    }

    private void logTypeConflict(ConflictingTypesException cte, String metricName) {
        try {
            String message = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Accumulator_Factory_Conflicting_Types_For_Metric_Error_Message", metricName);
            IModuleFeedbackChannel feedback = this.getFeedbackChannel();
            feedback.error(message);
            feedback.verbose(cte);
        }
        catch (Throwable throwable) {}
    }

    private void logConstantValueChangeAttempt(String metricName, String existingValue, String requestedValue) {
        try {
            String message = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Accumulator_Factory_Constant_Value_Change_Error_Message", metricName, existingValue, requestedValue);
            IModuleFeedbackChannel feedback = this.getFeedbackChannel();
            feedback.error(message);
        }
        catch (Throwable throwable) {}
    }

    private void throwAccumulatorAlreadyExistsExceptionForMetric(AgentMetric metric) throws AccumulatorAlreadyExistsException {
        FormattedLocalizableMessage message = new FormattedLocalizableMessage("Agent_Accumulator_Already_Exists_Message", metric.getAttributeName());
        throw new AccumulatorAlreadyExistsException("Accumulator already exists for " + metric.getAttributeName(), (ILocalizableMessage)message);
    }

    private void throwConstantValueCannotChangeExceptionForMetric(AgentMetric metric, String existingValue, String value) throws ConstantValueCannotChangeException {
        FormattedLocalizableMessage message = new FormattedLocalizableMessage("Agent_Metric_Constant_Value_Cannot_Change_Message", metric.getAttributeName(), existingValue, value);
        throw new ConstantValueCannotChangeException("Attempted to change constant value for " + metric.getAttributeName() + ": Existing=" + existingValue + " Requested=" + value, (ILocalizableMessage)message);
    }

    private IDataAccumulator lookupAccumulator(AgentMetric metric) {
        return (IDataAccumulator)this.fCache.get(metric);
    }

    public void trackAccumulatorForMetric(AgentMetric metric, IDataAccumulator accumulator) {
        Object result = this.fCache.put(metric, accumulator);
        if (result == null) {
            this.getDataAccumulatorTracker().IDataAccumulatorTracker_trackAccumulator(accumulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackAccumulatorForMetric(AgentMetric metric) {
        IDataAccumulator accumulator;
        DataAccumulatorFactory dataAccumulatorFactory = this;
        synchronized (dataAccumulatorFactory) {
            accumulator = (IDataAccumulator)this.fCache.remove(metric);
        }
        Assertion.wilyAssert(false);
        if (accumulator != null) {
            this.getDataAccumulatorTracker().IDataAccumulatorTracker_untrackAccumulator(accumulator);
            accumulator.setRemoval();
        }
    }

    private void untrackAccumulatorForMetricCache(AgentMetric metric) {
        this.fCache.remove(metric);
    }

    public void updateRemovalMetricKey() {
        ++fRemovalMetricKey;
    }

    public static int getRemovalMetricKey() {
        return fRemovalMetricKey;
    }

    private IDataAccumulator getNullAccumulator() {
        return new NullAccumulatorImpl();
    }

    private IDeterministicDataAccumulator getNullDeterministicAccumulator() {
        return new NullDeterministicAccumulatorImpl();
    }

    private static class AccumulatorCache {
        private Map globalMap = Collections.synchronizedMap(new HashMap());
        private ThreadLocal threadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new WeakWeakIdentityHashMap();
            }
        };

        private WeakWeakIdentityHashMap getThreadLocalMap() {
            return (WeakWeakIdentityHashMap)this.threadLocal.get();
        }

        public Object put(Object key, Object value) {
            this.getThreadLocalMap().put(key, value);
            return this.globalMap.put(key, value);
        }

        public Object get(Object key) {
            Object result = this.getThreadLocalMap().get(key);
            if (result instanceof IDataAccumulator && ((IDataAccumulator)result).isRemoved()) {
                this.getThreadLocalMap().remove(key);
                result = null;
            }
            if (result == null && (result = this.globalMap.get(key)) != null) {
                if (((IDataAccumulator)result).isRemoved()) {
                    this.globalMap.remove(key);
                    return null;
                }
                this.getThreadLocalMap().put(key, result);
            }
            return result;
        }

        public Object remove(Object key) {
            this.getThreadLocalMap().remove(key);
            return this.globalMap.remove(key);
        }
    }

    public static class NullAccumulatorImpl
    implements IConstantDataAccumulator,
    IDataAccumulator,
    IIntegerAggregatingDataAccumulator,
    IIntegerAverageDataAccumulator,
    IIntegerConstantDataAccumulator,
    IIntegerCounterDataAccumulator,
    IIntegerFluctuatingCounterDataAccumulator,
    IIntegerMonotonicallyIncreasingCounterDataAccumulator,
    IIntegerRateDataAccumulator,
    IIntegerSaturationDataAccumulator,
    ILongAggregatingDataAccumulator,
    ILongAverageDataAccumulator,
    ILongConstantDataAccumulator,
    ILongCounterDataAccumulator,
    ILongFluctuatingCounterDataAccumulator,
    ILongIntervalCounterDataAccumulator,
    ILongMonotonicallyIncreasingCounterDataAccumulator,
    IStringConstantDataAccumulator,
    IStringDataAccumulator,
    IStringEveryEventDataAccumulator {
        @Override
        public Object IConstantDataAccumulator_getValue() {
            return null;
        }

        @Override
        public IGatherer IDataAccumulator_getGatherer() {
            return null;
        }

        @Override
        public AgentMetric IDataAccumulator_getMetric() {
            return null;
        }

        @Override
        public boolean IDataAccumulator_hasNewData(int timeslices) {
            return false;
        }

        @Override
        public boolean isRemoved() {
            return false;
        }

        @Override
        public void setRemoval() {
        }

        @Override
        public boolean IDataAccumulator_isConstant() {
            return false;
        }

        @Override
        public boolean IDataAccumulator_isShutOff() {
            return true;
        }

        @Override
        public void IDataAccumulator_setShutOff(boolean isShutOff) {
        }

        @Override
        public void forceMetricToExist(BlameStackSnapshot snapshot) {
        }

        @Override
        public void IIntegerAggregatingDataAccumulator_recordDataPoint(int dataPoint) {
        }

        @Override
        public void IIntegerAggregatingDataAccumulator_recordDataPoint(int dataPoint, BlameStackSnapshot blameStack) {
        }

        @Override
        public int IIntegerConstantDataAccumulator_getIntegerValue() {
            return 0;
        }

        @Override
        public void IIntegerCounterDataAccumulator_setValue(int value) {
        }

        @Override
        public void IIntegerCounterDataAccumulator_setValue(int value, BlameStackSnapshot blameStack) {
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_add(int delta) {
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_add(int delta, BlameStackSnapshot blameStack) {
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_decrement() {
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_decrement(BlameStackSnapshot blameStack) {
        }

        @Override
        public int IIntegerFluctuatingCounterDataAccumulator_getIntValue() {
            return 0;
        }

        @Override
        public int IIntegerFluctuatingCounterDataAccumulator_getIntValue(BlameStackSnapshot blameStack) {
            return 0;
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_increment() {
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_increment(BlameStackSnapshot blameStack) {
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_subtract(int delta) {
        }

        @Override
        public void IIntegerFluctuatingCounterDataAccumulator_subtract(int delta, BlameStackSnapshot blameStack) {
        }

        @Override
        public void IIntegerMonotonicallyIncreasingCounterDataAccumulator_add(int delta) {
        }

        @Override
        public void IIntegerMonotonicallyIncreasingCounterDataAccumulator_add(int delta, BlameStackSnapshot blameStack) {
        }

        @Override
        public void IIntegerMonotonicallyIncreasingCounterDataAccumulator_increment() {
        }

        @Override
        public void IIntegerMonotonicallyIncreasingCounterDataAccumulator_increment(BlameStackSnapshot blameStack) {
        }

        @Override
        public void IIntegerRateDataAccumulator_addBatchIncidents(int incidentCount) {
        }

        @Override
        public void IIntegerRateDataAccumulator_addBatchIncidents(int incidentCount, BlameStackSnapshot blameStack) {
        }

        @Override
        public void IIntegerRateDataAccumulator_addSingleIncident() {
        }

        @Override
        public void IIntegerRateDataAccumulator_addSingleIncident(BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongAggregatingDataAccumulator_recordDataPoint(long dataPoint) {
        }

        @Override
        public void ILongAggregatingDataAccumulator_recordDataPoint(long dataPoint, BlameStackSnapshot blameStack) {
        }

        @Override
        public long ILongConstantDataAccumulator_getLongValue() {
            return 0L;
        }

        @Override
        public long ILongCounterDataAccumulator_getLongValue() {
            return 0L;
        }

        @Override
        public long ILongCounterDataAccumulator_getLongValue(BlameStackSnapshot blameStack) {
            return 0L;
        }

        @Override
        public void ILongCounterDataAccumulator_setValue(long value) {
        }

        @Override
        public void ILongCounterDataAccumulator_setValue(long value, BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_add(long delta) {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_add(long delta, BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_decrement() {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_decrement(BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_increment() {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_increment(BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_subtract(long delta) {
        }

        @Override
        public void ILongFluctuatingCounterDataAccumulator_subtract(long delta, BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongIntervalCounterDataAccumulator_addBatchIncidents(long incidentCount) {
        }

        @Override
        public void ILongIntervalCounterDataAccumulator_addBatchIncidents(long incidentCount, BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongIntervalCounterDataAccumulator_addSingleIncident() {
        }

        @Override
        public void ILongIntervalCounterDataAccumulator_addSingleIncident(BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongMonotonicallyIncreasingCounterDataAccumulator_add(int delta) {
        }

        @Override
        public void ILongMonotonicallyIncreasingCounterDataAccumulator_add(int delta, BlameStackSnapshot blameStack) {
        }

        @Override
        public void ILongMonotonicallyIncreasingCounterDataAccumulator_increment() {
        }

        @Override
        public void ILongMonotonicallyIncreasingCounterDataAccumulator_increment(BlameStackSnapshot blameStack) {
        }

        @Override
        public String IStringConstantDataAccumulator_getStringValue() {
            return null;
        }

        @Override
        public void IStringEveryEventDataAccumulator_addString(String value) {
        }
    }

    public class NullDeterministicAccumulatorImpl
    implements IDataAccumulator,
    IDeterministicDataAccumulator,
    IDeterministicIntegerDataAccumulator {
        @Override
        public IGatherer IDataAccumulator_getGatherer() {
            return null;
        }

        @Override
        public AgentMetric IDataAccumulator_getMetric() {
            return null;
        }

        @Override
        public boolean IDataAccumulator_hasNewData(int timeslices) {
            return false;
        }

        @Override
        public boolean isRemoved() {
            return false;
        }

        @Override
        public void setRemoval() {
        }

        @Override
        public boolean IDataAccumulator_isConstant() {
            return false;
        }

        @Override
        public boolean IDataAccumulator_isShutOff() {
            return true;
        }

        @Override
        public void IDataAccumulator_setShutOff(boolean isShutOff) {
        }

        @Override
        public void forceMetricToExist(BlameStackSnapshot snapshot) {
        }

        @Override
        public boolean IDeterministicDataAccumulator_hasDataRemaining() {
            return false;
        }

        @Override
        public void IDeterministicIntegerDataAccumulator_addValues(int[] values) {
        }
    }
}

