/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.table;

import com.wily.ui.swing.table.TableMap;
import com.wily.wilyassert.Assertion;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class ColumnFilteringTableModel
extends TableMap {
    private static final long serialVersionUID = -3000459368146465787L;
    private final boolean[] fColumnFilter;

    public ColumnFilteringTableModel(TableModel model, boolean[] columnFilter) {
        this.setModel(model);
        this.fColumnFilter = columnFilter;
        Assertion.wilyAssert(model.getColumnCount() == columnFilter.length, "Column Filter Size must equal column count of underlying table model");
    }

    public ColumnFilteringTableModel(TableModel model) {
        this.setModel(model);
        this.fColumnFilter = new boolean[model.getColumnCount()];
    }

    public int getColumnCount() {
        int fColumnCount = 0;
        for (int i = 0; i < this.fColumnFilter.length; ++i) {
            if (!this.fColumnFilter[i]) continue;
            ++fColumnCount;
        }
        return fColumnCount;
    }

    public Class getColumnClass(int aColumn) {
        int underlyingColumn = this.getUnderlyingColumn(aColumn);
        if (underlyingColumn >= 0) {
            return super.getColumnClass(underlyingColumn);
        }
        return Object.class;
    }

    public String getColumnName(int aColumn) {
        int underlyingColumn = this.getUnderlyingColumn(aColumn);
        if (underlyingColumn >= 0) {
            return super.getColumnName(underlyingColumn);
        }
        return "";
    }

    public Object getValueAt(int aRow, int aColumn) {
        return super.getValueAt(aRow, this.getUnderlyingColumn(aColumn));
    }

    public boolean isCellEditable(int row, int column) {
        return super.isCellEditable(row, this.getUnderlyingColumn(column));
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        super.setValueAt(aValue, aRow, this.getUnderlyingColumn(aColumn));
    }

    public void tableChanged(TableModelEvent e) {
        e = new TableModelEvent(this, e.getFirstRow(), e.getLastRow(), this.getUnderlyingColumn(e.getColumn()), e.getType());
        super.tableChanged(e);
    }

    public int getUnderlyingColumn(int column) {
        if (column < 0) {
            return column;
        }
        int underlyingColumn = 0;
        for (int i = 0; i < this.fColumnFilter.length; ++i) {
            if (!this.fColumnFilter[i]) continue;
            if (underlyingColumn == column) {
                return i;
            }
            ++underlyingColumn;
        }
        Assertion.wilyFail("Should have found the mapped column for " + column);
        return -1;
    }

    public void setUnderlyingColumnVisible(int column, boolean visible) {
        this.fColumnFilter[column] = visible;
        this.fireTableStructureChanged();
    }

    public boolean setUnderlyingColumnVisibility(int column, boolean visible) {
        if (this.fColumnFilter[column] == visible) {
            return false;
        }
        this.fColumnFilter[column] = visible;
        this.fireTableStructureChanged();
        return true;
    }
}

