/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class ReadOnlyNonSyncBufferedRandomAccessFile
implements DataInput {
    private static int kReadBufferSize = 16384;
    private RandomAccessFile fFile;
    private long fPos;
    private long fReadBufferPosition;
    private long fReadBufferEndPosition;
    private byte[] fReadBuffer;
    private DataInput fDataIn;

    public ReadOnlyNonSyncBufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.initialize();
        this.fFile = new RandomAccessFile(file, mode);
    }

    public ReadOnlyNonSyncBufferedRandomAccessFile(String name, String mode) throws FileNotFoundException {
        this.initialize();
        this.fFile = new RandomAccessFile(name, mode);
    }

    public int getBufferSize() {
        return kReadBufferSize;
    }

    private void initialize() {
        this.fReadBuffer = new byte[kReadBufferSize];
        this.fReadBufferPosition = 0L;
        this.fReadBufferEndPosition = 0L;
        this.fDataIn = new LocalDataInput();
    }

    private int readFromDisk(byte[] b, int off, int len) throws IOException {
        this.fFile.seek(this.fPos);
        int num = this.fFile.read(b, off, len);
        if (num > 0) {
            this.fPos += (long)num;
        }
        return num;
    }

    private int fillFromBuffer(byte[] b, int offset, int len) {
        int index = (int)(this.fPos - this.fReadBufferPosition);
        FastArrayCopy.copy(this.fReadBuffer, index, b, offset, len);
        this.fPos += (long)len;
        return len;
    }

    private int fillBufferAndRead(byte[] b, int off, int len) throws IOException {
        this.fFile.seek(this.fPos);
        this.fReadBufferPosition = this.fPos;
        this.fReadBufferEndPosition = this.fPos;
        int num = this.fFile.read(this.fReadBuffer, 0, this.fReadBuffer.length);
        if (num < 0) {
            this.fReadBufferPosition = 0L;
            this.fReadBufferEndPosition = 0L;
            return num;
        }
        this.fReadBufferEndPosition = this.fReadBufferPosition + (long)num;
        num = Math.min(num, len);
        System.arraycopy(this.fReadBuffer, 0, b, off, num);
        this.fPos += (long)num;
        return num;
    }

    public final int read() throws IOException {
        byte[] fTempBuffer = new byte[1];
        if (this.fPos >= this.fReadBufferPosition && this.fPos < this.fReadBufferEndPosition) {
            int value = this.fReadBuffer[(int)(this.fPos - this.fReadBufferPosition)] & 0xFF;
            ++this.fPos;
            return value;
        }
        int value = this.fillBufferAndRead(fTempBuffer, 0, 1);
        if (value < 0) {
            return -1;
        }
        return fTempBuffer[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void setLength(long newLength) throws IOException {
        this.fFile.setLength(newLength);
        if (this.fPos > newLength) {
            this.fPos = newLength;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.fPos >= this.fReadBufferPosition && this.fPos < this.fReadBufferEndPosition) {
            int numToRead = Math.min(len, (int)(this.fReadBufferEndPosition - this.fPos));
            return this.fillFromBuffer(b, off, numToRead);
        }
        if (len > this.fReadBuffer.length) {
            return this.readFromDisk(b, off, len);
        }
        return this.fillBufferAndRead(b, off, len);
    }

    public void seek(long pos) throws IOException {
        try {
            this.fFile.seek(pos);
            this.fPos = pos;
        }
        catch (IOException e) {
            this.fReadBufferPosition = 0L;
            this.fReadBufferEndPosition = 0L;
            throw e;
        }
    }

    public long getFilePointer() throws IOException {
        return this.fPos;
    }

    public FileChannel getChannel() {
        Assertion.unimplemented();
        return null;
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fFile.getFD();
    }

    public long length() throws IOException {
        return this.fFile.length();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.fDataIn.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fDataIn.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.fDataIn.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.fDataIn.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.fDataIn.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.fDataIn.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.fDataIn.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.fDataIn.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.fDataIn.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.fDataIn.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.fDataIn.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.fDataIn.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.fDataIn.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.fDataIn.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.fDataIn.readUTF();
    }

    public void close() throws IOException {
        this.fFile.close();
    }

    private class LocalDataInput
    extends DataInputStream {
        public LocalDataInput() {
            super(new LocalInputStream());
        }
    }

    private class LocalInputStream
    extends InputStream {
        byte[] readBuf = new byte[1];

        LocalInputStream() {
        }

        @Override
        public int read() throws IOException {
            ReadOnlyNonSyncBufferedRandomAccessFile.this.read(this.readBuf);
            return this.readBuf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return ReadOnlyNonSyncBufferedRandomAccessFile.this.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return ReadOnlyNonSyncBufferedRandomAccessFile.this.read(b);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void mark(int readlimit) {
            Assertion.unimplemented();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void reset() throws IOException {
            Assertion.unimplemented();
        }

        @Override
        public long skip(long n) throws IOException {
            byte[] largeBuf = new byte[Math.min((int)n, kReadBufferSize)];
            while (n > (long)kReadBufferSize) {
                ReadOnlyNonSyncBufferedRandomAccessFile.this.read(largeBuf);
                n -= (long)kReadBufferSize;
            }
            ReadOnlyNonSyncBufferedRandomAccessFile.this.read(largeBuf, 0, (int)n);
            return n;
        }
    }
}

