/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.platform.APlatformStatPoller;
import com.wily.introscope.agent.platform.IPlatformStatistics;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.introscope.agent.platform.PlatformStatisticsHandler;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;

public final class AggregateCPUUtilizationPoller
extends APlatformStatPoller {
    private final IIntegerAverageDataAccumulator fAccumulator;
    private final int fLinearCPUIndex;
    private IModuleFeedbackChannel fFeedback;
    private int fConsecutiveFailures;
    private IAgent fagent;
    private static final int kConsecutiveFailureClamp = 50;

    public AggregateCPUUtilizationPoller(IModuleFeedbackChannel feedback, DataAccumulatorFactory factory, IPlatformStatistics platformStats, int linearCPUIndex, int osProcessorName) {
        super(platformStats);
        this.fFeedback = feedback;
        this.fLinearCPUIndex = linearCPUIndex;
        this.fConsecutiveFailures = 0;
        this.fAccumulator = factory.safeGetIntegerPercentageDataAccumulator(PlatformStatisticsHandler.constructProcessorSpecificResource(osProcessorName) + ":" + "Utilization % (aggregate)", 64);
    }

    public AggregateCPUUtilizationPoller(IModuleFeedbackChannel feedback, IAgent agent, DataAccumulatorFactory factory, IPlatformStatistics platformStats, int linearCPUIndex, int osProcessorName) {
        super(platformStats);
        this.fFeedback = feedback;
        this.fagent = agent;
        this.fLinearCPUIndex = linearCPUIndex;
        this.fConsecutiveFailures = 0;
        this.fAccumulator = factory.safeGetIntegerPercentageDataAccumulator(PlatformStatisticsHandler.constructProcessorSpecificResource(osProcessorName) + ":" + "Utilization % (aggregate)", 64);
    }

    protected AgentMetric getMetric() {
        return this.fAccumulator.IDataAccumulator_getMetric();
    }

    protected void reset() throws PlatformLibraryException, PlatformStatUnavailableException {
        this.getPlatformStatistics().IPlatformStatistics_resetAggregateCPUUtilizationForProcessor(this.fLinearCPUIndex);
    }

    protected void pollForPlatformStatistic() throws PlatformLibraryException, PlatformStatUnavailableException {
        IndexedProperties props = this.fagent.IAgent_getIndexedProperties();
        boolean disablePollingAggregateCPU = props.getBooleanProperty("introscope.agent.disablePollingAggregateCPUUtilization");
        if (!disablePollingAggregateCPU) {
            try {
                double usage = this.getPlatformStatistics().IPlatformStatistics_getAggregateCPUUtilizationForProcessor(this.fLinearCPUIndex);
                int result = (int)usage;
                if (result > 100) {
                    result = 100;
                } else if (result < 0) {
                    result = 0;
                }
                this.fAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(result);
                this.fConsecutiveFailures = 0;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (this.fConsecutiveFailures < 50) {
                        ++this.fConsecutiveFailures;
                        if (this.fConsecutiveFailures >= 5) {
                            this.fFeedback.error("An error occurred polling for platform data");
                            this.fFeedback.verbose(t);
                        }
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

