/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.datatransfer;

import com.wily.ui.datatransfer.IClipboardListener;
import java.awt.datatransfer.Transferable;
import java.util.Enumeration;
import java.util.Vector;

public class Clipboard {
    private static Clipboard sInstance = new Clipboard();
    private Vector fChangeNotifyList = new Vector();
    private String fName = "WilyClipboard";
    private Object fObject;

    private Clipboard() {
    }

    public static Clipboard getClipboard() {
        return sInstance;
    }

    public Transferable getContents() {
        return (Transferable)this.fObject;
    }

    public String getName() {
        return this.fName;
    }

    public void setContents(Transferable contents) {
        if (this.fObject != contents) {
            this.fObject = contents;
            this.doNotifyChange(this.fObject);
        }
    }

    public boolean registerListener(IClipboardListener listener) {
        if (this.fChangeNotifyList.contains(listener)) {
            return false;
        }
        this.fChangeNotifyList.add(listener);
        return true;
    }

    public boolean unregisterListener(IClipboardListener listener) {
        return this.fChangeNotifyList.remove(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.fChangeNotifyList != null) {
            if (this.fChangeNotifyList.size() > 0) {
                Vector copyList = (Vector)this.fChangeNotifyList.clone();
                sb.append(copyList.size()).append(" elements: [\n");
                Enumeration e = copyList.elements();
                while (e.hasMoreElements()) {
                    IClipboardListener listener = (IClipboardListener)e.nextElement();
                    sb.append("    ").append(listener.getClass().getName()).append("\n");
                }
                sb.append("]");
            } else {
                sb.append("EMPTY");
            }
        } else {
            sb.append("NULL");
        }
        return sb.toString();
    }

    private void doNotifyChange(Object data) {
        if (this.fChangeNotifyList != null && this.fChangeNotifyList.size() > 0) {
            Vector copyList = (Vector)this.fChangeNotifyList.clone();
            Enumeration e = copyList.elements();
            while (e.hasMoreElements()) {
                IClipboardListener listener = (IClipboardListener)e.nextElement();
                listener.IClipboardListener_clipboardChanged(data);
            }
        }
    }
}

