/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.finder;

import com.wily.util.finder.IResourceFinder;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.InputStream;

public class FileResourceFinder
implements IResourceFinder {
    private final String fSystemProperty;
    private final String fResourceToFindNameKey;

    public FileResourceFinder(String systemProperty, String resourceToFindNameKey) {
        Assertion.wilyAssert(systemProperty != null);
        Assertion.wilyAssert(resourceToFindNameKey != null);
        this.fSystemProperty = systemProperty;
        this.fResourceToFindNameKey = resourceToFindNameKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource IResourceFinder_findResource(IResourceFinderFeedback feedback) {
        FileBasedResource resultResource = null;
        InputStream testStream = null;
        String statusMessage = "";
        String filePath = null;
        IStringLocalizer localizer = feedback.IResourceFinderFeedback_getStringLocalizer();
        try {
            statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Loader_System_Property_Attempt_Message", this.fResourceToFindNameKey, true, this.fSystemProperty, false);
            feedback.IResourceFinderFeedback_feedbackStatus(statusMessage);
            filePath = System.getProperty(this.fSystemProperty);
            if (filePath != null) {
                statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Loader_Attempt_Message", "Resource_Finder_File_Type", true, filePath, false);
                feedback.IResourceFinderFeedback_feedbackStatus(statusMessage);
                resultResource = new FileBasedResource(filePath);
                testStream = resultResource.IResource_getContents();
                statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Succeeded_Message", "Resource_Finder_File_Type", true, filePath, false);
                feedback.IResourceFinderFeedback_feedbackSuccess(statusMessage);
            } else {
                statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Resource_Not_Found_Message", this.fResourceToFindNameKey, true, "Resource_Finder_System_Property_Type", true);
                feedback.IResourceFinderFeedback_feedbackFailure(statusMessage);
            }
        }
        catch (Throwable t) {
            statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Failed_Message", filePath, t.getClass().getName(), t.getMessage());
            feedback.IResourceFinderFeedback_feedbackFailure(statusMessage);
            resultResource = null;
        }
        finally {
            if (testStream != null) {
                try {
                    testStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return resultResource;
    }
}

