/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.overhead.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IOverheadManager;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.overhead.manager.FeatureControl;
import com.wily.introscope.agent.overhead.manager.FeatureControlAction;
import com.wily.introscope.agent.overhead.manager.FeatureControlActionDeserializer;
import com.wily.introscope.agent.overhead.manager.FeatureControlActionProperty;
import com.wily.introscope.agent.overhead.manager.FeatureControlActionTracerGroup;
import com.wily.introscope.agent.overhead.manager.FeatureControlDeserializer;
import com.wily.introscope.agent.overhead.manager.FeaturesFileWatcher;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.transformer.dynamic.IOverheadListener;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.CollectionEquivalenceCheckers;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.resource.IResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OverheadManager
implements IAgentService,
IOverheadManager,
IConfigurationListener,
IOverheadListener {
    private static final String kOverheadManagerEnabledPropertyKey = "introscope.agent.overhead.manager.enabled";
    private static final String kOverheadLevelPropertyKey = "introscope.agent.overhead.level";
    private static final String kOverheadForceOnPropertyKey = "introscope.agent.overhead.force.on";
    private static final String kOverheadForceOffPropertyKey = "introscope.agent.overhead.force.off";
    private IAgent fAgent;
    private ExtensionAdministrator fAdministrator;
    private FeaturesFileWatcher fWatcher;
    private static final Module kModule = new Module("OverheadManagement");
    private IModuleFeedbackChannel fFeedback;
    protected static final String featuresJSONfileName = "features.json";
    private static final String fCoreConfigDirName = "config";
    private ConfigurationWatcher fConfigurationWatcher = null;
    private IResource fProfileResource = null;
    protected static ExtendedFile fFeaturesfile = null;
    private IDynamicInstrumentationTransformer fTransformer;
    int totalCostOfFeatures = 0;
    List<FeatureControl> sortedFeatureControls = null;
    private Set<String> forcedOnFeatures = null;
    private Set<String> forcedOffFeatures = null;
    private final Map<String, String> fExtensionMap = new HashMap<String, String>();
    int level = 100;
    private FeatureControlSortComparator featureControlSortComparator = new FeatureControlSortComparator();
    private FeatureControlSearchComparator featureControlSearchComparator = new FeatureControlSearchComparator();
    private OverheadMode targetOverheadMode = null;
    public static final String AGENT_OBVERHEAD_CONTROL_KEY = "introscope.agent.overhead.level";

    public void IAgentService_startService(IAgent agent, Map params) throws Exception {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        String overheadMode = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.overhead.level", "Normal");
        if ("Normal".equalsIgnoreCase(overheadMode)) {
            this.fFeedback.info(kModule, "Overhead Management Service disabled.");
            return;
        }
        this.fFeedback.info(kModule, "Overhead Mangement Service starting");
        this.forcedOnFeatures = new HashSet<String>();
        this.forcedOffFeatures = new HashSet<String>();
        this.fAdministrator = (ExtensionAdministrator)params.get("ExtensionAdministrator");
        this.fProfileResource = this.fAdministrator.getProfileResource();
        ExtendedFile coreExt = this.fAdministrator.getAgentExtensionDirectory();
        if (coreExt != null) {
            String corePath = coreExt.getParentFile().getAbsolutePath();
            String FeaturesfilePath = String.valueOf(corePath) + File.separator + fCoreConfigDirName + File.separator + featuresJSONfileName;
            fFeaturesfile = new ExtendedFile(FeaturesfilePath);
        }
        this.fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new AgentOverheadModeProperty(agent));
        if (fFeaturesfile != null) {
            this.reloadFeatureControlStructures(true);
            this.fWatcher = new FeaturesFileWatcher(this);
            this.fWatcher.start();
        }
        ((ACommonAgent)this.fAgent).setOverHeadManager((IOverheadManager)this);
        this.fConfigurationWatcher = ((ACommonAgent)this.fAgent).getConfigurationWatcher();
        this.fConfigurationWatcher.addConfigurationTweaker((IConfigurationListener)this);
        OverheadAdministrator.registerOverheadControlSubscriber((IOverheadListener)this);
    }

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public FeatureControl[] readJSON(ExtendedFile file) {
        FeatureControl[] featureControls;
        block7: {
            featureControls = null;
            try {
                FileInputStream in = new FileInputStream(file.getFile());
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = reader.readLine();
                StringBuilder jsonBuffer = new StringBuilder();
                while (line != null) {
                    jsonBuffer.append(line);
                    line = reader.readLine();
                }
                reader.close();
                featureControls = OverheadManager.parseJSON(jsonBuffer.toString());
            }
            catch (JsonParseException e) {
                this.fFeedback.error(kModule, "Cannot read Feature Control JSON file " + file.getAbsolutePath() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(kModule)) {
                    this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                this.fFeedback.error(kModule, "Cannot read Feature Control JSON file " + file.getAbsolutePath() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(kModule)) {
                    this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
                }
            }
            catch (IOException e) {
                this.fFeedback.error(kModule, "Cannot read Feature Control JSON file" + file.getAbsolutePath() + " : " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(kModule)) break block7;
                this.fFeedback.debug(kModule, "Cannot read file: ", (Throwable)e);
            }
        }
        return featureControls;
    }

    public static FeatureControl[] parseJSON(String str) throws JsonSyntaxException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)FeatureControl.class), new FeatureControlDeserializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)FeatureControlAction.class), new FeatureControlActionDeserializer());
        Gson gson = gsonBuilder.disableHtmlEscaping().create();
        FeatureControl[] featureControls = gson.fromJson(str, FeatureControl[].class);
        return featureControls;
    }

    public synchronized Map<String, Boolean> getTracerGroupMap() {
        HashMap<String, Boolean> tracerGroupMap = null;
        if (this.sortedFeatureControls != null && this.sortedFeatureControls.size() > 0) {
            tracerGroupMap = new HashMap<String, Boolean>();
            for (FeatureControl feature : this.sortedFeatureControls) {
                FeatureControlAction[] actions;
                if (feature.getActions() == null) continue;
                FeatureControlAction[] featureControlActionArray = actions = feature.getActions();
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    FeatureControlAction action = featureControlActionArray[n2];
                    if (action instanceof FeatureControlActionTracerGroup && action.getName() != null) {
                        FeatureControlActionTracerGroup at = (FeatureControlActionTracerGroup)action;
                        if (feature.isEnabled() && at.getOnValue() != null) {
                            tracerGroupMap.put(at.getName(), at.getOnValue());
                        }
                        if (!feature.isEnabled() && at.getOffValue() != null) {
                            tracerGroupMap.put(at.getName(), at.getOffValue());
                        }
                    }
                    ++n2;
                }
            }
        }
        return tracerGroupMap;
    }

    public synchronized Map<String, String> getPropertyMap() {
        HashMap<String, String> propertyGroupMap = null;
        if (this.sortedFeatureControls != null && this.sortedFeatureControls.size() > 0) {
            propertyGroupMap = new HashMap<String, String>();
            for (FeatureControl feature : this.sortedFeatureControls) {
                FeatureControlAction[] actions;
                if (feature.getActions() == null) continue;
                FeatureControlAction[] featureControlActionArray = actions = feature.getActions();
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    FeatureControlAction action = featureControlActionArray[n2];
                    if (action instanceof FeatureControlActionProperty && action.getName() != null) {
                        FeatureControlActionProperty ap = (FeatureControlActionProperty)action;
                        if (feature.isEnabled() && ap.getOnValue() != null) {
                            propertyGroupMap.put(ap.getName(), ap.getOnValue());
                        }
                        if (!feature.isEnabled() && ap.getOffValue() != null) {
                            propertyGroupMap.put(ap.getName(), ap.getOffValue());
                        }
                    }
                    ++n2;
                }
            }
        }
        return propertyGroupMap;
    }

    private void calculateFeatureStates(int level, boolean startup) {
        int currentCost = 0;
        int levelCost = this.totalCostOfFeatures * level / 100;
        this.fFeedback.info(kModule, "inside calculateFeatureStates " + this.forcedOnFeatures);
        for (FeatureControl feature : this.sortedFeatureControls) {
            currentCost += feature.getCost();
            if (this.forcedOnFeatures.contains(feature.getName())) {
                this.fFeedback.info(kModule, "Feature " + feature.getName() + " is forced on.");
                feature.setState(true);
            } else if (this.forcedOffFeatures.contains(feature.getName())) {
                this.fFeedback.info(kModule, "Feature " + feature.getName() + " is forced off.");
                feature.setState(false);
            } else if (this.targetOverheadMode != null && (this.targetOverheadMode == OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND || this.targetOverheadMode == OverheadMode.ABSOLUTE_LOW)) {
                feature.setState(false);
            } else {
                feature.setState(currentCost <= levelCost);
            }
            if (!startup && !feature.isDynamic()) continue;
            feature.setEnabled(feature.isTurnedOn());
        }
    }

    public List<FeatureControl> getFeatures(List<FeatureControl> featureControls) {
        int totalCost = 0;
        for (FeatureControl f : featureControls) {
            totalCost += f.getCost();
        }
        this.totalCostOfFeatures = totalCost;
        Collections.sort(featureControls, this.featureControlSortComparator);
        this.sortedFeatureControls = featureControls;
        return this.sortedFeatureControls;
    }

    public void setOverheadMode(OverheadMode mode) {
        this.targetOverheadMode = mode;
        this.reloadFeatureControlStructures(false);
        this.applyFeatureControlStructures();
    }

    public OverheadMode getCurrentOverheadMode() {
        return null;
    }

    private List<FeatureControl> readFeatureControlFiles() {
        ArrayList<FeatureControl> featuresControls = new ArrayList<FeatureControl>();
        FeatureControl[] features = this.readJSON(fFeaturesfile);
        featuresControls.addAll(Arrays.asList(features));
        for (String directory : this.fExtensionMap.values()) {
            String FeaturesfilePath = String.valueOf(directory) + File.separator + featuresJSONfileName;
            ExtendedFile featuresfile = new ExtendedFile(FeaturesfilePath);
            if (!featuresfile.exists()) continue;
            features = this.readJSON(featuresfile);
            featuresControls.addAll(Arrays.asList(features));
        }
        return featuresControls;
    }

    public synchronized void reloadFeatureControlStructures(boolean startup) {
        List<FeatureControl> featureControls = this.readFeatureControlFiles();
        if (featureControls != null) {
            if (!startup && this.sortedFeatureControls != null) {
                Collections.sort(this.sortedFeatureControls, this.featureControlSearchComparator);
                for (FeatureControl newFeature : featureControls) {
                    int index = Collections.binarySearch(this.sortedFeatureControls, newFeature, this.featureControlSearchComparator);
                    if (index < 0) continue;
                    FeatureControl feature = this.sortedFeatureControls.get(index);
                    newFeature.setEnabled(feature.isEnabled());
                    this.fFeedback.debug(kModule, "Feature " + newFeature.getName() + " current state isEnabled=" + newFeature.isEnabled());
                }
            }
            this.getFeatures(featureControls);
            this.level = this.fAgent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.overhead.level", 100);
            this.updateForcedOnOffLists(true);
            this.updateForcedOnOffLists(false);
            this.calculateFeatureStates(this.level, startup);
            this.updateSustainabilityMetrics();
        }
    }

    public synchronized void applyFeatureControlStructures() {
        this.updateProperties();
        this.updateTraceGroups();
    }

    public void updateSustainabilityMetrics() {
        SustainabilityService sustainabilityService = SustainabilityService.getSustainabilityServiceInstance();
        if (sustainabilityService != null) {
            long totalEnabled = 0L;
            long totalTurnedOn = 0L;
            for (FeatureControl featureControl : this.sortedFeatureControls) {
                sustainabilityService.setFeatureControlMetrics(featureControl.getName(), (long)featureControl.getCost(), (long)featureControl.getPriority(), featureControl.isEnabled() ? 1L : 0L, featureControl.isTurnedOn() ? 1L : 0L);
                if (featureControl.isEnabled()) {
                    ++totalEnabled;
                }
                if (!featureControl.isTurnedOn()) continue;
                ++totalTurnedOn;
            }
            sustainabilityService.setFeatureControlGenericMetrics((long)this.sortedFeatureControls.size(), totalEnabled, totalTurnedOn);
        }
    }

    private void updateTraceGroups() {
        if (this.getTransformer() != null) {
            this.fTransformer.reloadDirectives(null);
        }
    }

    private void updateProperties() {
        this.fConfigurationWatcher.reloadConfig();
    }

    private IDynamicInstrumentationTransformer getTransformer() {
        TransformerAdministrator transformerAdministrator;
        if (this.fTransformer == null && (transformerAdministrator = this.fAgent.IAgent_getTransformerAdministrator()) != null) {
            this.fTransformer = transformerAdministrator.getDynamicInstrumentationTransformer();
        }
        return this.fTransformer;
    }

    public void registerFeaturesFile(String name, String directory) {
        this.fExtensionMap.put(name, directory);
        this.fWatcher.register(directory);
        this.reloadFeatureControlStructures(false);
    }

    public void deregisterFeaturesFile(String name) {
        String directory = this.fExtensionMap.get(name);
        this.fWatcher.deregister(directory);
        this.fExtensionMap.remove(name);
        this.reloadFeatureControlStructures(false);
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public Module getModule() {
        return kModule;
    }

    public synchronized void onChange(IndexedProperties newProps) {
        Map<String, String> propMap;
        int newLevel = newProps.getIntProperty("introscope.agent.overhead.level", 100);
        boolean levelChanged = false;
        boolean isOnListChanged = this.updateForcedOnOffLists(true);
        boolean isOffListChanged = this.updateForcedOnOffLists(false);
        if (isOnListChanged || isOffListChanged) {
            levelChanged = true;
        }
        if (newLevel != this.level) {
            this.level = newLevel;
            levelChanged = true;
        }
        if (levelChanged) {
            this.calculateFeatureStates(this.level, false);
            this.updateSustainabilityMetrics();
        }
        if ((propMap = this.getPropertyMap()) != null) {
            for (Map.Entry<String, String> e : propMap.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                String oldValue = newProps.getProperty(key);
                if (oldValue != null && oldValue.equals(value)) continue;
                this.fFeedback.debug(kModule, "Overriding property " + key + ", old value = " + oldValue + ", new value = " + value);
                newProps.setProperty(key, value);
            }
        }
        if (levelChanged) {
            this.updateTraceGroups();
        }
    }

    public void notifyConfigurationWatcher() {
        if (this.fConfigurationWatcher != null) {
            this.fConfigurationWatcher.checkForChangeNow();
        }
    }

    public String getProfileName() {
        if (this.fProfileResource != null) {
            return this.fProfileResource.IResource_getLocation();
        }
        return null;
    }

    private boolean updateForcedOnOffLists(boolean isForcedOnList) {
        if (OverheadMode.ABSOLUTE_LOW == this.targetOverheadMode) {
            return false;
        }
        boolean isListUpdated = false;
        String separator = ",";
        String propertyKey = null;
        propertyKey = isForcedOnList ? kOverheadForceOnPropertyKey : kOverheadForceOffPropertyKey;
        HashSet<String> set = new HashSet<String>();
        this.calculateForcedOnProperty(separator, propertyKey, set);
        if (isForcedOnList) {
            if (!CollectionEquivalenceCheckers.setsAreEquivalent(this.forcedOnFeatures, set)) {
                isListUpdated = true;
            }
            this.forcedOnFeatures = set;
        } else {
            if (!CollectionEquivalenceCheckers.setsAreEquivalent(this.forcedOffFeatures, set)) {
                isListUpdated = true;
            }
            this.forcedOffFeatures = set;
        }
        return isListUpdated;
    }

    private void calculateForcedOnProperty(String separator, String propertyKey, Set<String> set) {
        if (this.fAgent.IAgent_getIndexedProperties().getTrimmedProperty(propertyKey) != null) {
            String[] stringarray = this.fAgent.IAgent_getIndexedProperties().safeGetSeparatedProperty(propertyKey, separator);
            if (stringarray != null) {
                set.addAll(Arrays.asList(stringarray));
                return;
            }
        } else if (this.targetOverheadMode != null && this.targetOverheadMode == OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND) {
            set.addAll(this.targetOverheadMode.getOverheadSettings().getForceOnList());
            return;
        }
    }

    final class AgentOverheadModeProperty
    extends ConfigurationProperty {
        private AgentOverheadModeProperty(IAgent agent) {
            super("introscope.agent.overhead.level", (Object)"", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            boolean none;
            String value = (String)newValue;
            if (newValue != null && ((String)newValue).trim().length() != 0 && value.equalsIgnoreCase("Low") && OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND != OverheadAdministrator.getOverheadMode()) {
                this.getFeedback().info(kModule, "Agent Overhead Level set to low. Only Frontend and Backend tracings will be ON." + this.computeMsg());
                OverheadAdministrator.setOverheadMode((OverheadMode)OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND);
            }
            boolean bl = none = newValue != null && ((String)newValue).trim().length() != 0 && value.equalsIgnoreCase("None") && OverheadMode.ABSOLUTE_LOW != OverheadAdministrator.getOverheadMode();
            if (none) {
                this.getFeedback().info(kModule, "Agent Overhead Level set to None. Agent will attempt to disable all existing instrumentations." + this.computeMsg());
                OverheadAdministrator.setOverheadMode((OverheadMode)OverheadMode.ABSOLUTE_LOW);
            }
            if (newValue != null && ((String)newValue).trim().length() != 0 && value.equalsIgnoreCase("Normal") && (OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode())) {
                this.getFeedback().info(kModule, "Agent Overhead Level changed to Normal. Changing from None/Low to Normal requires Agent restart.");
                return;
            }
        }

        private String computeMsg() {
            return "This could cause little increase in CPU usage when system is under high load.The CPU usage should drop significantly after the class Redefinition is complete which usually takes couple of minutes under high load.";
        }
    }

    private class FeatureControlSearchComparator
    implements Comparator<FeatureControl> {
        private FeatureControlSearchComparator() {
        }

        @Override
        public int compare(FeatureControl o1, FeatureControl o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            if (n1 != null) {
                return n1.compareTo(n2);
            }
            if (n2 == null) {
                return 0;
            }
            return 1;
        }
    }

    private class FeatureControlSortComparator
    implements Comparator<FeatureControl> {
        private FeatureControlSortComparator() {
        }

        @Override
        public int compare(FeatureControl o1, FeatureControl o2) {
            if (o1.getPriority() != o2.getPriority()) {
                return o2.getPriority() - o1.getPriority();
            }
            return o1.getCost() - o2.getCost();
        }
    }
}

