/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.io.AddressHostNameHelper;
import com.wily.introscope.agent.trace.io.SocketConfiguration;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory15;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;

public final class SocketMap {
    private static AtomicReference<ConcurrentWeakThreadLocalHashMap<Object, SocketInfo>> sSocketMapCache = new AtomicReference<Object>(null);

    public static final void put(Socket socket, String resourceName, InetSocketAddress address, boolean isClientConnection) {
        if (socket != null && resourceName != null && address != null) {
            InetSocketAddress localAddress = (InetSocketAddress)socket.getLocalSocketAddress();
            SocketMap.put(socket, new SocketInfo(resourceName, localAddress, address, isClientConnection));
        }
    }

    public static final void put(ServerSocket serverSocket, String resourceName, InetSocketAddress address, boolean isClientConnection) {
        if (serverSocket != null && resourceName != null && address != null) {
            SocketMap.put(serverSocket, new SocketInfo(resourceName, null, address, isClientConnection));
        }
    }

    private static final void initSocketMapCache() {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            ConcurrentWeakThreadLocalHashMap map = mapFactory.getConcurrentWeakHashMap("SocketMapCache");
            sSocketMapCache.set(map);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    private static final void put(Object socket, SocketInfo ra) {
        ConcurrentWeakThreadLocalHashMap<Object, SocketInfo> map = sSocketMapCache.get();
        if (map == null) {
            SocketMap.initSocketMapCache();
            map = sSocketMapCache.get();
        }
        if (map != null) {
            map.putWeak(socket, ra);
        }
    }

    private static final SocketInfo get(Object socket) {
        ConcurrentWeakThreadLocalHashMap<Object, SocketInfo> map = sSocketMapCache.get();
        if (map == null) {
            SocketMap.initSocketMapCache();
            map = sSocketMapCache.get();
        }
        if (map != null) {
            return map.getWeak(socket);
        }
        return null;
    }

    public static final InetSocketAddress getAddress(Object socket) {
        SocketInfo cInfo = SocketMap.get(socket);
        if (cInfo != null) {
            return cInfo.getAddress();
        }
        return null;
    }

    public static final InetSocketAddress getLocalAddress(Object socket) {
        SocketInfo cInfo = SocketMap.get(socket);
        if (cInfo != null) {
            return cInfo.getLocalAddress();
        }
        return null;
    }

    public static final int getPort(Object socket) {
        InetSocketAddress addr = SocketMap.getAddress(socket);
        if (addr != null) {
            return addr.getPort();
        }
        return -1;
    }

    public static final String getHost(Object socket) {
        InetSocketAddress addr = SocketMap.getAddress(socket);
        if (addr != null) {
            return AddressHostNameHelper.getHostName(addr);
        }
        return "Unknown Host";
    }

    public static final String getResourceName(Object socket) {
        SocketInfo cInfo = SocketMap.get(socket);
        if (cInfo != null) {
            return cInfo.getResourceName();
        }
        return null;
    }

    public static final boolean isClientConnection(Object socket) {
        SocketInfo cInfo = SocketMap.get(socket);
        if (cInfo != null) {
            return cInfo.isClientConnection();
        }
        return false;
    }

    public static final boolean isRequired(Object socketObject, IAgent agent) {
        SocketConfiguration cc = SocketConfiguration.getSocketConfiguration(agent);
        if (cc.isRequiredEnabled()) {
            SocketInfo sInfo = SocketMap.get(socketObject);
            if (sInfo != null) {
                if (socketObject instanceof Socket) {
                    Socket socket = (Socket)socketObject;
                    if (sInfo.isClientConnection()) {
                        SocketAddress ra = socket.getRemoteSocketAddress();
                        if (ra == null) {
                            return false;
                        }
                        if (ra instanceof InetSocketAddress) {
                            InetSocketAddress remoteAddress = (InetSocketAddress)ra;
                            return cc.isRequired(0, remoteAddress.getAddress()) && cc.isRequired(1, remoteAddress.getPort());
                        }
                        Assertion.wilyAssert("Instrumentation error: remote address is not an InetSocketAddress");
                        return false;
                    }
                    return cc.isRequired(2, socket.getLocalPort());
                }
                ServerSocket ss = (ServerSocket)socketObject;
                return cc.isRequired(2, ss.getLocalPort());
            }
            return false;
        }
        return true;
    }

    public static final ASocketNameFormatter.ResourceAndAddress getResourceAndAddressName(Socket socket) {
        SocketInfo cInfo = SocketMap.get(socket);
        if (cInfo != null && cInfo.getResourceName() != null && cInfo.getAddress() != null) {
            return new ASocketNameFormatter.ResourceAndAddress(cInfo.getResourceName(), cInfo.getLocalAddress(), cInfo.getAddress());
        }
        return null;
    }

    private static final class SocketInfo {
        private final String resourceName;
        private final InetSocketAddress address;
        private final InetSocketAddress localAddress;
        private final boolean isClientConnection;

        private SocketInfo(String resourceName, InetSocketAddress localAddress, InetSocketAddress address, boolean isClientConnection) {
            this.resourceName = resourceName;
            this.address = address;
            this.localAddress = localAddress;
            this.isClientConnection = isClientConnection;
        }

        private final String getResourceName() {
            return this.resourceName;
        }

        private final InetSocketAddress getAddress() {
            return this.address;
        }

        private final InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }

        private final boolean isClientConnection() {
            return this.isClientConnection;
        }
    }
}

