/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.log4j.xml;

import com.wily.org.apache.log4j.Layout;
import com.wily.org.apache.log4j.helpers.Transform;
import com.wily.org.apache.log4j.spi.LocationInfo;
import com.wily.org.apache.log4j.spi.LoggingEvent;

public class XMLLayout
extends Layout {
    private final int DEFAULT_SIZE = 256;
    private final int UPPER_LIMIT = 2048;
    private StringBuffer buf = new StringBuffer(256);
    private boolean locationInfo = false;

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
    }

    public String format(LoggingEvent event) {
        String[] s;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuffer(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(event.getLoggerName());
        this.buf.append("\" timestamp=\"");
        this.buf.append(event.timeStamp);
        this.buf.append("\" level=\"");
        this.buf.append(event.getLevel());
        this.buf.append("\" thread=\"");
        this.buf.append(event.getThreadName());
        this.buf.append("\">\r\n");
        this.buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCDATA(this.buf, event.getRenderedMessage());
        this.buf.append("]]></log4j:message>\r\n");
        String ndc = event.getNDC();
        if (ndc != null) {
            this.buf.append("<log4j:NDC><![CDATA[");
            this.buf.append(ndc);
            this.buf.append("]]></log4j:NDC>\r\n");
        }
        if ((s = event.getThrowableStrRep()) != null) {
            this.buf.append("<log4j:throwable><![CDATA[");
            int i = 0;
            while (i < s.length) {
                this.buf.append(s[i]);
                this.buf.append("\r\n");
                ++i;
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            LocationInfo locationInfo = event.getLocationInformation();
            this.buf.append("<log4j:locationInfo class=\"");
            this.buf.append(locationInfo.getClassName());
            this.buf.append("\" method=\"");
            this.buf.append(Transform.escapeTags(locationInfo.getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(locationInfo.getFileName());
            this.buf.append("\" line=\"");
            this.buf.append(locationInfo.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        this.buf.append("</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }
}

