/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.StringUtils;
import com.wily.util.io.IConstructorExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Glob
implements IConstructorExternalizable {
    private final String pattern;
    private final String[] globs;

    public Glob(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pattern = in.readUTF();
        this.globs = (String[])in.readObject();
    }

    public Glob(String pattern) {
        this.pattern = pattern;
        this.globs = StringUtils.parseAndTrimList(pattern, "*", true);
    }

    public boolean matches(String input) {
        int curIndex = 0;
        for (int i = 0; i < this.globs.length; ++i) {
            if (this.globs[i].length() == 0) continue;
            if (curIndex >= input.length()) {
                return false;
            }
            int occurence = input.indexOf(this.globs[i], curIndex);
            if (occurence == -1) {
                return false;
            }
            curIndex = occurence + this.globs[i].length();
        }
        return input.startsWith(this.globs[0]) && input.endsWith(this.globs[this.globs.length - 1]);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Glob)) {
            return false;
        }
        Glob g = (Glob)o;
        return this.pattern.equals(g.pattern);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: pattern input");
            return;
        }
        Glob g = new Glob(args[0]);
        System.out.println(g.matches(args[1]) ? "Matches" : "Does not match");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.pattern);
        out.writeObject(this.globs);
    }
}

