/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.AgentArgsValidator;
import com.wily.introscope.agent.launch.core.BootstrapAgentInstallDirValidator;
import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.BootstrapAgentValidationException;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;

public class BootstrapAgent {
    public static void premain(String agentArgs, Instrumentation instrumentation) {
        try {
            BootstrapAgent.init(instrumentation);
            Class<?> bootstrapAdminClass = Class.forName("com.wily.introscope.agent.launch.core.BootstrapAdministrator");
            Method bootstrapMethod = bootstrapAdminClass.getMethod("bootstrap", String.class, Instrumentation.class, String.class);
            bootstrapMethod.invoke(null, agentArgs, instrumentation, "premain");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private static void init(Instrumentation instrumentation) {
        String bootstrapAgentInstallDir = BootstrapAgentUtil.getBootstrapAgentInstallDir();
        Logger LOGGER = BootstrapAgentLogger.getLogger();
        LOGGER.info("Loading Bootstrap Agent");
        LOGGER.fine("Bootstrap Agent install dir: " + bootstrapAgentInstallDir);
        LOGGER.finer(String.format("isRedefineClassesSupported(): %s, isRetransformClassesSupported: %s", instrumentation.isRedefineClassesSupported(), instrumentation.isRetransformClassesSupported()));
        if (!BootstrapAgentInstallDirValidator.isValidPath(bootstrapAgentInstallDir)) {
            throw new BootstrapAgentValidationException("Path of BootstrapAgent is not valid. Please specify the location of Agent.jar using -Dbootstrap.jar.absolute.location");
        }
        BootstrapAgentInstallDirValidator validationHandler = new BootstrapAgentInstallDirValidator("bootstrap.location");
        AgentArgsValidator.registerValidationHandler(validationHandler);
        validationHandler.validate(bootstrapAgentInstallDir);
    }
}

