/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blamestackfeature;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blame.CompoundComponentParameterCallback;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.ParameterGatheringCallback;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.clock.MasterClock;
import java.util.HashMap;

public class BlameStackFeatureStackEntry {
    private String component;
    private IComponentParameterCallback callback;
    private ParameterGatheringCallback paramCallback;
    private long startTime;

    public BlameStackFeatureStackEntry() {
        this.reset();
    }

    public void init(String component) {
        this.component = component;
        this.startTime = MasterClock.currentTimeMillis();
        this.callback = null;
        this.paramCallback = null;
    }

    public void reset() {
        this.component = null;
        this.callback = null;
        this.paramCallback = null;
        this.startTime = -1L;
    }

    public TransactionComponentData createComponentEventData(long nowRoughly, HashMap extraParams, TransactionComponentData[] kids) {
        HashMap params;
        long duration = nowRoughly - this.getStartTime();
        if (this.callback == null && extraParams == null && this.paramCallback == null) {
            return new TransactionComponentData(this.getComponent(), this.getStartTime(), duration, kids);
        }
        HashMap hashMap = params = extraParams == null ? new HashMap(5) : extraParams;
        if (this.callback != null) {
            this.callback.IComponentParameterCallback_addParameters(params);
        }
        if (this.paramCallback != null) {
            this.paramCallback.IComponentParameterCallback_addParameters(params);
        }
        return new TransactionComponentData(this.getComponent(), this.getStartTime(), duration, params, kids);
    }

    public String getComponent() {
        return this.component;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void decorate(String paramName, String paramValue) {
        if (this.paramCallback == null) {
            this.paramCallback = new ParameterGatheringCallback();
        }
        this.paramCallback.addParameter(paramName, paramValue);
    }

    public void decorate(IComponentParameterCallback newCallback) {
        this.callback = this.callback == null ? newCallback : new CompoundComponentParameterCallback(this.callback, newCallback);
    }

    public void dump() {
        try {
            AgentShim.getAgent().IAgent_getModuleFeedback().info("\tstack frame: " + this.component);
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError("The unthinkable has happened", e);
        }
    }

    public String toString() {
        String result = String.valueOf(this.component) + "@" + this.startTime;
        return result;
    }
}

