/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.servlet.RequestWrapper;
import com.wily.introscope.agent.trace.servlet.ServletConfigWrapper;
import com.wily.introscope.agent.trace.servlet.ServletWrapper;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public class ServletObjectFactory {
    private Map fInterfaceCache = new ConcurrentHashMap();
    private ClassLoader fClassLoader;
    private static IWeakIdentityMap sInterfaceCaches = ServletObjectFactory.getCache("ServletObjects");

    private static final IWeakIdentityMap getCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory mapFactory = agent.IAgent_getConcurrentMapFactory();
            return mapFactory.getConcurrentCappedWeakIdentityMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    public ServletObjectFactory(ClassLoader classloader) {
        Assertion.wilyAssert(false);
        this.fClassLoader = classloader;
    }

    public static ServletObjectFactory getServletObjectFactory(Object request) {
        ClassLoader classLoader = request.getClass().getClassLoader();
        ServletObjectFactory cache = null;
        cache = (ServletObjectFactory)sInterfaceCaches.getWeak(classLoader);
        if (cache == null) {
            cache = new ServletObjectFactory(classLoader);
            sInterfaceCaches.putWeak(classLoader, cache);
        }
        return cache;
    }

    public ServletWrapper getServletWrapper(Object servlet) throws ClassNotFoundException {
        return new ServletWrapper(this, servlet);
    }

    public ServletConfigWrapper getServletConfigWrapper(Object servletConfig) throws ClassNotFoundException {
        return new ServletConfigWrapper(this, servletConfig);
    }

    public RequestWrapper getRequestWrapper(Object request) throws ClassNotFoundException {
        return new RequestWrapper(this, request);
    }

    Class getInterface(String interfaceName) throws ClassNotFoundException {
        MethodCache cache = this.getInterfaceMethodCache(interfaceName);
        if (cache == null) {
            throw new ClassNotFoundException();
        }
        return cache.fClazz;
    }

    private MethodCache getInterfaceMethodCache(String interfaceName) throws ClassNotFoundException {
        MethodCache result = null;
        result = (MethodCache)this.fInterfaceCache.get(interfaceName);
        if (result == null) {
            try {
                Class<?> clazz = Class.forName(interfaceName, true, this.fClassLoader);
                result = new MethodCache(clazz);
            }
            catch (ClassNotFoundException ex) {
                AgentShim.handleDebug(this.fClassLoader + " cannot find " + interfaceName, ex);
                throw ex;
            }
            this.fInterfaceCache.put(interfaceName, result);
        }
        return result;
    }

    public Method getInterfaceMethod(String interfaceClassName, String methodName, Class[] parameterClasses) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        MethodCache methodCache = this.getInterfaceMethodCache(interfaceClassName);
        Method method = methodCache.getMethod(methodName, parameterClasses);
        return method;
    }

    private static class MethodCache {
        private final Class fClazz;
        private final Map fMethods;

        public MethodCache(Class clazz) {
            this.fClazz = clazz;
            this.fMethods = new ConcurrentHashMap();
        }

        public Method getMethod(String methodName, Class[] parameterClasses) throws SecurityException, NoSuchMethodException {
            MethodKey key = new MethodKey(methodName, parameterClasses);
            Method method = null;
            method = (Method)this.fMethods.get(key);
            if (method == null) {
                method = this.fClazz.getMethod(methodName, parameterClasses);
                this.fMethods.put(key, method);
            }
            return method;
        }
    }

    private static class MethodKey {
        private final String fMethodName;
        private final Class[] fParameterClasses;

        public MethodKey(String name, Class[] classes) {
            this.fMethodName = name;
            this.fParameterClasses = classes;
        }

        public boolean equals(Object obj) {
            MethodKey other = (MethodKey)obj;
            return this.fMethodName == other.fMethodName && Arrays.equals(this.fParameterClasses, other.fParameterClasses);
        }

        public int hashCode() {
            return this.fMethodName.hashCode();
        }
    }
}

