/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.IPlaceHolderResolver;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;

public class APlaceHolderResolver
implements IPlaceHolderResolver {
    public static final String UNSUPPORTED = "UNSUPPORTED";
    private static String fCachedJVMCompatibleVersionForSocket = null;
    private static APlaceHolderResolver kInstance = new APlaceHolderResolver();

    public static APlaceHolderResolver getInstance() {
        return kInstance;
    }

    public int getPlaceHolderType(String name) {
        if (name.indexOf("${JVMCOMPATIBILITY}") != -1) {
            return 1;
        }
        if (name.indexOf("${JVMVERSION}") != -1) {
            return 2;
        }
        return -1;
    }

    @Override
    public String resolveJVMCompatibility(String name) {
        boolean isSocketRelated = name.toLowerCase().indexOf("socket") != -1;
        String javaVersion = System.getProperty("java.version");
        if (isSocketRelated) {
            return this.resolveJVMCompatibiltyForSocket(javaVersion);
        }
        return this._resolveJVMCompatibilty(javaVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _resolveJVMCompatibilty(String javaVersion) {
        try {
            String[] version = javaVersion.split("\\.");
            if (Integer.parseInt(version[0]) >= 9) {
                boolean patchAgentSocketConfigured = this.isSocketPatchModuleOn();
                if (!patchAgentSocketConfigured) {
                    return UNSUPPORTED;
                }
                return version[0];
            }
            if (Integer.parseInt(version[1]) >= 5) {
                return version[1];
            }
            return "6";
        }
        catch (NumberFormatException numberFormatException) {
            return "6";
        }
    }

    public boolean isSocketPatchModuleOn() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        for (String argument : arguments) {
            if (argument.indexOf("patch-module") == -1 || argument.indexOf("AgentSocket") == -1) continue;
            return true;
        }
        return false;
    }

    private String resolveJVMCompatibiltyForSocket(String javaVersion) {
        if (fCachedJVMCompatibleVersionForSocket == null) {
            String vmName;
            String resovedStr = this._resolveJVMCompatibilty(javaVersion);
            if (UNSUPPORTED.equals(resovedStr)) {
                return resovedStr;
            }
            int version = Integer.parseInt(resovedStr);
            fCachedJVMCompatibleVersionForSocket = version >= 7 ? "7" : (version == 6 ? ((vmName = System.getProperty("java.vm.name")).indexOf("OpenJDK") != -1 ? "7" : "6") : "6");
        }
        return fCachedJVMCompatibleVersionForSocket;
    }

    @Override
    public String resolveAppServerType() {
        return null;
    }

    @Override
    public String resolveJVMVersion() {
        return null;
    }

    public String resolvePlaceHolder(int type) {
        return null;
    }

    @Override
    public String resolvePlaceHolder(String name) {
        int placeHolderType = this.getPlaceHolderType(name);
        StringBuilder buffer = new StringBuilder(name);
        if (1 == placeHolderType) {
            int jvmCompatabiltyVersion = name.indexOf("${JVMCOMPATIBILITY}");
            String jvmResolvedversion = this.resolveJVMCompatibility(name);
            if (name.toLowerCase().indexOf("socket") != -1 && UNSUPPORTED.equals(jvmResolvedversion)) {
                return UNSUPPORTED;
            }
            buffer.replace(jvmCompatabiltyVersion, jvmCompatabiltyVersion + "${JVMCOMPATIBILITY}".length(), jvmResolvedversion);
            return buffer.toString();
        }
        return name;
    }
}

