/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.apply;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.AnalysedClassesMapInitializer;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.DGMethodSkippedException;
import com.wily.diagnos.cmp.directives.DGSetAsSkippedException;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.tracer.DGAggregateMethodTracer;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.cmp.tracer.MethodTracerAggregator;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.introscope.probebuilder.instrumentation.level.IInstrumentationChangeListener;
import com.wily.introscope.probebuilder.instrumentation.level.InstrumentationChangeListenerNullImplementation;
import com.wily.util.adt.IdentityHashSet;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.INarrowedMatchingClass;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClassSettingsApplier {
    private final DGCompilerSettings fSettings;
    private final ICompilerLog fLog;
    private final IClassMutator fTargetClassMutator;
    private final IModeledClass fTargetClass;
    private final String[] fPossibleKeys;
    private static boolean fExceededMaxIntelligentInstrumentations = false;
    private static final IntegerCounter kAnalyzedMethodsCounter = new IntegerCounter(0);
    private static boolean sLogIntelligentInstrumentation = false;
    public static AtomicInteger analysedMapSize = new AtomicInteger(0);
    public static AtomicInteger fInstrumentedMethodsCount = new AtomicInteger(0);
    public static AtomicLong numClassesProcessed = new AtomicLong(0L);
    public static IInstrumentationChangeListener fInstrumentationChangeListener = new InstrumentationChangeListenerNullImplementation();
    private int debug_consideredTracers = 0;

    public static void setInstrumentationChangeListener(IInstrumentationChangeListener fInstrumentationChangeListener) {
        ClassSettingsApplier.fInstrumentationChangeListener = fInstrumentationChangeListener;
    }

    public static void setExceededMaxIntelligentInstrumentations(boolean flag) {
        fExceededMaxIntelligentInstrumentations = flag;
    }

    public static void setLogIntelligentInstrumentation() {
        sLogIntelligentInstrumentation = true;
    }

    public ClassSettingsApplier(DGCompilerSettings settings, ICompilerLog log, IModeledClass targetClass, IClassMutator targetClassMutator) {
        Assertion.wilyAssert(log != null);
        this.fSettings = settings;
        this.fLog = log;
        this.fTargetClass = targetClass;
        this.fTargetClassMutator = targetClassMutator;
        if (this.fTargetClass instanceof INarrowedMatchingClass) {
            INarrowedMatchingClass targetClassAsNarrowedClass = (INarrowedMatchingClass)((Object)targetClass);
            this.fPossibleKeys = targetClassAsNarrowedClass.getPossibleKeys();
        } else {
            this.fPossibleKeys = null;
        }
    }

    public void apply() throws DGClassModificationException, IOException {
        this.preflight();
        this.applyTracerMutations();
        this.applyTransformationDrivenMutations();
    }

    private void preflight() throws DGClassModificationException, IOException {
        this.checkIfShouldSkipClass(this.fTargetClass);
        this.fTargetClassMutator.throwIfAlreadyInstrumented(this.fTargetClass);
        this.fTargetClassMutator.markInstrumented(this.fSettings, this.fTargetClass);
        this.fTargetClassMutator.preflight(this.fSettings, this.fTargetClass);
    }

    protected void checkIfShouldSkipClass(IModeledClass theClass) throws DGSetAsSkippedException {
        if (this.fSettings.getFilter().shouldSkip(theClass)) {
            throw new DGSetAsSkippedException();
        }
    }

    protected DGCompilerSettings getSettings() {
        return this.fSettings;
    }

    public static void executeBatchMutations(IMutation[] mutations) throws DGClassModificationException, IOException {
        int x = 0;
        while (x < mutations.length) {
            mutations[x].mutate();
            ++x;
        }
    }

    public void applyTransformationDrivenMutations() throws DGClassModificationException, IOException {
        ArrayList allMutationsList = new ArrayList();
        Iterator transformations = this.fSettings.getTransformationsIterator();
        while (transformations.hasNext()) {
            ITransformation transform = (ITransformation)transformations.next();
            Object[] newMutations = transform.generateMutations(this.fSettings, this.fTargetClass, this.fTargetClassMutator);
            ClassSettingsApplier.appendToList(allMutationsList, newMutations);
        }
        for (IMutation mutation : allMutationsList) {
            mutation.mutate();
        }
    }

    private static void appendToList(List target, Object[] newElements) {
        int x = 0;
        while (x < newElements.length) {
            target.add(newElements[x]);
            ++x;
        }
    }

    private void addTracer(IModeledMethod method, MethodTracer tracer, Map repository, Map duplicate) {
        HashSet<MethodTracer> tracerList = (HashSet<MethodTracer>)repository.get(method);
        if (tracerList == null) {
            tracerList = new HashSet<MethodTracer>();
            repository.put(method, tracerList);
        }
        if (!tracerList.contains(tracer)) {
            tracerList.add(tracer);
        } else {
            ArrayList<MethodTracer> duplicateList = (ArrayList<MethodTracer>)duplicate.get(method);
            if (duplicateList == null) {
                duplicateList = new ArrayList<MethodTracer>();
                duplicate.put(method, duplicateList);
            }
            duplicateList.add(tracer);
        }
    }

    public ArrayList filterMethodsInstrumentedByIntelligentTracer(ArrayList methods) {
        return methods;
    }

    public ArrayList filterMethodsInstrumentedByNormalTracer(ArrayList methods) {
        ArrayList<IModeledMethod> methodsToInstrument = new ArrayList<IModeledMethod>();
        HashMap duplicate = new HashMap();
        Map repository = this.extractTracers(duplicate);
        for (IModeledMethod m : methods) {
            Collection tracers;
            if (!m.hasBytecode() || (tracers = (Collection)repository.get(m)) != null) continue;
            methodsToInstrument.add(m);
        }
        return methodsToInstrument;
    }

    private void applyTracerMutations() throws DGClassModificationException, IOException {
        HashMap duplicate = new HashMap();
        Map repository = this.extractTracers(duplicate);
        Iterator allMethods = this.fTargetClass.getAllDeclaredMethods();
        boolean skipIntelligentInstrumentationForClass = !this.fSettings.isIntelligentInstrumentationEnabled();
        numClassesProcessed.getAndIncrement();
        while (allMethods.hasNext()) {
            IModeledMethod m = (IModeledMethod)allMethods.next();
            if (!m.hasBytecode()) continue;
            Collection tracers = (Collection)repository.get(m);
            if (tracers != null) {
                DGAggregateMethodTracer aggregateTracer = MethodTracerAggregator.aggregate(tracers);
                IMutation tracerMutation = aggregateTracer.newMutation(this.fTargetClassMutator, m);
                try {
                    tracerMutation.mutate();
                    this.fLog.ICompilerLog_logMethodTraced(m);
                    this.logDuplicatedTracersForMethod(repository, duplicate, m);
                    aggregateTracer.logAggregateMethodTracer(this.fLog, m);
                    continue;
                }
                catch (DGMethodSkippedException dGMethodSkippedException) {
                    this.fLog.ICompilerLog_logSkippedMethod(m.getModeledClass().getClassName(), m.getMethodName());
                    continue;
                }
                catch (IOException e) {
                    this.fLog.ICompilerLog_logMessage(e.getMessage());
                    throw e;
                }
            }
            if (skipIntelligentInstrumentationForClass) continue;
            boolean isNewAndClampHit = false;
            this.fTargetClass.getClassName().getPackageName().getNameString();
            String claszname = this.fTargetClass.getClassName().getContainerAndPackageAndNameString();
            short state = 0;
            String className = m.getModeledClass().getClassName().getPackageAndNameString();
            String methodAndDescriptor = m.getMethodName().getNameAndSignatureString();
            boolean doNotSkip = AnalysedClassesMapInitializer.shouldNotSkipClass(claszname);
            if (!(this.fTargetClass.isInterface() || !doNotSkip && this.fSettings.getFilter().shouldSkipIntelligentInstrumentation(claszname))) {
                short[] tempArr = AnalysedClassesMapInitializer.getMethodMetadata(className, methodAndDescriptor, "");
                if (tempArr == null) {
                    if (analysedMapSize.get() < 300000) {
                        kAnalyzedMethodsCounter.increment();
                        short score = (short)((DGMethod)m).getMethodScore();
                        short threshold = fInstrumentationChangeListener.isValidDecisionThresholdSet() ? (short)fInstrumentationChangeListener.getDecisionThreshold() : (short)fInstrumentationChangeListener.getHighInstrumentationLevel();
                        if (score >= threshold) {
                            short[] value = new short[4];
                            value[0] = score;
                            analysedMapSize.getAndIncrement();
                            AnalysedClassesMapInitializer.updateMethodMetadata(className, methodAndDescriptor, "", value);
                            AnalysedClassesMapInitializer.addCandidateClass(className);
                        }
                    } else {
                        isNewAndClampHit = true;
                    }
                } else {
                    state = tempArr[2];
                    if (state == 0) {
                        ((DGMethod)m).getMethodScore();
                    }
                    if (state == 3) {
                        if (fInstrumentedMethodsCount.get() > 0) {
                            fInstrumentedMethodsCount.getAndDecrement();
                        } else {
                            fInstrumentedMethodsCount.set(0);
                        }
                        fExceededMaxIntelligentInstrumentations = false;
                    }
                }
                if (isNewAndClampHit || !this.shouldInstrument(m, state)) continue;
                if (state != 1) {
                    fInstrumentedMethodsCount.getAndIncrement();
                }
                MethodTracer intelligentTracer = this.fSettings.getIntelligentInstrumentationMethodTracer();
                DGAggregateMethodTracer aggregateTracer = MethodTracerAggregator.aggregateForIntelligentInstrumentation(intelligentTracer);
                IMutation tracerMutation = aggregateTracer.newMutation(this.fTargetClassMutator, m);
                try {
                    tracerMutation.mutate();
                    if (!sLogIntelligentInstrumentation) continue;
                    this.fLog.ICompilerLog_logMethodTraced(m);
                    this.logDuplicatedTracersForMethod(repository, duplicate, m);
                    aggregateTracer.logAggregateMethodTracer(this.fLog, m);
                    continue;
                }
                catch (DGMethodSkippedException dGMethodSkippedException) {
                    this.fLog.ICompilerLog_logSkippedMethod(m.getModeledClass().getClassName(), m.getMethodName());
                    continue;
                }
                catch (IOException e) {
                    this.fLog.ICompilerLog_logMessage(e.getMessage());
                    throw e;
                }
            }
            skipIntelligentInstrumentationForClass = true;
        }
    }

    private boolean shouldInstrument(IModeledMethod m, int state) {
        return state == 1 || state == 2 || !fExceededMaxIntelligentInstrumentations && state != 3 && state != 4 && ((DGMethod)m).passesIntelligentInstrumentationCriterea();
    }

    private Map extractTracers(Map duplicate) {
        HashMap repository = new HashMap();
        if (this.fPossibleKeys == null) {
            Iterator iterator = this.fSettings.getTracersIterator();
            this.extractTracersFromIteratorInMap(repository, duplicate, iterator);
        } else {
            int i = 0;
            while (i < this.fPossibleKeys.length) {
                Iterator iterator = this.fSettings.getTracersIterator(this.fPossibleKeys[i]);
                this.extractTracersFromIteratorInMap(repository, duplicate, iterator);
                ++i;
            }
            Iterator iterator = this.fSettings.getTracersIterator("AllKeys");
            this.extractTracersFromIteratorInMap(repository, duplicate, iterator);
        }
        return repository;
    }

    private void extractTracersFromIteratorInMap(Map repository, Map duplicate, Iterator iterator) {
        while (iterator.hasNext()) {
            if (Assertion.isEnabled()) {
                ++this.debug_consideredTracers;
            }
            this.iterateThroughTracers(repository, duplicate, iterator);
        }
    }

    private void iterateThroughTracers(Map repository, Map duplicate, Iterator iterator) {
        MethodTracer tracer = (MethodTracer)iterator.next();
        if (!ClassSettingsApplier.shouldSkipClassForTracerGroup(this.fLog, this.fTargetClass, tracer.getTracerGroup()) && tracer.getClassMatcher().IClassMatcher_matches(this.fTargetClass)) {
            IMethodMatcher methodMatcher = tracer.getMethodMatcher();
            Iterator methods = this.fTargetClass.getAllDeclaredMethods();
            while (methods.hasNext()) {
                IModeledMethod method = (IModeledMethod)methods.next();
                if (this.shouldSkipMethodInClassForTracerGroup(this.fLog, this.fTargetClass, method, tracer.getTracerGroup()) || this.shouldSkipMethodForClass(this.fLog, this.fTargetClass, method) || !methodMatcher.IMethodMatcher_matches(method)) continue;
                this.addTracer(method, tracer, repository, duplicate);
            }
        }
    }

    public Map getTracersMap() {
        return this.extractTracers(new HashMap());
    }

    private void logDuplicatedTracersForMethod(Map repository, Map duplicatedTracersMap, IModeledMethod method) {
        List duplicatedTracers = (List)duplicatedTracersMap.get(method);
        if (duplicatedTracers != null) {
            Object t;
            IdentityHashSet set = new IdentityHashSet();
            int i = 0;
            while (i < duplicatedTracers.size()) {
                t = duplicatedTracers.get(i);
                set.add(t);
                ++i;
            }
            Iterator i2 = set.iterator();
            block1: while (i2.hasNext()) {
                t = (MethodTracer)i2.next();
                Collection appliedTracers = (Collection)repository.get(method);
                for (MethodTracer original : appliedTracers) {
                    if (!original.equals(t)) continue;
                    String originalFilename = original.getFileName();
                    String duplicateFilename = ((MethodTracer)t).getFileName();
                    if (originalFilename == null) {
                        this.fLog.ICompilerLog_logMessage("ClassSettingsApplier.logDuplicatedTracersForMethod duplicateFilename=" + duplicateFilename + " className=" + original.getTracerClass().getContainerAndPackageAndNameString() + " line=" + original.getLine());
                        continue block1;
                    }
                    boolean areEquals = originalFilename.equals(duplicateFilename);
                    if (areEquals && (!areEquals || original.getLine() == ((MethodTracer)t).getLine())) continue block1;
                    this.fLog.ICompilerLog_logMessage("Duplicate tracer found @ " + duplicateFilename + "; line " + ((MethodTracer)t).getLine() + " of tracer @ " + originalFilename + "; line " + original.getLine());
                    continue block1;
                }
            }
        }
    }

    private boolean shouldSkipMethodForClass(ICompilerLog log, IModeledClass targetClass, IModeledMethod method) {
        return this.fSettings.getFilter().shouldSkip(targetClass, method, false);
    }

    public static boolean shouldSkipClassForTracerGroup(ICompilerLog log, IModeledClass theClass, TracerGroup tracerGroup) {
        boolean shouldSkip = false;
        if (tracerGroup != null) {
            if (tracerGroup.isEnabled()) {
                if (tracerGroup.shouldSkipInstrumentationInClass(theClass)) {
                    log.ICompilerLog_logSkippedClassForFlag(tracerGroup.getName().getName());
                    shouldSkip = true;
                }
            } else {
                shouldSkip = true;
            }
        }
        return shouldSkip;
    }

    private boolean shouldSkipMethodInClassForTracerGroup(ICompilerLog log, IModeledClass theClass, IModeledMethod theMethod, TracerGroup tracerGroup) {
        return CompilerSettingsUtility.shouldSkipMethodInClassForTracerGroup(log, theClass, theMethod, false, tracerGroup);
    }

    public static int getTotalNumberOfAnalyzedMethods() {
        return kAnalyzedMethodsCounter.get();
    }

    private static class IntegerCounter {
        private int count = 0;

        IntegerCounter(int initialValue) {
            this.count = initialValue;
        }

        public synchronized int get() {
            return this.count;
        }

        public synchronized int add(int delta) {
            return this.count += delta;
        }

        public synchronized void increment() {
            ++this.count;
        }

        public synchronized void decrement() {
            --this.count;
        }
    }
}

