/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.personality.java.classfile.DGClassConstants;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttributes;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class DGField
implements DGClassConstants,
Cloneable {
    protected int fAccessFlags;
    protected int fCPI_name;
    protected int fCPI_descriptor;
    protected DGAttributes fAttributes;
    protected DGConstantPool fConstantPool;
    protected final ICompilerLog fLog;

    public DGField(DGConstantPool cp, DataInputStream in, ICompilerLog log) throws DGClassLoadingException, IOException {
        this.fConstantPool = cp;
        this.fLog = log;
        this.fAccessFlags = in.readUnsignedShort();
        this.fCPI_name = in.readUnsignedShort();
        this.fCPI_descriptor = in.readUnsignedShort();
        this.fAttributes = new DGAttributes(this.fConstantPool, in, log);
    }

    public DGField(DGConstantPool cp, String fieldName, String fieldDesc, int accessFlags) throws DGClassModificationException {
        this.fConstantPool = cp;
        this.fLog = null;
        this.fAccessFlags = accessFlags;
        this.fCPI_name = this.fConstantPool.addUtf(fieldName);
        this.fCPI_descriptor = this.fConstantPool.addUtf(fieldDesc);
        this.fAttributes = new DGAttributes(cp);
    }

    public DGConstantPool getConstantPool() {
        return this.fConstantPool;
    }

    public String getName() {
        return this.fConstantPool.getUtf(this.fCPI_name);
    }

    public DGAttributes getAttributes() {
        return this.fAttributes;
    }

    public String getTypeDescriptor() {
        return this.fConstantPool.getUtf(this.fCPI_descriptor);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.fAccessFlags);
        out.writeShort(this.fCPI_name);
        out.writeShort(this.fCPI_descriptor);
        this.fAttributes.write(out);
    }

    public int getAccessFlags() {
        return this.fAccessFlags;
    }

    public boolean isStatic() {
        return (this.fAccessFlags & 8) != 0;
    }
}

