/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncHttpFrontendStartTracer;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.servlet.IHttpRequestHelper;
import com.wily.introscope.agent.trace.servlet.IServlet3RequestHelper;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.ServletHelperFactory;
import com.wily.util.properties.AttributeListing;

public class AsyncHttpServletFrontendStartTracer
extends AsyncHttpFrontendStartTracer {
    public AsyncHttpServletFrontendStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected String getApplicationName(InvocationData data) {
        Object servlet = data.getInvocationObject();
        Object request = data.getInvocationParameterAsObject(0);
        IServletRequestHelper helper = ServletHelperFactory.getServletHelper(request, request.getClass().getClassLoader(), this.agent.IAgent_getModuleFeedback());
        return helper.getApplicationName(request, servlet);
    }

    @Override
    protected IHttpRequestHelper getHttpRequestHelper(InvocationData data) {
        Object request = data.getInvocationParameterAsObject(0);
        IServletRequestHelper helper = ServletHelperFactory.getServletHelper(request, request.getClass().getClassLoader(), this.agent.IAgent_getModuleFeedback());
        return helper;
    }

    @Override
    protected Object getHttpRequestObject(InvocationData data) {
        return data.getInvocationParameterAsObject(0);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        VirtualStack.TransactionCache tc = VirtualStack.getTransactionCache();
        if (!tc.isDownstreamServletTracing()) {
            return;
        }
        if (!this.isAsyncSypported(data)) {
            return;
        }
        tc.disableDownstreamServletTracing();
        super.ITracer_startTrace(tracerIndex, data);
    }

    private boolean isAsyncSypported(InvocationData data) {
        IHttpRequestHelper helper = this.getHttpRequestHelper(data);
        if (helper instanceof IServlet3RequestHelper) {
            IServlet3RequestHelper helper3 = (IServlet3RequestHelper)helper;
            return helper3.isAsyncSupported(this.getHttpRequestObject(data));
        }
        return false;
    }

    @Override
    protected boolean isAsyncStarted(InvocationData data) {
        IHttpRequestHelper helper = this.getHttpRequestHelper(data);
        if (helper instanceof IServlet3RequestHelper) {
            IServlet3RequestHelper helper3 = (IServlet3RequestHelper)helper;
            Object request = this.getHttpRequestObject(data);
            return helper3.isAsyncStarted(request);
        }
        return false;
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        VirtualStack.TransactionCache tc = VirtualStack.getTransactionCache();
        String componentName = data.getComponentNameAt(tracerIndex);
        if (componentName == null) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
        tc.enableDownstreamServletTracing();
    }
}

