/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.connector;

import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.classmatcher.DGExactClassMatcher;
import com.wily.diagnos.cmp.log.NullCompilerLog;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorByteCode;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorCreationFailedException;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorCreatorCommandLine;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorCreatorEnvironment;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorException;
import com.wily.introscope.autoprobe.connector.AutoProbeConnectorJVMUtilities;
import com.wily.introscope.etc.AIntroscopeApplication;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.classfile.ClassFileException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.commandline.ParsingException;
import com.wily.util.feedback.ApplicationFeedback;
import com.wily.util.io.ExtendedFile;
import com.wily.util.io.StreamCopier;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.ValidationException;
import com.wily.util.version.IVersion;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class AutoProbeConnectorCreator
extends AIntroscopeApplication {
    private final PrintWriter fOutputWriter;
    private final PrintWriter fErrorWriter;
    private final AutoProbeConnectorCreatorCommandLine fCommands;

    public static void main(String[] args) {
        try {
            PrintWriter outputWriter = null;
            PrintWriter errorWriter = null;
            ApplicationFeedback feedback = null;
            MultipleResourceBundleStringLocalizer localizer = null;
            try {
                outputWriter = new PrintWriter(System.out, true);
                errorWriter = new PrintWriter(System.err, true);
                feedback = new ApplicationFeedback("Creator", false);
                localizer = new MultipleResourceBundleStringLocalizer(feedback, AutoProbeConnectorCreator.class.getClassLoader(), new String[]{"com.wily.introscope.autoprobe.connector.properties.AutoProbeConnectorCreatorReleaseStrings", "com.wily.introscope.autoprobe.connector.properties.AutoProbeConnectorCreatorStrings", "com.wily.properties.CoreCommonStrings", "com.wily.properties.CoreErrorMessages", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.diagnos.properties.DiagnosStrings", "com.wily.introscope.properties.IntroscopeVersionStrings"});
            }
            catch (Throwable t) {
                System.out.println("[ERROR] AutoProbe Connector Creation Utility was unable to start:" + t.getMessage());
                t.printStackTrace(System.err);
                throw t;
            }
            try {
                AutoProbeConnectorCreatorCommandLine commands = new AutoProbeConnectorCreatorCommandLine(args, localizer);
                AutoProbeConnectorCreator autoProbeConnectorCreator = new AutoProbeConnectorCreator(outputWriter, errorWriter, feedback, localizer, new IntroscopeVersion(localizer), commands);
                autoProbeConnectorCreator.run();
            }
            catch (ParsingException pe) {
                outputWriter.println(localizer.IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Invalid_Argument", pe.getMessage()));
                outputWriter.println(localizer.IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_How_To_Access_Help_Message"));
                throw pe;
            }
        }
        catch (Throwable throwable) {
            System.exit(1);
        }
        System.exit(0);
    }

    public AutoProbeConnectorCreator(PrintWriter outputWriter, PrintWriter errorWriter, ApplicationFeedback feedback, IStringLocalizer localizer, IVersion version, AutoProbeConnectorCreatorCommandLine commands) throws IOException {
        super(feedback, localizer, version, localizer.IStringLocalizer_getLocalizedString("Introscope_Create_AutoProbe_Connector_Long_Name"), localizer.IStringLocalizer_getLocalizedString("Introscope_Create_AutoProbe_Connector_Short_Name"), false);
        this.fOutputWriter = outputWriter;
        this.fErrorWriter = errorWriter;
        this.fCommands = commands;
    }

    public PrintWriter getOutputWriter() {
        return this.fOutputWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.fErrorWriter;
    }

    void run() throws Throwable {
        try {
            AutoProbeConnectorCreatorEnvironment env = this.fCommands.getAutoProbeConnectorCreatorEnvironment();
            this.getOutputWriter().println();
            if (env.shouldShowHelp()) {
                this.giveHelp();
            } else {
                this.createConnector(env);
            }
        }
        catch (ValidationException ve) {
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Validation_Failure", ve.getRequiredCondition().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer())));
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_How_To_Access_Help_Message"));
            throw ve;
        }
        catch (AutoProbeConnectorCreationFailedException apccfe) {
            this.getOutputWriter().println(apccfe.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()));
            throw apccfe;
        }
        catch (Throwable t) {
            this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Unknown_Failure"));
            t.printStackTrace(this.getErrorWriter());
            throw t;
        }
    }

    private void giveHelp() {
        this.fCommands.printHelp(this.getOutputWriter());
    }

    private void createConnector(AutoProbeConnectorCreatorEnvironment environment) throws AutoProbeConnectorCreationFailedException, IOException, ValidationException {
        environment.IValidatable_validate();
        ZipFile runtimeJar = this.findRuntimeJar(environment.getJVMDirectory());
        String jvmIdentity = this.loadJVMIdentity(runtimeJar);
        ExtendedFile outputFile = environment.getOutputFile();
        JarOutputStream outputStream = this.generateOutputStream(outputFile, jvmIdentity);
        try {
            this.modifyClassLoader(runtimeJar, jvmIdentity, outputStream);
            this.writeConnectorClasses(outputStream);
        }
        finally {
            runtimeJar.close();
            outputStream.close();
        }
        this.getOutputWriter().println(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Feedback_Connector_Created", outputFile.safeGetCanonicalPath()));
    }

    private JarOutputStream generateOutputStream(ExtendedFile outputFile, String jvmIdentity) throws IOException {
        return new JarOutputStream((OutputStream)new FileOutputStream(outputFile.getFile()), this.generateManifest(jvmIdentity));
    }

    private Manifest generateManifest(String jvmIdentity) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        String releaseString = this.getVersion().IVersion_getReleaseString();
        String buildNumber = this.getVersion().IVersion_getBuildNumberString();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Created-By", "Wily Technology, Inc.");
        attributes.putValue("com-wily-Name", "Introscope AutoProbe Connector");
        attributes.putValue("com-wily-Release", releaseString);
        attributes.putValue("com-wily-Build", buildNumber);
        attributes.putValue("com-wily-Connector-JVM-Identity", jvmIdentity);
        return manifest;
    }

    private void modifyClassLoader(ZipFile runtimeJar, String jvmIdentity, JarOutputStream outputStream) throws AutoProbeConnectorCreationFailedException, IOException {
        long classLoaderCheckSum = this.generateCheckSum(runtimeJar);
        InputStream classLoader = this.loadClassLoader(runtimeJar);
        try {
            try {
                DGClass dgclass = new DGClass(classLoader, new NullCompilerLog());
                this.addAutoProbeConnector(dgclass, jvmIdentity, classLoaderCheckSum);
                JarEntry entry = new JarEntry("java/lang/ClassLoader.class");
                outputStream.putNextEntry(entry);
                dgclass.write(outputStream);
                outputStream.closeEntry();
            }
            catch (ClassFileException cfe) {
                throw new AutoProbeConnectorCreationFailedException(cfe.ILocalizableException_getLocalizableMessage());
            }
            catch (DGClassException dgce) {
                throw new AutoProbeConnectorCreationFailedException(dgce.ILocalizableException_getLocalizableMessage());
            }
        }
        finally {
            classLoader.close();
        }
    }

    private void addAutoProbeConnector(DGClass dgclass, String jvmIdentity, long classLoaderCheckSum) throws AutoProbeConnectorCreationFailedException, ClassFileException, DGClassException, IOException {
        ClassName className = ClassName.getClassName("java/lang/ClassLoader");
        MethodName methodName = MethodName.getMethodNameWithDescriptor("defineClass(Ljava/lang/String;[BIILjava/security/ProtectionDomain;)Ljava/lang/Class;");
        DGExactClassMatcher classMatcher = new DGExactClassMatcher(className);
        NamedMethodMatcher methodMatcher = new NamedMethodMatcher(methodName);
        if (!classMatcher.IClassMatcher_matches(dgclass)) {
            throw new AutoProbeConnectorCreationFailedException(new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_Unexpected_Class_Found", dgclass.getClassName().getPackageAndNameString()));
        }
        boolean foundDefineClass = false;
        Enumeration e = dgclass.getMethods();
        while (e.hasMoreElements()) {
            DGMethod method = (DGMethod)e.nextElement();
            if (!methodMatcher.IMethodMatcher_matches(method)) continue;
            foundDefineClass = true;
            break;
        }
        if (!foundDefineClass) {
            throw new AutoProbeConnectorCreationFailedException(new SimpleLocalizableMessage("Auto_Probe_Connector_Creator_Define_Class_Method_Not_Found"));
        }
        AutoProbeConnectorByteCode bytecode = new AutoProbeConnectorByteCode("com/wily/introscope/autoprobe/connector/AutoProbeConnector", "addProbes", dgclass, jvmIdentity, classLoaderCheckSum);
        dgclass.addBytecodeToMethodStart(classMatcher, methodMatcher, bytecode);
    }

    private void writeConnectorClasses(JarOutputStream outputStream) throws AutoProbeConnectorCreationFailedException, IOException {
        boolean hasSuperSecretSystemProperty;
        this.writeConnectorClass(outputStream, "com/wily/introscope/autoprobe/connector/AutoProbeConnector.class");
        boolean bl = hasSuperSecretSystemProperty = System.getProperty("disableRuntimeChecks") != null;
        if (hasSuperSecretSystemProperty) {
            this.writeConnectorClass(outputStream, "com/wily/introscope/autoprobe/connector/RelaxedJVMCheckMarker.class");
        }
        this.writeConnectorClass(outputStream, "com/wily/introscope/autoprobe/connector/KAutoProbeConnectorConstants.class");
        this.writeConnectorClass(outputStream, "com/wily/introscope/autoprobe/connector/AutoProbeConnectorJVMUtilities.class");
        this.writeConnectorClass(outputStream, "com/wily/introscope/autoprobe/connector/AutoProbeConnectorException.class");
    }

    private void writeConnectorClass(JarOutputStream outputStream, String resourceName) throws AutoProbeConnectorCreationFailedException, IOException {
        InputStream connectorClass = ClassLoader.getSystemResourceAsStream(resourceName);
        if (connectorClass == null) {
            throw new AutoProbeConnectorCreationFailedException(new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_Connector_Class_Not_Found", resourceName));
        }
        JarEntry entry = new JarEntry(resourceName);
        outputStream.putNextEntry(entry);
        StreamCopier.copy(connectorClass, outputStream);
        outputStream.closeEntry();
    }

    private ZipFile findRuntimeJar(ExtendedFile jvmDirectory) throws AutoProbeConnectorCreationFailedException, IOException {
        try {
            return AutoProbeConnectorJVMUtilities.findRuntimeJar(jvmDirectory.getFile());
        }
        catch (AutoProbeConnectorException autoProbeConnectorException) {
            throw new AutoProbeConnectorCreationFailedException(new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_Cannot_Find_Runtime_Jar", jvmDirectory.safeGetCanonicalPath()));
        }
    }

    private String loadJVMIdentity(ZipFile runtimeJar) throws AutoProbeConnectorCreationFailedException, IOException {
        try {
            return AutoProbeConnectorJVMUtilities.loadJVMIdentity(runtimeJar);
        }
        catch (AutoProbeConnectorException apce) {
            throw new AutoProbeConnectorCreationFailedException(apce, (ILocalizableMessage)new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_Cannot_Determine_JVM_Identity", apce.getMessage()));
        }
    }

    private InputStream loadClassLoader(ZipFile runtimeJar) throws AutoProbeConnectorCreationFailedException, IOException {
        try {
            return AutoProbeConnectorJVMUtilities.loadClassLoader(runtimeJar);
        }
        catch (AutoProbeConnectorException autoProbeConnectorException) {
            throw new AutoProbeConnectorCreationFailedException(new SimpleLocalizableMessage("Auto_Probe_Connector_Creator_Cannot_Find_Classloader_Entry"));
        }
    }

    private long generateCheckSum(ZipFile runtimeJar) throws AutoProbeConnectorCreationFailedException, IOException {
        try {
            return AutoProbeConnectorJVMUtilities.generateCheckSum(runtimeJar);
        }
        catch (AutoProbeConnectorException apce) {
            throw new AutoProbeConnectorCreationFailedException(apce, (ILocalizableMessage)new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_Cannot_Determine_JVM_Identity", apce.getMessage()));
        }
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

