/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container;

import com.wily.isengard.IsengardException;
import com.wily.isengard.container.IMessageServiceReference;
import com.wily.isengard.container.MessageServiceRegistration;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.service.RegisteredMessageService;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.List;

public class MessageServiceRegistry {
    private PostOffice fPostOffice;
    private List fRegistrations = new ArrayList();
    private IModuleFeedbackChannel fModuleFeedback;

    public MessageServiceRegistry(IModuleFeedbackChannel feedback, PostOffice po) {
        this.fModuleFeedback = feedback;
        this.fPostOffice = po;
    }

    public synchronized IMessageServiceReference addMessageServiceRegistration(MessageServiceRegistration registration) throws EntryAlreadyExistsException, ConnectionException, InvalidIsengardInterface, InvalidPathException {
        MessageServiceReference reference = new MessageServiceReference(registration);
        if (this.fPostOffice != null) {
            this.register(reference);
        }
        this.fRegistrations.add(reference);
        return reference;
    }

    protected IModuleFeedbackChannel getModuleFeedback() {
        return this.fModuleFeedback;
    }

    private synchronized void removeMessageServiceRegistration(MessageServiceReference reference) {
        this.fRegistrations.remove(reference);
    }

    private void register(MessageServiceReference ref) throws EntryAlreadyExistsException, ConnectionException, InvalidIsengardInterface, InvalidPathException {
        RegisteredMessageService bms = new RegisteredMessageService(this.fPostOffice);
        bms.registerMessageService(ref.fRegistration);
        ref.fRegisteredMessageService = bms;
    }

    protected synchronized void noticeConnected(PostOffice po) {
        this.fPostOffice = po;
        for (MessageServiceReference ref : this.fRegistrations) {
            try {
                this.register(ref);
            }
            catch (IsengardException e) {
                this.getModuleFeedback().error(e.toString());
                this.getModuleFeedback().debug(e);
            }
        }
    }

    protected synchronized void noticeDisconnected() {
        this.fPostOffice = null;
    }

    private class MessageServiceReference
    implements IMessageServiceReference {
        final MessageServiceRegistration fRegistration;
        RegisteredMessageService fRegisteredMessageService;

        public MessageServiceReference(MessageServiceRegistration registration) {
            this.fRegistration = registration;
        }

        @Override
        public void unregister() {
            MessageServiceRegistry.this.removeMessageServiceRegistration(this);
            if (this.fRegisteredMessageService != null) {
                this.fRegisteredMessageService.close();
                this.fRegisteredMessageService = null;
            }
        }
    }
}

