/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentConstants;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class JavaAgentLauncher
implements BootstrapAgentConstants {
    private static final Logger LOGGER = BootstrapAgentLogger.getLogger();

    public static void premain(String agentArgs, Instrumentation instrumentation, Map<String, String> startupParams) {
        String agentJarLocation = startupParams.get("core.agent.jar.location");
        JavaAgentLauncher.updateClassloaderSerachPaths(agentJarLocation, instrumentation);
        JavaAgentLauncher.updateProfileProperty(startupParams);
        LOGGER.finer("JavaAgentLauncher going to launch Java Agent");
        boolean success = JavaAgentLauncher.safeStartAgent(agentArgs, startupParams, instrumentation);
        if (success) {
            LOGGER.info("Successfully launched Java Agent");
        } else {
            LOGGER.severe("Failed to lauch Java Agent. Please check logs for errors.");
        }
    }

    private static void updateClassloaderSerachPaths(String agentJarLocation, Instrumentation instrumentation) {
        LOGGER.finer("JavaAgentLauncher updating classloader search paths with: " + agentJarLocation);
        String url = "file:/" + agentJarLocation;
        url = url.replace('\\', '/');
        try {
            JarFile jarFile = new JarFile(new File(agentJarLocation));
            BootstrapAgentUtil.appendToBootstrapClassLoaderSearch(instrumentation, jarFile);
            BootstrapAgentUtil.appendToSystemClassLoaderSearch(instrumentation, jarFile);
        }
        catch (ThreadDeath td) {
            LOGGER.log(Level.SEVERE, "ThreadDeath Exception occurred while launching Java Agent", td);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.log(Level.SEVERE, "Exception occurred while launching Java Agent", t);
        }
    }

    private static void updateProfileProperty(Map<String, String> parameters) {
        String profileAbsoluteLocation = parameters.get("absolute.profile.location");
        LOGGER.info("Using agent profile " + profileAbsoluteLocation);
        System.setProperty("com.wily.introscope.agentProfile", profileAbsoluteLocation);
    }

    private static boolean safeStartAgent(String args, Map parameters, Instrumentation instrumentation) {
        try {
            Class<?> agentLaunchClass = Class.forName("com.wily.introscope.api.instrument.JavaAgent");
            Method m = agentLaunchClass.getMethod("premain", String.class, Instrumentation.class);
            m.invoke(null, args, instrumentation);
            return true;
        }
        catch (ThreadDeath td) {
            LOGGER.log(Level.SEVERE, "ThreadDeath Exception occurred while launching Java Agent", td);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.log(Level.SEVERE, "Exception occurred while launching Java Agent", t);
            return false;
        }
    }
}

