/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.IExtensionLocator;
import com.wily.util.extension.IExtensionProxy;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarExtensionProxy;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

public final class ShallowJarExtensionLocator
implements IExtensionLocator {
    private final IModuleFeedbackChannel fFeedback;
    private final ExtendedFile fDirectory;

    public ShallowJarExtensionLocator(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ExtendedFile directoryWithJars) {
        Assertion.wilyAssert(feedback != null);
        Assertion.wilyAssert(directoryWithJars != null);
        Assertion.wilyAssert(directoryWithJars.isDirectory());
        this.fFeedback = feedback;
        this.fDirectory = directoryWithJars;
    }

    private final IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public IExtensionProxy[] IExtensionLocator_locateExtensionProxies() {
        ArrayList<JarExtensionProxy> extensionProxies = new ArrayList<JarExtensionProxy>();
        File[] jars = this.fDirectory.listFiles(new JarFilenameFilter());
        for (int x = 0; x < jars.length; ++x) {
            ExtendedFile jar = new ExtendedFile(jars[x].getPath());
            try {
                JarExtensionProxy jarExtensionProxy = new JarExtensionProxy(jar);
                extensionProxies.add(jarExtensionProxy);
                continue;
            }
            catch (InvalidExtensionException ioe) {
                this.getFeedback().error("Candidate jar file " + jar + " is not a legal extension: " + ioe);
                this.getFeedback().debug(ioe);
                continue;
            }
            catch (Throwable t) {
                this.getFeedback().error("Unexpected exception while loading candidate jar file " + jar, t);
            }
        }
        return extensionProxies.toArray(new IExtensionProxy[extensionProxies.size()]);
    }

    private static class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

