/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.netinterfacetool;

import com.wily.introscope.agent.environment.NetworkInterfaceDescriptor;
import com.wily.introscope.agent.environment.NetworkInterfaceDescriptorFactory;
import com.wily.introscope.agent.environment.SubNetworks;
import com.wily.introscope.agent.netinterfacetool.BrowserLauncher;
import com.wily.util.WilyStringBuilder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SystemOutFeedbackChannel;
import com.wily.util.io.StreamCopier;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetInterface {
    private static final Module module = new Module("NetInterface");
    private static final int IP_FAMILY_ORDER_ARG = 0;
    private static final int SUB_NETWORKS_ARG = 1;
    private final IModuleFeedbackChannel feedback;
    private final IStringLocalizer localizer;
    private final NetworkInterfaceDescriptorFactory nidFactory;
    private final Writer writer;

    public NetInterface(IModuleFeedbackChannel feedback, IStringLocalizer localizer, Writer writer, InputStream subNetworksStream) {
        this.feedback = feedback;
        this.localizer = localizer;
        this.nidFactory = new NetworkInterfaceDescriptorFactory(module, this.feedback, this.localizer, subNetworksStream);
        this.writer = writer;
    }

    public void showAllNetworkInterfaces(int ipFamilyOrder, String subNetworksFile) throws IOException {
        this.writeHeader();
        NetworkInterfaceDescriptor[] netInterfaces = this.nidFactory.getAllNetworkInterfaces(ipFamilyOrder);
        int i = 0;
        while (i < netInterfaces.length) {
            this.showNetworkInterface(netInterfaces[i]);
            ++i;
        }
        this.writeFooter(ipFamilyOrder, subNetworksFile);
    }

    private void showNetworkInterface(NetworkInterfaceDescriptor nid) throws IOException {
        this.writeColumnValues(new String[]{nid.getShortName(), nid.getDisplayName(), nid.getIpAddressFamily(), this.formatIPAddress(nid.isDefaultIPAddress(), nid.getIpAddressAsString()), nid.getMacAddress(), nid.getHostName(), nid.getDomainName(), this.booleanToString(nid.isLocalAddress()), this.booleanToString(nid.isPrivateAddress()), this.booleanToString(nid.isIPv6Tunnel()), this.booleanToString(nid.isLinkLocalAddress()), this.booleanToString(nid.isSiteLocalAddress()), this.booleanToString(nid.isLoopbackAddress()), Integer.toString(nid.getWeight())});
    }

    private String formatIPAddress(boolean isDefault, String ipAddress) {
        WilyStringBuilder sb = new WilyStringBuilder();
        if (isDefault) {
            sb.append("<b>");
        }
        sb.append(ipAddress);
        if (isDefault) {
            sb.append("</b>");
        }
        return sb.toString();
    }

    private String getHTMLHeader(String title) {
        String platformDescription = this.getPlatformDescription();
        String charEncoding = System.getProperty("file.encoding", "UTF-8");
        WilyStringBuilder sb = new WilyStringBuilder().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">").append("<html lang=\"en\"><head><meta http-equiv=\"content-type\" content=\"text/html; charset=").append(charEncoding).append("\"><title>").append(title).append("</title>").append("</head><body><table border=\"1\"><tr><td colspan=\"14\" align=\"center\">").append(this.localizer.IStringLocalizer_getFormattedLocalizedString("NetInterface.Network_Interfaces_Supported_By", platformDescription)).append(" ").append(this.localizer.IStringLocalizer_getFormattedLocalizedString("NetInterface.Build", this.localizer.IStringLocalizer_getLocalizedString("Release_String_Key"), this.localizer.IStringLocalizer_getLocalizedString("Build_Number_String_Key"))).append("</td></tr>");
        return sb.toString();
    }

    private String getHTMLFooter() {
        return "</body></html>";
    }

    private void writeHeader() throws IOException {
        this.writer.write(this.getHTMLHeader(this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Network_Interfaces")));
        this.writeColumnHeaders(new String[]{this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Name"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Display_Name"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.IP_Family"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.IP_Address"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.MAC_Address"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Host_Name"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Domain"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Local"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Private"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Tunnel"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Link_Local"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Site_Local"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Loopback"), this.localizer.IStringLocalizer_getLocalizedString("NetInterface.Weight")});
    }

    private void writeFooter(int ipFamilyOrder, String subNetworksFile) throws IOException {
        this.writer.write("</table>");
        this.writer.write("<p>" + this.localizer.IStringLocalizer_getFormattedLocalizedString("NetInterface.IPFamilyOrder", ipFamilyOrder > 0 ? this.localizer.IStringLocalizer_getLocalizedString("NetInterface.IPFamilyOrder.IPv4First") : (ipFamilyOrder < 0 ? this.localizer.IStringLocalizer_getLocalizedString("NetInterface.IPFamilyOrder.IPv6First") : this.localizer.IStringLocalizer_getLocalizedString("NetInterface.IPFamilyOrder.None"))) + "</p>");
        this.writer.write("<p>" + this.localizer.IStringLocalizer_getFormattedLocalizedString("NetInterface.SubNetworksFile", subNetworksFile == null ? this.localizer.IStringLocalizer_getLocalizedString("NetInterface.SubNetworksFile.Default") : subNetworksFile) + "</p>");
        this.writer.write(this.getHTMLFooter());
    }

    private void writeColumnHeaders(String[] headers) throws IOException {
        this.writer.write("<tr>");
        int i = 0;
        while (i < headers.length) {
            this.writer.write("<th>" + headers[i] + "</th>");
            ++i;
        }
        this.writer.write("</tr>");
    }

    private void writeColumnValues(String[] values) throws IOException {
        this.writer.write("<tr>");
        int i = 0;
        while (i < values.length) {
            String value = values[i] == null ? "" : values[i];
            this.writer.write("<td>" + value + "</td>");
            ++i;
        }
        this.writer.write("</tr>");
    }

    private String getPlatformDescription() {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            hostname = this.localizer.IStringLocalizer_getLocalizedString("NetInterface.UnknownHost");
        }
        return this.localizer.IStringLocalizer_getFormattedLocalizedString("NetInterface.Java_Environment", System.getProperty("java.runtime.name"), System.getProperty("java.version"), System.getProperty("java.runtime.version"), System.getProperty("java.vendor"), hostname);
    }

    private String booleanToString(boolean b) {
        return this.localizer.IStringLocalizer_getLocalizedString(b ? "NetInterface.True" : "NetInterface.False");
    }

    private static IStringLocalizer makeStringLocalizer(IModuleFeedbackChannel feedback) {
        String[] resourceBundleList = new String[]{"com.wily.introscope.agent.netinterfacetool.properties.NetInterfaceStrings", "com.wily.introscope.agent.netinterfacetool.properties.NetInterfaceReleaseStrings", "com.wily.introscope.agent.properties.AgentStrings"};
        MultipleResourceBundleStringLocalizer localizer = new MultipleResourceBundleStringLocalizer(feedback, NetInterface.class.getClassLoader(), resourceBundleList);
        return localizer;
    }

    public static void main(String[] args) {
        SystemOutFeedbackChannel feedback = new SystemOutFeedbackChannel(NetInterface.class.getName());
        IStringLocalizer localizer = NetInterface.makeStringLocalizer(feedback);
        int ipFamilyOrder = 1;
        if (args.length > 0) {
            ipFamilyOrder = Integer.parseInt(args[0]);
        }
        String subNetworksFile = null;
        try {
            InputStream subNetworksStream = null;
            if (args.length > 1) {
                subNetworksFile = args[1];
                subNetworksStream = new FileInputStream(subNetworksFile);
            } else {
                subNetworksStream = SubNetworks.class.getResourceAsStream("SubNetworks.txt");
                if (subNetworksStream == null) {
                    throw new Exception(localizer.IStringLocalizer_getLocalizedString("NetInterface.NoDefaultSubNetworksTxt"));
                }
            }
            File htmlFile = File.createTempFile("NetInterfaces", ".html");
            FileWriter writer = new FileWriter(htmlFile);
            NetInterface ipt = new NetInterface(feedback, localizer, writer, subNetworksStream);
            ipt.showAllNetworkInterfaces(ipFamilyOrder, subNetworksFile);
            ((Writer)writer).close();
            String htmlFileURL = "file:///" + htmlFile.getAbsolutePath().replace(File.pathSeparatorChar, '/');
            if (BrowserLauncher.openURL(htmlFileURL)) {
                System.exit(0);
            }
            FileInputStream fis = new FileInputStream(htmlFile);
            StreamCopier.copy(fis, System.out);
        }
        catch (FileNotFoundException fileNotFoundException) {
            feedback.error(module, localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SubNetworks_File_Not_Found", subNetworksFile));
        }
        catch (NumberFormatException e) {
            feedback.error(e);
        }
        catch (Exception e) {
            feedback.error(e);
        }
        System.exit(1);
    }
}

