/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.sap;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;

public class IViewNameFormatter
implements INameFormatter {
    private final IModuleFeedbackChannel fLogOutput;
    private static final String kUnknownIViewName = "<UnknownIView>";
    private static final String kUnknownRoleName = "<UnknownRole>";
    private static final String kDefaultIViewAndRole = "<UnknownIView>/<UnknownRole>";
    private static final String kIViewPlaceHolder = "{iviewname}";
    private static final String kRolePlaceHolder = "{rolename}";
    private Method fGetComponentContext = null;
    private Method fGetContextName = null;

    public IViewNameFormatter(IAgent agent) {
        this.fLogOutput = agent.IAgent_getModuleFeedback();
    }

    @Override
    public String INameFormatter_format(String name, InvocationData data) {
        String iViewName = kUnknownIViewName;
        String roleName = kUnknownRoleName;
        if (data.hasInvocationParametersAvailable() && data.getInvocationParameterCount() > 1) {
            Object p = data.getInvocationParameterAsObject(0);
            String iViewAndRole = kDefaultIViewAndRole;
            try {
                if (this.fGetComponentContext != null && this.fGetContextName != null) {
                    iViewAndRole = (String)this.fGetContextName.invoke(this.fGetComponentContext.invoke(p, null), null);
                } else {
                    this.fGetComponentContext = p.getClass().getMethod("getComponentContext", null);
                    p = this.fGetComponentContext.invoke(p, null);
                    this.fGetContextName = p.getClass().getMethod("getContextName", null);
                    iViewAndRole = (String)this.fGetContextName.invoke(p, null);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                this.fLogOutput.verbose("[ IViewNameFormatter ] Could not get IView name for \"" + name + "\" because of: " + t.toString() + " - " + t.getMessage());
            }
            iViewAndRole = StringUtils.replaceCharAndTrim(iViewAndRole, ':', '-');
            int lastSlash = iViewAndRole.lastIndexOf(47);
            if (-1 != lastSlash) {
                roleName = iViewAndRole.substring(0, lastSlash);
                iViewName = iViewAndRole.substring(lastSlash + 1);
            } else {
                iViewName = iViewAndRole;
            }
        } else {
            this.fLogOutput.verbose("[ IViewNameFormatter ] Parameters not available. Use Trace...WithParameters:");
        }
        String newName = StringUtils.replace(name, kIViewPlaceHolder, iViewName);
        newName = StringUtils.replace(newName, kRolePlaceHolder, roleName);
        return newName;
    }
}

