/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.ConsoleLogger;
import com.wily.introscope.agent.launch.core.FileLocker;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileLock;
import java.util.logging.Level;

public class BootstrapAgentLogger
implements Logger {
    private String primaryFileName;
    private String secondaryFileName;
    private String currentFileNameToWrite;
    private static FileLocker fileLocker;
    private static Logger logger;
    private static final Logger CONSOLE_LOGGER;
    private static final long kMaxLogFileSizeInMB = 1L;

    static {
        logger = null;
        CONSOLE_LOGGER = new ConsoleLogger();
    }

    private BootstrapAgentLogger(String bootstrapAgentHome) throws FileNotFoundException {
        if (bootstrapAgentHome == null) {
            throw new NullPointerException("bootstrapAgentHome is NULL");
        }
        String logsDir = String.valueOf(bootstrapAgentHome) + File.separator + "logs";
        try {
            this.primaryFileName = String.valueOf(logsDir) + File.separator + "BootstrapAgent.log";
            this.createNewFile(this.primaryFileName);
            this.currentFileNameToWrite = this.primaryFileName;
            this.secondaryFileName = String.valueOf(logsDir) + File.separator + "BootstrapAgent.1.log";
            this.createNewFile(this.secondaryFileName);
            fileLocker = new FileLocker(String.valueOf(logsDir) + File.separator + ".lock");
        }
        catch (Exception exception) {
            CONSOLE_LOGGER.severe("Failed to obtain outputStream for the BootstrapAgent.log");
        }
    }

    public static Logger getLogger() {
        if (logger == null) {
            try {
                logger = new BootstrapAgentLogger(BootstrapAgentUtil.getBootstrapAgentInstallDir());
            }
            catch (ThreadDeath e) {
                e.printStackTrace(System.err);
                logger = CONSOLE_LOGGER;
            }
            catch (Throwable th) {
                th.printStackTrace();
                logger = CONSOLE_LOGGER;
            }
        }
        return logger;
    }

    private void logUsingLock(String msg) {
        String content = BootstrapAgentUtil.prepareLoggingMsg(msg);
        FileLock lock = fileLocker.tryUntilAcquiredOrMaxRetries(100L, 5);
        PrintWriter currentWriter = null;
        if (lock != null) {
            try {
                try {
                    currentWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFileNameToWrite, true), "UTF-8"));
                    currentWriter.write(content);
                    currentWriter.flush();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (currentWriter != null) {
                        currentWriter.close();
                    }
                    fileLocker.releaseLock(lock);
                }
            }
            finally {
                if (currentWriter != null) {
                    currentWriter.close();
                }
                fileLocker.releaseLock(lock);
            }
        }
    }

    private void doOnMaxReach() {
        FileLock lock = null;
        try {
            lock = fileLocker.tryUntilAcquiredOrMaxRetries(100L, 5);
            if (lock == null) {
                CONSOLE_LOGGER.severe("Unable to rename log file because of unsuccessful file lock attempt.");
                return;
            }
            File sFile = new File(this.secondaryFileName);
            if (sFile.exists() && !sFile.delete()) {
                CONSOLE_LOGGER.severe("Failed to delete secondary file " + sFile);
                return;
            }
            boolean renamed = new File(this.primaryFileName).renameTo(sFile);
            if (!renamed) {
                CONSOLE_LOGGER.severe("Unable to rename log file");
                return;
            }
        }
        finally {
            fileLocker.releaseLock(lock);
        }
    }

    public static void clearContent(String filePath) {
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(filePath);
                writer.print("");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.err);
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public void info(String msg) {
        try {
            this.checkMaxAndWrite(msg);
        }
        catch (ThreadDeath th) {
            th.printStackTrace();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    @Override
    public void fine(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void finer(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void severe(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void warning(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void log(Level severe, String msg, Throwable t) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void log(Level severe, String s, ThreadDeath td) {
        this.checkMaxAndWrite(s);
    }

    public void tearDown() {
    }

    private boolean checkMaxAndWrite(String msg) {
        long usedSpace = new File(this.currentFileNameToWrite).length();
        double sizeInMB = usedSpace / 0x100000L;
        if (sizeInMB >= 1.0) {
            this.doOnMaxReach();
        }
        this.logUsingLock(msg);
        return true;
    }

    private File createNewFile(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            file.createNewFile();
        }
        return file;
    }
}

