/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.action.ErrorReportingExtendedActionWrapper;
import com.wily.ui.action.ExtendedActionMonitor;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.action.UndoableEditExtendedAction;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;

public class TextEditActionBroker
implements KUICommonStringsKeys {
    private IGenericServices fGenericServices;
    private IStringLocalizer fStringLocalizer;
    private ExtendedActionMonitor fExtendedActionMonitor;
    private UndoableEditListener fUndoableEditListener;

    private TextEditActionBroker() {
        Assertion.unimplemented("must specify generic services and an ExtendedActionMonitor");
    }

    public TextEditActionBroker(IGenericServices genericServices) {
        this.initialize(genericServices, genericServices.IGenericServices_getExtendedActionMonitor());
    }

    public TextEditActionBroker(IGenericServices genericServices, ExtendedActionMonitor extendedActionMonitor) {
        this.initialize(genericServices, extendedActionMonitor);
    }

    private void initialize(IGenericServices genericServices, ExtendedActionMonitor extendedActionMonitor) {
        this.fGenericServices = genericServices;
        this.fStringLocalizer = this.fGenericServices.IGenericServices_getStringLocalizer();
        this.fExtendedActionMonitor = extendedActionMonitor;
        this.fUndoableEditListener = new InstanceUndoableEditListener();
    }

    private ExtendedActionMonitor getExtendedActionMonitor() {
        return this.fExtendedActionMonitor;
    }

    public void monitorTextComponent(JTextComponent textComponent) {
        textComponent.getDocument().addUndoableEditListener(this.fUndoableEditListener);
    }

    public void unmonitorTextComponent(JTextComponent textComponent) {
        textComponent.getDocument().removeUndoableEditListener(this.fUndoableEditListener);
    }

    private void processUndoableEdit(UndoableEdit undoableEdit) {
        IExtendedAction nextUndoAction = this.getExtendedActionMonitor().peekNextUndo();
        IExtendedAction wrappedExtendedAction = null;
        if (nextUndoAction instanceof ErrorReportingExtendedActionWrapper) {
            wrappedExtendedAction = ((ErrorReportingExtendedActionWrapper)nextUndoAction).getWrappedExtendedAction();
        }
        if (wrappedExtendedAction == null || wrappedExtendedAction.IExtendedAction_getActionType() != 3 || !((UndoableEditExtendedAction)wrappedExtendedAction).mergeUndoableEdit(undoableEdit)) {
            UndoableEditExtendedAction newAction = new UndoableEditExtendedAction(undoableEdit);
            ErrorReportingExtendedActionWrapper errorReportingExtendedActionWrapper = new ErrorReportingExtendedActionWrapper(this.fGenericServices, null, newAction);
            errorReportingExtendedActionWrapper.setTriggered(true);
            this.getExtendedActionMonitor().addExtendedAction(errorReportingExtendedActionWrapper);
        }
    }

    private class InstanceUndoableEditListener
    implements UndoableEditListener {
        private InstanceUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            TextEditActionBroker.this.processUndoableEdit(undoableEditEvent.getEdit());
        }
    }
}

