/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.dndlist;

import com.wily.ui.swing.dndlist.AbstractListTransferHandler;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class DefaultListTransferHandler
extends AbstractListTransferHandler {
    public DefaultListTransferHandler(JList list, int action) {
        super(list, action, true);
    }

    public boolean canPerformAction(JList target, int dropIndex, int action) {
        Object listItem = null;
        boolean dropAfterLastItem = dropIndex == target.getModel().getSize();
        try {
            if (!dropAfterLastItem) {
                listItem = target.getModel().getElementAt(dropIndex);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return action == 2;
    }

    public boolean executeDrop(JList target, Object[] draggedItems, int dropIndex, int action) {
        try {
            DefaultListModel listModel = (DefaultListModel)target.getModel();
            int index = dropIndex;
            if (this.selectedIndices != null && index >= this.selectedIndices[0] && index <= this.selectedIndices[this.selectedIndices.length - 1]) {
                this.selectedIndices = null;
                return false;
            }
            return DefaultListTransferHandler.doActualDrop(this, listModel, index, draggedItems, target);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean doActualDrop(DefaultListTransferHandler defaultListTransferHandler, DefaultListModel listModel, int index, Object[] draggedItems, JList target) {
        int max = listModel.getSize();
        if (index < 0) {
            index = max;
        } else if (index > max) {
            index = max;
        }
        int numDraggedItems = draggedItems.length;
        if (defaultListTransferHandler != null) {
            defaultListTransferHandler.addIndex = index;
            defaultListTransferHandler.addCount = numDraggedItems;
        }
        int[] newIndices = new int[numDraggedItems];
        for (int i = 0; i < numDraggedItems; ++i) {
            newIndices[i] = index;
            listModel.add(index++, draggedItems[i]);
        }
        if (numDraggedItems > 0) {
            target.setSelectedIndices(newIndices);
            target.setSelectedIndex(newIndices[0]);
            target.scrollRectToVisible(target.getCellBounds(newIndices[0], newIndices[newIndices.length - 1]));
        } else {
            target.clearSelection();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(JList target, int action) {
        try {
            if (action == 2 && this.selectedIndices != null) {
                int i;
                DefaultListModel model = (DefaultListModel)target.getModel();
                if (this.addCount > 0) {
                    for (i = 0; i < this.selectedIndices.length; ++i) {
                        if (this.selectedIndices[i] <= this.addIndex) continue;
                        int n = i;
                        this.selectedIndices[n] = this.selectedIndices[n] + this.addCount;
                    }
                }
                for (i = this.selectedIndices.length - 1; i >= 0; --i) {
                    model.remove(this.selectedIndices[i]);
                    continue;
                }
                if (this.addCount <= 0) {
                    target.clearSelection();
                    target.setSelectedIndex(-1);
                } else {
                    int[] currentlySelectedIndices = target.getSelectedIndices();
                    if (currentlySelectedIndices.length > 0) {
                        target.setSelectedIndex(currentlySelectedIndices[0]);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        finally {
            this.selectedIndices = null;
            this.addCount = 0;
            this.addIndex = -1;
        }
    }
}

