/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGFieldMethodRefConstant
extends DGConstant {
    private int fCPI_class;
    private int fCPI_nameAndType;

    DGFieldMethodRefConstant(int tag, DGConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, tag);
        this.fCPI_class = in.readUnsignedShort();
        this.fCPI_nameAndType = in.readUnsignedShort();
    }

    DGFieldMethodRefConstant(DGConstantPool constantPool, int tag, int index, int cpiClass, int cpiNameAndType) {
        super(constantPool, tag);
        this.fIndex = index;
        this.fCPI_class = cpiClass;
        this.fCPI_nameAndType = cpiNameAndType;
    }

    @Override
    public void validate() throws DGClassLoadingException {
        this.fPool.validateType(this.fCPI_class, 7);
        this.fPool.validateType(this.fCPI_nameAndType, 12);
    }

    public void redefine(String className, String name) throws DGClassModificationException {
        this.fCPI_class = this.fPool.addClassReference(className);
        String type = this.fPool.getType(this.fCPI_nameAndType);
        this.fCPI_nameAndType = this.fPool.addNameAndType(name, type);
    }

    public int getClassCPI() {
        return this.fCPI_class;
    }

    public int getNameAndTypeCPI() {
        return this.fCPI_nameAndType;
    }

    public String getClassName() {
        return this.fPool.getClassName(this.fCPI_class);
    }

    public String getName() {
        return this.fPool.getName(this.fCPI_nameAndType);
    }

    public String getType() {
        return this.fPool.getType(this.fCPI_nameAndType);
    }

    @Override
    public void adjustIndices(int delta, int base) {
        if (this.fCPI_class > base) {
            this.fCPI_class += delta;
        }
        if (this.fCPI_nameAndType > base) {
            this.fCPI_nameAndType += delta;
        }
        super.adjustIndices(delta, base);
    }

    public String toString() {
        String kind = "";
        switch (this.fTag) {
            case 9: {
                kind = "FieldRef";
                break;
            }
            case 10: {
                kind = "MethodRef";
                break;
            }
            case 11: {
                kind = "InterfaceMethodRef";
            }
        }
        return "# " + this.fIndex + ": Kind = " + kind + " (" + this.fTag + ")\n" + "\tclass = " + this.getClassName() + "(" + this.fCPI_class + ")\n" + "\tname = " + this.getName();
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.fTag);
        out.writeShort(this.fCPI_class);
        out.writeShort(this.fCPI_nameAndType);
    }
}

