/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizrecording;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class ResponseWrapper {
    private static final HashMap kDefaultMessages;
    private static final int kDefaultStatusCode = 200;
    private static final String kUnknownMessage = "Unknown";
    private static final String kDefaultContentType;
    private static final String kCharSetPrefix = ";charset=";
    private int fStatusCode;
    private String fMessage;
    private String fContentType;
    private HashMap fHeaders;
    private String fAssembledHeader = null;

    static {
        kDefaultContentType = null;
        kDefaultMessages = new HashMap();
        kDefaultMessages.put(100, "Continue");
        kDefaultMessages.put(101, "Switching Protocols");
        kDefaultMessages.put(200, "OK");
        kDefaultMessages.put(201, "Created");
        kDefaultMessages.put(202, "Accepted");
        kDefaultMessages.put(203, "Non-Authoritative Information");
        kDefaultMessages.put(204, "No Content");
        kDefaultMessages.put(205, "Reset Content");
        kDefaultMessages.put(206, "Partial Content");
        kDefaultMessages.put(300, "Multiple Choices");
        kDefaultMessages.put(301, "Moved Permanently");
        kDefaultMessages.put(302, "Found");
        kDefaultMessages.put(303, "See Other");
        kDefaultMessages.put(304, "Not Modified");
        kDefaultMessages.put(305, "Use Proxy");
        kDefaultMessages.put(307, "Temporary Redirect");
        kDefaultMessages.put(400, "Bad Request");
        kDefaultMessages.put(401, "Unauthorized");
        kDefaultMessages.put(402, "Payment Required");
        kDefaultMessages.put(403, "Forbidden");
        kDefaultMessages.put(404, "Not Found");
        kDefaultMessages.put(405, "Method Not Allowed");
        kDefaultMessages.put(406, "Not Acceptable");
        kDefaultMessages.put(407, "Proxy Authentication Required");
        kDefaultMessages.put(408, "Request Time-out");
        kDefaultMessages.put(409, "Conflict");
        kDefaultMessages.put(410, "Gone");
        kDefaultMessages.put(411, "Length Required");
        kDefaultMessages.put(412, "Precondition Failed");
        kDefaultMessages.put(413, "Request Entity Too Large");
        kDefaultMessages.put(414, "Request-URI Too Large");
        kDefaultMessages.put(415, "Unsupported Media Type");
        kDefaultMessages.put(416, "Requested range not satisfiable");
        kDefaultMessages.put(417, "Expectation Failed");
        kDefaultMessages.put(500, "Internal Server Error");
        kDefaultMessages.put(501, "Not Implemented");
        kDefaultMessages.put(502, "Bad Gateway");
        kDefaultMessages.put(503, "Service Unavailable");
        kDefaultMessages.put(504, "Gateway Time-out");
        kDefaultMessages.put(505, "HTTP Version not supported");
    }

    ResponseWrapper() {
        this.setStatusCode(200, null);
        this.fContentType = kDefaultContentType;
        this.fHeaders = new HashMap();
    }

    void setCharacterEncoding(String charEncoding) {
        if (charEncoding == null || charEncoding.equals("")) {
            return;
        }
        String charSetSuffixForContentType = kCharSetPrefix + charEncoding;
        if (this.fContentType != null) {
            int endOfContType = this.fContentType.indexOf(";");
            this.fContentType = endOfContType == -1 ? String.valueOf(this.fContentType) + charSetSuffixForContentType : String.valueOf(this.fContentType.substring(0, endOfContType)) + charSetSuffixForContentType;
        }
    }

    void setStatusCode(int sc, String msg) {
        this.fStatusCode = sc;
        if (msg == null) {
            this.fMessage = (String)kDefaultMessages.get(sc);
        }
        if (this.fMessage == null) {
            this.fMessage = kUnknownMessage;
        }
    }

    void setContentType(String contentType) {
        this.fContentType = contentType;
    }

    void addHeader(String key, String value) {
        this.fAssembledHeader = null;
        if (this.fHeaders.containsKey(key)) {
            Object old = this.fHeaders.get(key);
            if (old instanceof String) {
                HashSet<Object> newEntry = new HashSet<Object>();
                newEntry.add(old);
                newEntry.add(value);
                this.fHeaders.put(key, newEntry);
            } else {
                ((HashSet)old).add(value);
            }
        } else {
            this.fHeaders.put(key, value);
        }
    }

    void setHeader(String key, String value) {
        this.fAssembledHeader = null;
        this.fHeaders.put(key, value);
    }

    public int getStatusCode() {
        return this.fStatusCode;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public String getHeader() {
        if (this.fAssembledHeader == null) {
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : this.fHeaders.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val instanceof String) {
                    buf.append(key).append(": ").append((String)val).append('\n');
                    continue;
                }
                Iterator values = ((HashSet)val).iterator();
                while (values.hasNext()) {
                    buf.append(key).append(": ").append((String)values.next()).append('\n');
                }
            }
            this.fAssembledHeader = buf.toString();
        }
        return this.fAssembledHeader;
    }
}

