/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.IGenericServices;
import com.wily.ui.action.AOneWayExtendedAction;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.swing.WilyJDialog;
import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public abstract class AGenericModalDialog
extends WilyJDialog {
    private boolean fAcknowledged;
    private boolean fAccepted;

    protected AGenericModalDialog(IGenericServices genericServices, Component parentComponent) {
        super(genericServices, parentComponent, true);
        this.init();
    }

    protected AGenericModalDialog(IGenericServices genericServices, Component parentComponent, String localizedTitle) {
        super(genericServices, parentComponent, localizedTitle, true);
        this.init();
    }

    public AGenericModalDialog(IGenericServices genericServices, Component parentComponent, String title, int positioningFlags) {
        super(genericServices, parentComponent, title, true, positioningFlags);
    }

    private void init() {
        this.fAccepted = false;
        this.fAcknowledged = false;
        this.getRootPane().registerKeyboardAction(this.getCancelAction(), "", KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void doRespondToCloseRequest() {
        this.cancel();
    }

    protected void accept() {
        this.fAcknowledged = true;
        this.fAccepted = true;
        this.programmaticallyForceClose();
    }

    protected void reject() {
        this.fAcknowledged = true;
        this.programmaticallyForceClose();
    }

    protected void cancel() {
        this.programmaticallyForceClose();
    }

    public boolean accepted() {
        Assertion.wilyAssert(!this.isShowing());
        return this.fAccepted;
    }

    public boolean acknowledged() {
        Assertion.wilyAssert(!this.isShowing());
        return this.fAcknowledged;
    }

    public void packAndShow() {
        this.pack();
        this.show();
    }

    protected IExtendedAction getAcceptAction() {
        return new AcceptAction();
    }

    protected IExtendedAction getRejectAction() {
        return new RejectAction();
    }

    protected IExtendedAction getCancelAction() {
        return new CancelAction();
    }

    private class CancelAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = -1930174931880896156L;

        public void doTriggerAction(ActionEvent actionEvent) {
            AGenericModalDialog.this.cancel();
        }
    }

    private class RejectAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = -1828258588398227102L;

        public void doTriggerAction(ActionEvent actionEvent) {
            AGenericModalDialog.this.reject();
        }
    }

    private class AcceptAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = -727970782698294346L;

        public void doTriggerAction(ActionEvent actionEvent) {
            AGenericModalDialog.this.accept();
        }
    }
}

