/*
 * Decompiled with CFR 0.152.
 */
package com.wily.debug.leakhunter;

import com.wily.debug.leakhunter.ILeakHunter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class LeakHunterFactory {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;

    public static ILeakHunter newLeakHunterInstance(IModuleFeedbackChannel feedback, File logFile) {
        ILeakHunter result = null;
        try {
            result = new ToolWrapper(logFile);
            feedback.info("Successfully loaded the leak hunter");
        }
        catch (Throwable t) {
            feedback.error("Could not load the leak hunter: " + t.getMessage());
            feedback.verbose("Could not load leak hunter.", t);
            result = new DevNullLeakHunter();
        }
        return result;
    }

    public static ILeakHunter newLeakHunterInstanceFromProperties(IModuleFeedbackChannel feedback, IndexedProperties properties, String keyPrefix) {
        ILeakHunter result;
        boolean enabled = properties.getBooleanProperty(keyPrefix + ".leakhunter.enable");
        if (!enabled) {
            result = new DevNullLeakHunter();
        } else {
            String logPath = properties.getProperty(keyPrefix + ".leakhunter.logPath", "memusage.txt");
            result = LeakHunterFactory.newLeakHunterInstance(feedback, new File(logPath));
            int interval = properties.getIntProperty(keyPrefix + ".leakhunter.intervalInMillis", 15000);
            result.ILeakHunter_setIntervalInMillis(interval);
            result.ILeakHunter_start();
        }
        return result;
    }

    private static class DevNullLeakHunter
    implements ILeakHunter {
        private DevNullLeakHunter() {
        }

        public void ILeakHunter_setIntervalInMillis(long interval) {
        }

        public void ILeakHunter_start() {
        }

        public void ILeakHunter_logMarker(String message) {
        }
    }

    private static class ToolWrapper
    implements ILeakHunter {
        private static final String sToolClassName = "com.wily.tools.leakhunter.LeakHunter";
        private final Class fToolClass = Class.forName("com.wily.tools.leakhunter.LeakHunter");
        private final Object fToolInstance;
        private static final String sSetIntervalName = "setIntervalInMillis";
        private static final Class[] sSetIntervalSignature = new Class[]{Long.TYPE};
        private final Method fSetIntervalMethod;
        private static final String sStartName = "startLeakHunter";
        private static final Class[] sStartSignature = new Class[0];
        private final Method fStartMethod;
        private static final String sLogMarkerName = "logMarker";
        private static final Class[] sLogMarkerSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LeakHunterFactory.class$("java.lang.String")) : class$java$lang$String};
        private final Method fLogMarkerMethod;

        public ToolWrapper(File logFile) throws Throwable {
            Constructor constructorToUse = this.fToolClass.getDeclaredConstructor(class$java$io$File == null ? (class$java$io$File = LeakHunterFactory.class$("java.io.File")) : class$java$io$File);
            this.fToolInstance = constructorToUse.newInstance(logFile);
            this.fSetIntervalMethod = this.fToolClass.getMethod(sSetIntervalName, sSetIntervalSignature);
            this.fStartMethod = this.fToolClass.getMethod(sStartName, sStartSignature);
            this.fLogMarkerMethod = this.fToolClass.getMethod(sLogMarkerName, sLogMarkerSignature);
        }

        public void ILeakHunter_setIntervalInMillis(long interval) {
            try {
                this.fSetIntervalMethod.invoke(this.fToolInstance, new Long(interval));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void ILeakHunter_start() {
            try {
                this.fStartMethod.invoke(this.fToolInstance, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void ILeakHunter_logMarker(String message) {
            try {
                this.fLogMarkerMethod.invoke(this.fToolInstance, message);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

