/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.ui.SmartAxis;
import com.wily.util.Scale;
import com.wily.util.SpaceAllotter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class AxisLabel {
    public static final Color kDefaultTickMarkColor = Color.black;
    private static final int kPadding = 10;
    private Scale fScale;
    private Vector fInterestPoints;
    private SmartAxis fSmartAxis;
    private int fLeftOffset;
    private int fRightOffset;
    private int fTopOffset;
    private Color fDefaultTickMarkColor = kDefaultTickMarkColor;
    private Font fFont;
    private boolean fDrawLines;

    public AxisLabel(Scale scale, int leftOffset, int rightOffset, int topOffset) {
        this.fScale = scale;
        this.fInterestPoints = new Vector();
        this.fSmartAxis = new SmartAxis(scale);
        this.fLeftOffset = leftOffset;
        this.fRightOffset = rightOffset;
        this.fTopOffset = topOffset;
        this.fDrawLines = false;
    }

    public AxisLabel(Scale scale, int leftOffset, int rightOffset, int topOffset, boolean drawLines) {
        this(scale, leftOffset, rightOffset, topOffset);
        this.fDrawLines = drawLines;
    }

    public void setFont(Font font) {
        this.fFont = font;
    }

    public void setColor(Color color) {
        this.fDefaultTickMarkColor = color;
    }

    public void setScale(Scale scale) {
        this.fScale = scale;
        this.fSmartAxis.setScale(scale);
    }

    public void addInterestPoint(double point) {
        this.fInterestPoints.addElement(new InterestPoint(point));
    }

    public void addInterestPoint(double point, Color c) {
        this.fInterestPoints.addElement(new InterestPoint(point, c));
    }

    public void draw(Graphics g, Dimension size) {
        g.setFont(this.fFont);
        g.setColor(this.fDefaultTickMarkColor);
        size.width -= this.fLeftOffset + this.fRightOffset;
        SpaceAllotter allotter = new SpaceAllotter(10);
        String max = Scale.getNicelyFormattedString(this.fScale.getMax());
        int maxLength = SwingUtilities.computeStringWidth(g.getFontMetrics(), max);
        double[] axisPoints = this.fSmartAxis.getAxisPoints(size.width / (maxLength + 20));
        double[] allPoints = new double[this.fInterestPoints.size() + axisPoints.length];
        Object[] allColors = new Color[allPoints.length];
        Arrays.fill(allColors, this.fDefaultTickMarkColor);
        Enumeration interestPoints = this.fInterestPoints.elements();
        int i = 0;
        while (interestPoints.hasMoreElements()) {
            InterestPoint interestPoint = (InterestPoint)interestPoints.nextElement();
            allPoints[i + 2] = interestPoint.getPoint();
            allColors[i + 2] = interestPoint.getColor();
            ++i;
        }
        allPoints[0] = axisPoints[0];
        if (axisPoints.length > 1) {
            allPoints[1] = axisPoints[axisPoints.length - 1];
            System.arraycopy(axisPoints, 1, allPoints, i + 2, axisPoints.length - 2);
        }
        for (i = 0; i < allPoints.length; ++i) {
            int valueLocation;
            String valueString = Scale.getNicelyFormattedString(allPoints[i]);
            int stringLength = SwingUtilities.computeStringWidth(g.getFontMetrics(), valueString);
            int stringHeight = (int)g.getFontMetrics().getLineMetrics(valueString, g).getAscent();
            int stringLocation = valueLocation = (int)((allPoints[i] - this.fScale.getMin()) / this.fScale.getBreadth() * (double)size.width);
            if ((stringLocation += this.fLeftOffset - stringLength + stringLength / 2) < 2) {
                stringLocation = 2;
            } else if (stringLocation + stringLength + 2 > size.width + this.fLeftOffset + this.fRightOffset) {
                stringLocation = size.width + this.fLeftOffset + this.fRightOffset - stringLength - 2;
            }
            if (!allotter.allotSpace(stringLocation, stringLength)) continue;
            g.drawString(valueString, stringLocation, this.fTopOffset + stringHeight);
            if (!this.fDrawLines) continue;
            g.setColor((Color)allColors[i]);
            g.drawLine(this.fLeftOffset + valueLocation, this.fTopOffset, this.fLeftOffset + valueLocation, 0);
            g.setColor(this.fDefaultTickMarkColor);
        }
        if (this.fDrawLines) {
            g.setColor(this.fDefaultTickMarkColor);
            g.drawLine(this.fLeftOffset, this.fTopOffset, size.width + this.fLeftOffset, this.fTopOffset);
        }
    }

    private static final class InterestPoint {
        public static final Color kDefaultInterestPointColor = Color.black;
        private final double fPoint;
        private final Color fColor;

        public InterestPoint(double d) {
            this.fPoint = d;
            this.fColor = kDefaultInterestPointColor;
        }

        public InterestPoint(double d, Color c) {
            this.fPoint = d;
            this.fColor = c;
        }

        public double getPoint() {
            return this.fPoint;
        }

        public Color getColor() {
            return this.fColor;
        }
    }
}

