/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.WilyMultiLineLabel;
import com.wily.ui.action.ATwoWayExtendedAction;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.action.NullExtendedAction;
import com.wily.ui.swing.ExtendedJLabel;
import com.wily.ui.swing.IDirtyStateListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;

public class StateHelper {
    private final Set fComponentsToMonitor = new HashSet();
    private final Set fContainersToSkip = new HashSet(2);
    private final boolean fIncludeChildren;
    private boolean fIsDirty;
    private Set fDirtyStateListeners;
    private boolean fMonitoring;
    private boolean fTornDown;
    private final Set fMonitoredComponents;
    private int fStateMonitorFlags;
    public static final int kMonitorContentChanges = 1;
    public static final int kMonitorSelectionChanges = 2;
    public static final int kDefaultStateMonitorFlags = 1;
    private ActionListener fMonitorContentActionListener;
    private KeyListener fMonitorContentKeyListener;
    private ListDataListener fMonitorContentListDataListener;
    private DocumentListener fMonitorContentDocumentListener;
    private ListSelectionListener fMonitorSelectionListSelectionListener;
    private MonitorContentTreeModelListener fMonitorContentTreeModelListener;
    private MonitorSelectionTreeSelectionListener fMonitorSelectionTreeSelectionListener;
    private ContainerListener fMonitorContentContainerListener;
    private static IDirtyStateListener[] kZeroLengthDirtyStateListenerArray = new IDirtyStateListener[0];

    public StateHelper(Component c) {
        this(c, 1, true);
    }

    public StateHelper(Component c, int stateMonitorFlags) {
        this(c, stateMonitorFlags, true);
    }

    public StateHelper(Component c, int stateMonitorFlags, boolean includeChidren) {
        this.fIncludeChildren = includeChidren;
        this.fIsDirty = false;
        this.fDirtyStateListeners = Collections.synchronizedSet(new HashSet(2));
        this.fMonitoring = false;
        this.fTornDown = false;
        this.fMonitoredComponents = new HashSet();
        this.fStateMonitorFlags = stateMonitorFlags;
        this.fComponentsToMonitor.add(c);
        this.initializeDirtyStateListeners();
    }

    public synchronized void addComponent(Component componentToMonitor) {
        this.fComponentsToMonitor.add(componentToMonitor);
        if (this.fMonitoring) {
            this.monitorComponent(componentToMonitor);
        }
    }

    public synchronized void skipContainer(Container containerToSkip) {
        this.fContainersToSkip.add(containerToSkip);
    }

    public synchronized void startMonitoring() {
        this.fMonitoring = true;
        Iterator i = this.fComponentsToMonitor.iterator();
        while (i.hasNext()) {
            this.monitorComponent((Component)i.next());
        }
        this.setDirtyState(false);
    }

    public synchronized void stopMonitoring() {
        Iterator i = this.fMonitoredComponents.iterator();
        while (i.hasNext()) {
            this.unregisterComponentListeners((Component)i.next());
        }
        this.fMonitoredComponents.clear();
        this.fMonitoring = false;
    }

    public boolean monitoringContentChanges() {
        return (this.fStateMonitorFlags & 1) != 0;
    }

    public boolean monitoringSelectionChanges() {
        return (this.fStateMonitorFlags & 2) != 0;
    }

    public synchronized void tearDownStateHelper() {
        this.stopMonitoring();
        this.fComponentsToMonitor.clear();
        this.fMonitoredComponents.clear();
        this.fContainersToSkip.clear();
        this.fDirtyStateListeners.clear();
        this.fTornDown = true;
    }

    public synchronized boolean isDirty() {
        return this.fIsDirty;
    }

    public synchronized void resetDirtyState() {
        this.setDirtyState(false);
    }

    protected synchronized void setDirtyState(boolean isDirty) {
        if (!this.fTornDown) {
            this.fIsDirty = isDirty;
            this.notifyAllDirtyStateListeners();
        }
    }

    public void addDirtyStateListener(IDirtyStateListener listener) {
        this.fDirtyStateListeners.add(listener);
    }

    public void removeDirtyStateListener(IDirtyStateListener listener) {
        this.fDirtyStateListeners.remove(listener);
    }

    private void notifyAllDirtyStateListeners() {
        IDirtyStateListener[] listeners = this.fDirtyStateListeners.toArray(kZeroLengthDirtyStateListenerArray);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].IDirtyStateListener_dirtyStateChanged();
        }
    }

    public IExtendedAction getResetDirtyStateAction() {
        return new ResetDirtyStateAction();
    }

    public IExtendedAction getEnforceDirtyAction() {
        return new EnforceDirtyStateAction();
    }

    public IExtendedAction getEnforceNotDirtyAction() {
        return new EnforceNotDirtyStateAction();
    }

    protected synchronized void rememberMonitoredComponent(Component monitoredComponent) {
        this.fMonitoredComponents.add(monitoredComponent);
    }

    protected void initializeDirtyStateListeners() {
        this.fMonitorContentActionListener = new MonitorContentActionListener();
        this.fMonitorContentKeyListener = new MonitorContentKeyListener();
        this.fMonitorContentListDataListener = new MonitorContentListDataListener();
        this.fMonitorContentDocumentListener = new MonitorContentDocumentListener();
        this.fMonitorSelectionListSelectionListener = new MonitorSelectionListSelectionListener();
        this.fMonitorContentTreeModelListener = new MonitorContentTreeModelListener();
        this.fMonitorSelectionTreeSelectionListener = new MonitorSelectionTreeSelectionListener();
        this.fMonitorContentContainerListener = new MonitorContentContainerListener();
    }

    private synchronized void monitorComponent(Component parentComponent) {
        Container containerToMonitor;
        boolean continueRegistering;
        if (!this.fTornDown && (continueRegistering = this.registerComponentListeners(parentComponent)) && this.fIncludeChildren && parentComponent instanceof Container && !this.shouldSkipContainer(containerToMonitor = (Container)parentComponent)) {
            containerToMonitor.addContainerListener(this.fMonitorContentContainerListener);
            Component[] children = containerToMonitor.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.monitorComponent(children[i]);
            }
        }
    }

    private synchronized void unmonitorComponent(Component parentComponent) {
        Container containerToMonitor;
        boolean continueUnregistering;
        if (!this.fTornDown && (continueUnregistering = this.unregisterComponentListeners(parentComponent)) && this.fIncludeChildren && parentComponent instanceof Container && !this.shouldSkipContainer(containerToMonitor = (Container)parentComponent)) {
            containerToMonitor.removeContainerListener(this.fMonitorContentContainerListener);
            Component[] children = containerToMonitor.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.unmonitorComponent(children[i]);
            }
        }
    }

    private synchronized boolean shouldSkipContainer(Container container) {
        boolean skip = false;
        if (this.fContainersToSkip.contains(container)) {
            skip = true;
        } else if (container instanceof ExtendedJLabel) {
            skip = true;
        } else if (container instanceof JToolBar) {
            skip = true;
        } else if (container instanceof JButton) {
            skip = true;
        }
        return skip;
    }

    protected synchronized boolean registerComponentListeners(Component componentToMonitor) {
        boolean continueRegistering = true;
        if (componentToMonitor instanceof JCheckBox) {
            continueRegistering = this.monitorJCheckBox((JCheckBox)componentToMonitor);
        } else if (componentToMonitor instanceof JComboBox) {
            continueRegistering = this.monitorJComboBox((JComboBox)componentToMonitor);
        } else if (componentToMonitor instanceof JList) {
            continueRegistering = this.monitorJList((JList)componentToMonitor);
        } else if (componentToMonitor instanceof JTree) {
            continueRegistering = this.monitorJTree((JTree)componentToMonitor);
        } else if (componentToMonitor instanceof JTextComponent && !(componentToMonitor instanceof WilyMultiLineLabel)) {
            continueRegistering = this.monitorJTextComponent((JTextComponent)componentToMonitor);
        }
        return continueRegistering;
    }

    protected synchronized boolean unregisterComponentListeners(Component monitoredComponent) {
        boolean continueUnregistering = true;
        if (monitoredComponent instanceof JCheckBox) {
            continueUnregistering = this.stopMonitoringJCheckBox((JCheckBox)monitoredComponent);
        } else if (monitoredComponent instanceof JComboBox) {
            continueUnregistering = this.stopMonitoringJComboBox((JComboBox)monitoredComponent);
        } else if (monitoredComponent instanceof JList) {
            continueUnregistering = this.stopMonitoringJList((JList)monitoredComponent);
        } else if (monitoredComponent instanceof JTree) {
            continueUnregistering = this.stopMonitoringJTree((JTree)monitoredComponent);
        } else if (monitoredComponent instanceof JTextComponent) {
            continueUnregistering = this.stopMonitoringJTextComponent((JTextComponent)monitoredComponent);
        }
        return continueUnregistering;
    }

    private boolean monitorJCheckBox(JCheckBox jCheckBoxToMonitor) {
        if (this.monitoringContentChanges()) {
            jCheckBoxToMonitor.addActionListener(this.fMonitorContentActionListener);
        }
        this.rememberMonitoredComponent(jCheckBoxToMonitor);
        return false;
    }

    private boolean monitorJComboBox(JComboBox jComboBoxToMonitor) {
        if (this.monitoringContentChanges()) {
            jComboBoxToMonitor.addActionListener(this.fMonitorContentActionListener);
            if (jComboBoxToMonitor.isEditable()) {
                jComboBoxToMonitor.getEditor().getEditorComponent().addKeyListener(this.fMonitorContentKeyListener);
            }
        }
        this.rememberMonitoredComponent(jComboBoxToMonitor);
        return false;
    }

    private boolean monitorJList(JList jListToMonitor) {
        if (this.monitoringContentChanges()) {
            jListToMonitor.getModel().addListDataListener(this.fMonitorContentListDataListener);
        }
        if (this.monitoringSelectionChanges()) {
            jListToMonitor.addListSelectionListener(this.fMonitorSelectionListSelectionListener);
        }
        this.rememberMonitoredComponent(jListToMonitor);
        return false;
    }

    private boolean monitorJTree(JTree jTreeToMonitor) {
        if (this.monitoringContentChanges()) {
            jTreeToMonitor.getModel().addTreeModelListener(this.fMonitorContentTreeModelListener);
        }
        if (this.monitoringSelectionChanges()) {
            jTreeToMonitor.addTreeSelectionListener(this.fMonitorSelectionTreeSelectionListener);
        }
        this.rememberMonitoredComponent(jTreeToMonitor);
        return false;
    }

    private boolean monitorJTextComponent(JTextComponent jTextComponentToMonitor) {
        if (this.monitoringContentChanges()) {
            jTextComponentToMonitor.getDocument().addDocumentListener(this.fMonitorContentDocumentListener);
        }
        this.rememberMonitoredComponent(jTextComponentToMonitor);
        return false;
    }

    private boolean stopMonitoringJCheckBox(JCheckBox jCheckBoxToMonitor) {
        if (this.monitoringContentChanges()) {
            jCheckBoxToMonitor.removeActionListener(this.fMonitorContentActionListener);
        }
        return false;
    }

    private boolean stopMonitoringJComboBox(JComboBox jComboBoxToMonitor) {
        if (this.monitoringContentChanges()) {
            jComboBoxToMonitor.removeActionListener(this.fMonitorContentActionListener);
            if (jComboBoxToMonitor.isEditable()) {
                jComboBoxToMonitor.getEditor().getEditorComponent().removeKeyListener(this.fMonitorContentKeyListener);
            }
        }
        return false;
    }

    private boolean stopMonitoringJList(JList jListToMonitor) {
        if (this.monitoringContentChanges()) {
            jListToMonitor.getModel().removeListDataListener(this.fMonitorContentListDataListener);
        }
        if (this.monitoringSelectionChanges()) {
            jListToMonitor.removeListSelectionListener(this.fMonitorSelectionListSelectionListener);
        }
        return false;
    }

    private boolean stopMonitoringJTree(JTree monitoredJTree) {
        if (this.monitoringContentChanges()) {
            monitoredJTree.getModel().removeTreeModelListener(this.fMonitorContentTreeModelListener);
        }
        if (this.monitoringSelectionChanges()) {
            monitoredJTree.removeTreeSelectionListener(this.fMonitorSelectionTreeSelectionListener);
        }
        return false;
    }

    private boolean stopMonitoringJTextComponent(JTextComponent jTextComponentToMonitor) {
        if (this.monitoringContentChanges()) {
            jTextComponentToMonitor.getDocument().removeDocumentListener(this.fMonitorContentDocumentListener);
        }
        return false;
    }

    private class ResetDirtyStateAction
    extends ATwoWayExtendedAction {
        private static final long serialVersionUID = 7721636999105269939L;

        public void doTriggerAction(ActionEvent actionEvent) {
            StateHelper.this.resetDirtyState();
        }

        public void doUndoAction() {
            StateHelper.this.resetDirtyState();
        }
    }

    private class EnforceNotDirtyStateAction
    extends NullExtendedAction {
        private static final long serialVersionUID = -2440490309651566871L;

        public EnforceNotDirtyStateAction() {
            this.setEnabled(!StateHelper.this.isDirty());
            StateHelper.this.addDirtyStateListener(new NotDirtyListener());
        }

        private class NotDirtyListener
        implements IDirtyStateListener {
            private NotDirtyListener() {
            }

            public void IDirtyStateListener_dirtyStateChanged() {
                EnforceNotDirtyStateAction.this.setEnabled(!StateHelper.this.isDirty());
            }
        }
    }

    private class EnforceDirtyStateAction
    extends NullExtendedAction {
        private static final long serialVersionUID = 8107366524666901949L;

        public EnforceDirtyStateAction() {
            this.setEnabled(StateHelper.this.isDirty());
            StateHelper.this.addDirtyStateListener(new DirtyListener());
        }

        private class DirtyListener
        implements IDirtyStateListener {
            private DirtyListener() {
            }

            public void IDirtyStateListener_dirtyStateChanged() {
                EnforceDirtyStateAction.this.setEnabled(StateHelper.this.isDirty());
            }
        }
    }

    private class MonitorSelectionListSelectionListener
    implements ListSelectionListener {
        private MonitorSelectionListSelectionListener() {
        }

        public synchronized void valueChanged(ListSelectionEvent e) {
            StateHelper.this.setDirtyState(true);
        }
    }

    private class MonitorContentDocumentListener
    implements DocumentListener {
        private MonitorContentDocumentListener() {
        }

        public synchronized void insertUpdate(DocumentEvent e) {
            StateHelper.this.setDirtyState(true);
        }

        public synchronized void removeUpdate(DocumentEvent e) {
            StateHelper.this.setDirtyState(true);
        }

        public synchronized void changedUpdate(DocumentEvent e) {
            StateHelper.this.setDirtyState(true);
        }
    }

    private class MonitorContentContainerListener
    implements ContainerListener {
        private MonitorContentContainerListener() {
        }

        public synchronized void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            StateHelper.this.monitorComponent(c);
        }

        public synchronized void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            StateHelper.this.unmonitorComponent(c);
        }
    }

    private class MonitorSelectionTreeSelectionListener
    implements TreeSelectionListener {
        private MonitorSelectionTreeSelectionListener() {
        }

        public synchronized void valueChanged(TreeSelectionEvent e) {
            StateHelper.this.setDirtyState(true);
        }
    }

    private class MonitorContentTreeModelListener
    implements TreeModelListener {
        private MonitorContentTreeModelListener() {
        }

        public synchronized void treeNodesChanged(TreeModelEvent e) {
            StateHelper.this.setDirtyState(true);
        }

        public synchronized void treeNodesInserted(TreeModelEvent e) {
            StateHelper.this.setDirtyState(true);
        }

        public synchronized void treeNodesRemoved(TreeModelEvent e) {
            StateHelper.this.setDirtyState(true);
        }

        public synchronized void treeStructureChanged(TreeModelEvent e) {
            StateHelper.this.setDirtyState(true);
        }
    }

    private class MonitorContentListDataListener
    implements ListDataListener {
        private MonitorContentListDataListener() {
        }

        public synchronized void intervalAdded(ListDataEvent e) {
            StateHelper.this.setDirtyState(true);
        }

        public synchronized void intervalRemoved(ListDataEvent e) {
            StateHelper.this.setDirtyState(true);
        }

        public synchronized void contentsChanged(ListDataEvent e) {
            StateHelper.this.setDirtyState(true);
        }
    }

    private class MonitorContentKeyListener
    implements KeyListener {
        private MonitorContentKeyListener() {
        }

        public void keyTyped(KeyEvent arg0) {
            StateHelper.this.setDirtyState(true);
        }

        public void keyPressed(KeyEvent arg0) {
        }

        public void keyReleased(KeyEvent arg0) {
        }
    }

    private class MonitorContentActionListener
    implements ActionListener {
        private MonitorContentActionListener() {
        }

        public synchronized void actionPerformed(ActionEvent e) {
            StateHelper.this.setDirtyState(true);
        }
    }
}

