/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.event.EventPump;
import com.wily.util.event.ITrackableListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IPropertiesHandler;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.PropertyChangeNotifier;
import java.util.Enumeration;

public class NotifyingIndexedProperties
extends IndexedProperties {
    private static final long serialVersionUID = 5863825489016378438L;
    private final PropertyChangeNotifier fNotifier;

    public NotifyingIndexedProperties(IModuleFeedbackChannel feedback, EventPump eventPump) {
        this.fNotifier = new PropertyChangeNotifier(feedback, eventPump, new PropertiesHandler());
    }

    public synchronized Object put(Object key, Object value) {
        Object result = super.put(key, value);
        this.fNotifier.noticePropertyChange(key, result, value);
        return result;
    }

    public synchronized void addBroadcastListenerWithRewind(ITrackableListener listener) {
        this.fNotifier.addBroadcastListenerWithRewind(listener);
    }

    public synchronized void removeBroadcastListener(ITrackableListener listener) {
        this.fNotifier.removeBroadcastListener(listener);
    }

    private class PropertiesHandler
    implements IPropertiesHandler {
        private PropertiesHandler() {
        }

        public boolean IPropertiesHandler_supportsRewind() {
            return true;
        }

        public Enumeration IPropertiesHandler_getKeys() {
            return NotifyingIndexedProperties.this.propertyNames();
        }

        public String IPropertiesHandler_getValue(String key) {
            return NotifyingIndexedProperties.this.getProperty(key);
        }
    }
}

