/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.InjectedFieldCorrelationHelper;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AsyncBackendCorrelationTracer
extends ASingleInstanceTracerFactoryHC {
    private static final String kContextObjextIndexKey = "contextObject";
    private static final int USE_THIS_AS_CONTEXT = -1;
    private static final int USE_RETVAL_AS_CONTEXT = 9999;
    private final InjectedFieldCorrelationHelper correlationHelper;
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncBackendCorrelationTracer");
    private final int contextObjectIndex;
    private final boolean isConstructor;

    public AsyncBackendCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.correlationHelper = new InjectedFieldCorrelationHelper(agent, parameters, probe, null);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.contextObjectIndex = this.calculateIntegerParameter(kContextObjextIndexKey, -1);
        this.isConstructor = probe.getProbeMethodName().equals("<init>");
    }

    private Object findContextObject(InvocationData data) {
        if (this.contextObjectIndex == -1) {
            if (this.isConstructor) {
                return null;
            }
            return data.getInvocationObject();
        }
        if (this.contextObjectIndex == 9999) {
            return null;
        }
        return data.getInvocationParameterAsObject(this.contextObjectIndex);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object contextObject = this.findContextObject(data);
        if (this.feedback.isDebugEnabled(module)) {
            String className = contextObject != null ? contextObject.getClass().getName() : data.getProbeInformation().getProbeIdentification().getRuntimeFullClassName();
            this.feedback.debug(module, "In thread " + Thread.currentThread().getName() + " start trace called for method " + className + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + "() ");
        }
        if (contextObject == null) {
            return;
        }
        this.correlationHelper.updateContextForBackend(data, contextObject);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object contextObject = null;
        if (this.contextObjectIndex == 9999) {
            contextObject = data.getInvocationReturnValueAsObject();
        } else if (this.isConstructor && this.contextObjectIndex == -1) {
            contextObject = data.getInvocationObject();
        }
        if (contextObject != null) {
            this.correlationHelper.updateContextForBackend(data, contextObject);
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    protected void doOnAbortedTransactionEndTrace(int tracerIndex, IStackElement data) {
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }
}

