/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.AbortedStackElement;
import com.wily.introscope.agent.trace.IBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.StartTransactionStackElement;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.cas.IMetricUpdater;
import com.wily.introscope.agent.trace.cas.IPlaceholderElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.AImmutableBlameComponent;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.hc2.WilyEndTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyStartTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.transactiontrace.ComponentIdCallback;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.List;

public abstract class ASingleInstanceTracerFactoryHC
extends ABundledTracerFactory
implements ITracer,
IMetricUpdater,
ITransactionInstanceProvider {
    private static final String kShouldUseProbeInfoKey = "useprobeinfo";
    private static final String kShouldUseComputedBlameKey = "usecomputedblame";
    private static final String kShouldUseSharedMetricsKey = "usesharedmetrics";
    protected static final Module kModule = new Module("ASingleInstanceTracerFactoryHC");
    private volatile ABlameComponent cachedBlameComponent;
    private final boolean fShouldUseProbeInfo = this.calculateBooleanParameter("useprobeinfo", false);
    protected final boolean fShouldUseComputedBlameKey = this.calculateBooleanParameter("usecomputedblame", false);
    protected final boolean fShouldUseSharedMetrics = this.calculateBooleanParameter("usesharedmetrics", WilyTransactionStructure.fShouldUseSharedAccumulatorsForSameMetric);
    private volatile boolean fAlreadyLogged;
    private final WilyTransactionStructure kInstance = WilyTransactionStructure.getInstance();
    private static boolean fIntelligentInstrumentationEnabled;

    static {
        try {
            IAgent agent = AgentShim.getAgent();
            fIntelligentInstrumentationEnabled = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.deep.instrumentation.enabled", true);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public ASingleInstanceTracerFactoryHC(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        return this;
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    protected IBlameComponent getBlameComponent(int tracerIndex, InvocationData data) {
        IBlameComponent component;
        if (this.fShouldUseComputedBlameKey) {
            IBlameComponent result = this.getBlameKey(tracerIndex, data, this.getModuleFeedback(), this.getCustomNameFormatter());
            if (result == null) {
                Object result2 = this.getBlameKey(data);
                if (result2 != null && result2 instanceof IBlameComponent) {
                    component = (IBlameComponent)result2;
                } else {
                    if (!this.fAlreadyLogged) {
                        this.fAlreadyLogged = true;
                        if (this.getAgent().IAgent_getModuleFeedback().isTraceEnabled()) {
                            this.getAgent().IAgent_getModuleFeedback().trace(kModule, "The Tracer" + this.getParameter("name") + " on method " + data.getProbeInformation().getProbeIdentification().getRuntimeFullClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + " is set to use computed key but failed and will use the component name. This could impact the performance of the system.");
                        }
                    }
                    component = ABlameComponent.getInstance(result2);
                }
            } else {
                component = result;
            }
        } else if (this.fShouldUseProbeInfo) {
            if (this.cachedBlameComponent == null) {
                this.cachedBlameComponent = AImmutableBlameComponent.getImmutableInstance(data.getProbeInformation().getProbeIdentification());
            }
            component = this.cachedBlameComponent;
        } else if (this.canUseCaching()) {
            if (this.cachedBlameComponent == null) {
                String componentString = this.getComponentName(data);
                this.cachedBlameComponent = AImmutableBlameComponent.getImmutableInstance(componentString);
                data.setComponentNameAt(componentString, tracerIndex);
            }
            component = this.cachedBlameComponent;
        } else {
            String componentString = this.getComponentName(data);
            component = ABlameComponent.getInstance(componentString);
            data.setComponentNameAt(componentString, tracerIndex);
        }
        if (component == null) {
            component = this.fallback(tracerIndex, data);
        }
        return component;
    }

    protected String getComponentName(InvocationData data) {
        return this.formatParameterizedName(data);
    }

    protected Object getBlameKey(InvocationData data) {
        return this.getComponentName(data);
    }

    protected final IBlameComponent getBlameKey(int tracerIndex, InvocationData data, IModuleFeedbackChannel feedback, INameFormatter input) {
        ICacheableBlameKeyNameFormatter cacheableFormatter = (ICacheableBlameKeyNameFormatter)input;
        if (cacheableFormatter != null) {
            Object objectKey = cacheableFormatter.getObjectKey(feedback, tracerIndex, data);
            if (objectKey == null) {
                return cacheableFormatter.getKey(feedback, this.getFormattedName(), data);
            }
            IBlameComponent result = (IBlameComponent)this.getWilyTransactionStructureInstance().getFromKeyCacheMap(objectKey);
            if (result != null) {
                return result;
            }
            result = cacheableFormatter.getKey(feedback, this.getFormattedName(), data);
            if (result != null) {
                this.getWilyTransactionStructureInstance().putInKeyCacheMap(objectKey, result);
            }
            return result;
        }
        IBlameKeyNameFormatter formatter = (IBlameKeyNameFormatter)input;
        if (formatter != null) {
            return formatter.getKey(feedback, this.getFormattedName(), data);
        }
        return null;
    }

    private ABlameComponent fallback(int tracerIndex, InvocationData data) {
        String component = this.getComponentName(data);
        data.setComponentNameAt(component, tracerIndex);
        ABlameComponent result = ABlameComponent.getInstance(component);
        return result;
    }

    protected final void submitToTransactionStructureOnEndTrace(int tracerIndex, InvocationData data, ITransactionElementProvider provider) {
        boolean isAborted = data.isTransactionAborted();
        int transactionStatus = data.getTransactionStatus(tracerIndex);
        try {
            if (!isAborted) {
                ITransactionElement currentCursor = data.getCursor();
                if (currentCursor != null && transactionStatus == 2) {
                    currentCursor = this.getWilyTransactionStructureInstance().submitNextEndTransaction(WilyTransactionElement.kEndKey, currentCursor, tracerIndex, data, provider, this, this, true);
                } else if (currentCursor == null) {
                    this.doOnAbortedTransactionEndTrace(tracerIndex, data);
                } else {
                    currentCursor = this.getWilyTransactionStructureInstance().submitNextEndTransaction(WilyTransactionElement.kEndKey, currentCursor, tracerIndex, data, provider, this, this, false);
                    data.setCursor(currentCursor);
                }
            } else {
                this.doOnAbortedTransactionEndTrace(tracerIndex, data);
            }
        }
        finally {
            if (data.getParent() != null && data.getParent().getCursor() instanceof IPlaceholderElement) {
                data.getParent().getParent();
            }
            VirtualStack.pop(data);
            if (transactionStatus == 2) {
                if (WilyTransactionStructure.developmentDebug) {
                    this.getAgent().IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Tracer " + this.getNameParameter() + " ended transaction in position " + tracerIndex);
                }
                this.attempDeepStackTearDown();
                VirtualStack.tearDown();
            }
        }
    }

    private void attempDeepStackTearDown() {
        if (fIntelligentInstrumentationEnabled && DeepTraceConfigurations.fDeepTracingEnabled && HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.isTracingOn()) {
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().prepareOnStartHarvestTransaction();
            HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.tearDown();
        }
    }

    protected abstract void doOnAbortedTransactionEndTrace(int var1, IStackElement var2);

    protected final void submitToTransactionStructureOnStartTrace(int tracerIndex, InvocationData data, ITransactionElementProvider provider) {
        IStackElement previousData = VirtualStack.push(data);
        if (WilyTransactionStructure.developmentDebug && previousData != data) {
            this.getAgent().IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Tracer " + this.getNameParameter() + " pushed stack in position " + tracerIndex);
        }
        try {
            if (previousData == StartTransactionStackElement.kInstance) {
                IBlameComponent component = this.getBlameComponent(tracerIndex, data);
                this.getWilyTransactionStructureInstance().submitStartTransaction(component, tracerIndex, data, provider, this, this);
                if (WilyTransactionStructure.developmentDebug) {
                    this.getAgent().IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Tracer " + this.getNameParameter() + " started transaction in position " + tracerIndex);
                }
            } else if (previousData == null) {
                if (WilyTransactionStructure.developmentDebug) {
                    this.getAgent().IAgent_getModuleFeedback().error(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Tracer " + this.getNameParameter() + " has got a null cursor from the stack. This happens only in exception situations!");
                }
            } else if (previousData != AbortedStackElement.kInstance) {
                ITransactionElement currentCursor = previousData.getCursor();
                if (currentCursor == null) {
                    if (WilyTransactionStructure.developmentDebug) {
                        this.getAgent().IAgent_getModuleFeedback().error(WilyTransactionStructure.kStackModule, String.valueOf(Thread.currentThread().getName()) + ";" + "Tracer " + this.getNameParameter() + " has detected a current curso that is null, and it can't continue the trace");
                    }
                } else {
                    IBlameComponent component = this.getBlameComponent(tracerIndex, data);
                    this.getWilyTransactionStructureInstance().submitNextStartTransaction(component, currentCursor, tracerIndex, data, provider, this, this);
                }
            }
        }
        finally {
            data.setStartedBlame(tracerIndex);
        }
    }

    @Override
    public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        List current = data.getTransactionInstanceList();
        int position = current.size();
        data.setStartInstancePositionAt(position, tracerIndex);
        WilyStartTransactionInstance instance = new WilyStartTransactionInstance(data, newElement);
        current.add(instance);
    }

    @Override
    public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        WilyStartTransactionInstance start;
        List current = data.getTransactionInstanceList();
        int startInstancePosition = data.getStartInstancePositionAt(tracerIndex);
        if (startInstancePosition < current.size() && (start = (WilyStartTransactionInstance)current.get(startInstancePosition)) != null) {
            WilyEndTransactionInstance instance = new WilyEndTransactionInstance(data.getWallClockElapsedTime(), newElement, start);
            current.add(instance);
        }
    }

    @Override
    public void suggestEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        WilyTransactionStructure structure = this.getWilyTransactionStructureInstance();
        if (structure.shouldTraceTransactionInstances(data)) {
            TransactionHarvestHelper.doHarvest(structure, data);
        } else {
            TransactionHarvestHelper.submitTransactionToCache(data);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    protected final WilyTransactionStructure getWilyTransactionStructureInstance() {
        return this.kInstance;
    }

    protected void consumeComponentId(InvocationData data) {
        String componentId;
        SharedCrossProcessData sharedData = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        if (sharedData != null && (componentId = sharedData.getStringParamOut("Caller Component ID")) != null) {
            sharedData.allowedIncreaseComponentId();
            data.put("Component ID", componentId);
            ComponentIdCallback callback = new ComponentIdCallback();
            data.setParameterCallback(callback);
            sharedData.removeParamOut("Caller Component ID");
        }
    }
}

