/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;

public class ExtendedJList
extends JList {
    private static final long serialVersionUID = -6478526905773506185L;
    private int fMaxPreferredWidth = -1;
    private double fMaxPreferredWidthAsScreenPercentage = -1.0;

    public ExtendedJList(ListModel dataModel) {
        super(dataModel);
    }

    public ExtendedJList(Object[] listData) {
        super(listData);
    }

    public ExtendedJList(Vector listData) {
        super(listData);
    }

    public ExtendedJList() {
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return super.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
        Rectangle cellBounds = this.getCellBounds(this.getFirstVisibleIndex(), this.getLastVisibleIndex() - 1);
        if (cellBounds != null) {
            if (direction > 0) {
                return cellBounds.height - (visibleRect.y - cellBounds.y);
            }
            return cellBounds.height + (visibleRect.y - cellBounds.y);
        }
        return 0;
    }

    public void setMaxPreferredWidth(int width) {
        this.fMaxPreferredWidth = width;
    }

    public int getMaxPreferredWidth() {
        return this.fMaxPreferredWidth;
    }

    public void clearMaxPreferredWidth() {
        this.setMaxPreferredWidth(-1);
    }

    public void setMaxPreferredWidthAsScreenPercentage(double percentage) {
        if (percentage > 1.0) {
            throw new IllegalArgumentException();
        }
        this.fMaxPreferredWidthAsScreenPercentage = percentage;
    }

    public double getMaxPreferredWidthAsScreenPercentage() {
        return this.fMaxPreferredWidthAsScreenPercentage;
    }

    public void clearMaxPreferredWidthAsScreenPercentage() {
        this.setMaxPreferredWidthAsScreenPercentage(-1.0);
    }

    private boolean hasMaxPreferredWidthSetting() {
        return this.getMaxPreferredWidth() > 0 || this.getMaxPreferredWidthAsScreenPercentage() > 0.0;
    }

    private int getMaxPreferredWidthToUse() {
        if (this.getMaxPreferredWidth() > 0) {
            return this.getMaxPreferredWidth();
        }
        if (this.getMaxPreferredWidthAsScreenPercentage() > 0.0) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            return (int)((double)screenSize.width * this.getMaxPreferredWidthAsScreenPercentage());
        }
        throw new IllegalStateException();
    }

    public Dimension getPreferredScrollableViewportSize() {
        int preferredWidth;
        Dimension result = super.getPreferredScrollableViewportSize();
        if (this.hasMaxPreferredWidthSetting() && (preferredWidth = this.getMaxPreferredWidthToUse()) < result.width) {
            result = new Dimension(preferredWidth, result.height);
        }
        return result;
    }
}

