/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.DatabaseNameFormatter;
import com.wily.introscope.agent.sqlagent.ResultSetToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.SQLJRTResultSetToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.StatementToConnectionMappingTracer;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.hc2.SQLObjectKeyHelper;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class ResultSetNameFormatter
extends DatabaseNameFormatter {
    public ResultSetNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected Connection getConnection(IModuleFeedbackChannel feedback, Object tracedObject, InvocationData data) {
        Connection result = null;
        if (tracedObject != null) {
            Object stmt = ResultSetToSQLMappingTracer.getStatement(tracedObject);
            if (stmt == null) {
                stmt = SQLJRTResultSetToSQLMappingTracer.getStatement(tracedObject);
            }
            if (stmt != null) {
                Connection conn = StatementToConnectionMappingTracer.getConnection(stmt);
                if (conn instanceof Connection) {
                    result = conn;
                } else if (conn != null) {
                    feedback.debug("[ResultSetNameFormatter] unexpected object type: " + conn.getClass().getName());
                }
            }
        } else {
            feedback.debug("[ResultSetNameFormatter] traced object is null");
        }
        return result;
    }

    @Override
    public String getCommandType(IModuleFeedbackChannel feedback, InvocationData data) {
        String result = null;
        try {
            Object invocationObject = data.getInvocationObject();
            if (invocationObject instanceof ResultSet) {
                Object stmt = ResultSetToSQLMappingTracer.getStatement(invocationObject);
                result = stmt != null ? (stmt instanceof CallableStatement ? "Stored Procedures" : (stmt instanceof PreparedStatement ? "Prepared" : "Dynamic")) : "Unknown";
            }
            if (result == null) {
                result = super.getCommandType(feedback, data);
            }
        }
        catch (Exception e) {
            feedback.debug("An error occurred while attempting to get command type: ", (Throwable)e);
            result = super.getCommandType(feedback, data);
        }
        return result;
    }

    @Override
    public String getNormalizedSQL(IModuleFeedbackChannel feedback, InvocationData data) {
        String normalizedSQL = (String)data.get("com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache");
        if (normalizedSQL == null) {
            normalizedSQL = "null";
            Object invocationObj = data.getInvocationObject();
            if (invocationObj instanceof ResultSet) {
                ResultSet rs = (ResultSet)invocationObj;
                normalizedSQL = ResultSetToSQLMappingTracer.getSQL(rs);
                if (normalizedSQL == null) {
                    normalizedSQL = "null";
                }
            } else {
                feedback.debug("ResultSetNameFormatter: expected a ResultSet");
            }
        }
        data.put("com.wily.introscope.agent.sqlagent.dynamic.query.normalized.sql.cache", (Object)normalizedSQL);
        return normalizedSQL;
    }

    @Override
    public IBlameComponent getKey(IModuleFeedbackChannel feedback, String name, InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof ResultSet) {
            Statement stmt = (Statement)invocationObject;
            if (stmt != null) {
                if (stmt instanceof PreparedStatement) {
                    if (data.getInvocationParameterCount() > 0) {
                        return ABlameComponent.getInstance((Object)data.getInvocationParameterAsObject(0));
                    }
                    return ABlameComponent.getInstance((Object)name, (Object)StatementToSQLMappingTracer.getSQL(stmt, true));
                }
                if (stmt instanceof CallableStatement) {
                    return ABlameComponent.getInstance((Object)name, (Object)StatementToSQLMappingTracer.getSQL(stmt, true));
                }
                if (data.getInvocationParameterCount() > 0) {
                    try {
                        Object URL2 = SQLObjectKeyHelper.getURL(data, feedback, this.getConnection(this.getFeedback(), invocationObject, data), this);
                        return ABlameComponent.getArrayInstance((Object[])new Object[]{name, URL2, data.getInvocationParameterAsObject(0)});
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public Object getObjectKey(IModuleFeedbackChannel feedback, int tracerIndex, InvocationData data) {
        return null;
    }
}

