/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerService;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.IntelligentInstrumentationThreadLocalObject;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.util.HashMap;

public class DownstreamTransactionHarvester {
    private HighPerformanceTransactionCache highPerformanceCache = HighPerformanceTransactionCache.getInstance();
    private boolean shouldAbort = false;

    public void setAbort(boolean flag) {
        this.shouldAbort = flag;
    }

    public void sendTrace(String transactionGUID) {
        HashMap TcdHash = new HashMap();
        this.createAndSendTCD(TcdHash, transactionGUID);
    }

    public static void validateTransactionFromIntelligentInstrumentation(TransactionComponentData root, TransactionComponentData parent) {
        int numChildren;
        if (parent != null) {
            root.fixTimingData(parent);
        }
        if (root.getParameterValue("Total Methods") != null) {
            root.getParameters().remove("Total Methods");
        }
        if ((numChildren = root.getSubNodeCount()) > 0) {
            TransactionComponentData[] children = root.getSubNodes();
            int i = 0;
            while (i < numChildren) {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(children[i], root);
                ++i;
            }
        }
    }

    private void createAndSendTCD(HashMap tcdHash, String transactionGUID) {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] deepStacks = this.highPerformanceCache.getForTransactionTrace(transactionGUID);
        if (deepStacks == null) {
            SustainabilityMetricsHelper.reportNumberOfTracesMissedInCacheMetric(1);
            return;
        }
        boolean success = false;
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] highPerformanceIntelligenceStackElementVirtualStackArray = deepStacks;
        int n = deepStacks.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = highPerformanceIntelligenceStackElementVirtualStackArray[n2];
                if (this.shouldAbort) {
                    return;
                }
                if (!deepStack.hasTraceBeenSent()) {
                    try {
                        try {
                            tcdHash.clear();
                            success = this.createAndSendTCDHelper(tcdHash, transactionGUID, deepStack);
                        }
                        catch (Exception e) {
                            if (CrossProcessLogger.isDebugEnabled()) {
                                CrossProcessLogger.logDebugMessage("Transaction trace from cache had a failure for: " + transactionGUID, e);
                            }
                            this.highPerformanceCache.removeFromGuidCache(deepStack);
                            deepStack.reinit();
                            deepStack.trySetInUse(false);
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        this.highPerformanceCache.removeFromGuidCache(deepStack);
                        deepStack.reinit();
                        deepStack.trySetInUse(false);
                        throw throwable;
                    }
                    this.highPerformanceCache.removeFromGuidCache(deepStack);
                    deepStack.reinit();
                    deepStack.trySetInUse(false);
                }
            }
            ++n2;
        }
        if (success) {
            this.highPerformanceCache.addUpstreamGUID(transactionGUID);
        }
    }

    private boolean createAndSendTCDHelper(HashMap TcdHash, String transactionGUID, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack) {
        TransactionComponentData normalRootTcd;
        IntelligentInstrumentationThreadLocalObject tlObj = deepStack.sIntelligentThreadLocalObject;
        HashMap normalTcdHash = tlObj.fTopTCDElements;
        IIntelligentInstrumentationStackElement topElement = deepStack.getElementAt(1);
        int topElementInvID = topElement.getInvocationId();
        if (topElementInvID != -1 && (normalRootTcd = (TransactionComponentData)normalTcdHash.get(topElementInvID)) != null) {
            int stackElements = deepStack.getStackElementCount();
            int i = 2;
            while (i <= stackElements) {
                IIntelligentInstrumentationStackElement stackElement = deepStack.getElementAt(i);
                IntelligentTransactionHarvesterHelper.createTcd(stackElement);
                ++i;
            }
            deepStack.getElementAt(1).setTransactionComponentData(normalRootTcd);
            TransactionComponentData bizDefComponent = null;
            if (!normalRootTcd.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(normalRootTcd)) != null) {
                HighPerformanceIntelligentStackHelper.realizeSubcomponent(bizDefComponent);
                bizDefComponent.getParameters().put("Trace Type", "Normal");
            }
            IntelligentTransactionHarvesterHelper.joinTCDSubTrees(deepStack);
            if (CrossProcessLogger.isDebugEnabled()) {
                CrossProcessLogger.logDebugMessage("Downstream agent sent the TT for: " + transactionGUID);
            }
            if (bizDefComponent != null) {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(bizDefComponent, null);
                bizDefComponent.getParameters().put("Autotrace Trigger Criteria", "Cross Process Trigger");
                HighPerformanceIntelligenceStackElement.getAgent().IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(bizDefComponent);
            } else {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(normalRootTcd, null);
                normalRootTcd.getParameters().put("Autotrace Trigger Criteria", "Cross Process Trigger");
                HighPerformanceIntelligenceStackElement.getAgent().IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(normalRootTcd);
            }
            SustainabilityMetricsHelper.reportNumberOfTracesFromCacheMetric(1);
            DownStreamListenerService.tracesPerIntervalCount.getAndIncrement();
            deepStack.doOnTraceSendEvent();
            return true;
        }
        return false;
    }

    public boolean hasBeenAborted() {
        return this.shouldAbort;
    }
}

