/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.InformationNotAvailableException;
import com.wily.introscope.agent.platform.IPlatformStatistics;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformLibraryNotSupportedException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.IStringLocalizer;

public abstract class ADefaultPlatformStatistics
implements IPlatformStatistics {
    private final String fName;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    protected final int fValidateCounter;

    protected ADefaultPlatformStatistics(String name, IAgent agent, String libraryName) throws PlatformLibraryException {
        this.fName = name;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        this.fValidateCounter = agent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.platform.validateCheckCount", 24);
        this.confirmSupportedPlatform(agent);
        if (libraryName != null) {
            this.loadLibrary(agent, libraryName);
        }
    }

    protected final IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    protected final IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    private void confirmSupportedPlatform(IAgent agent) throws PlatformLibraryException {
        String platformName = null;
        String platformVersion = null;
        platformName = agent.IAgent_getIndexedProperties().getTrimmedProperty("introscope.agent.platform.monitor.system");
        agent.IAgent_getModuleFeedback().info("APMDEBUG :-: property defined value is - " + platformName);
        if (platformName != null) {
            agent.IAgent_getModuleFeedback().verbose(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Found_User_Platform_Name_Message", this.IPlatformStatistics_getName(), platformName));
            platformVersion = null;
        } else {
            agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_User_Platform_Name_Not_Found_Message", this.IPlatformStatistics_getName()));
            platformName = System.getProperty("os.name");
            platformVersion = System.getProperty("os.version");
        }
        this.checkSupportedPlatform(platformName, platformVersion);
    }

    protected void checkSupportedPlatform(String platformName, String platformVersion) throws PlatformLibraryException {
        if (platformName != null) {
            String[] supportedPlatforms = this.getSupportedPlatforms();
            for (int i = 0; i < supportedPlatforms.length; ++i) {
                if (!supportedPlatforms[i].equals(platformName)) continue;
                return;
            }
        }
        throw new PlatformLibraryNotSupportedException(new FormattedLocalizableMessage("Agent_Platform_Monitor_Unsupported_Platform_Message", this.IPlatformStatistics_getName(), platformName));
    }

    protected final void loadLibrary(IAgent agent, String libraryName) {
        ExtendedFile directory = agent.IAgent_getExtensionAdministrator().getAgentExtensionDirectory();
        ExtendedFile libraryFile = new ExtendedFile(directory, libraryName);
        System.load(libraryFile.getAbsolutePath());
    }

    public final String IPlatformStatistics_getName() {
        return this.fName;
    }

    public final void IPlatformStatistics_terminate() throws PlatformLibraryException {
        this.terminate();
    }

    public long ICpuUsageReporter_getCpuUsage() throws InformationNotAvailableException {
        throw new InformationNotAvailableException();
    }

    public boolean ICpuUsageReporter_isCpuUsageSupported() {
        return false;
    }

    public long IPlatformStatistics_getCumulativeThreadCPUTime() throws PlatformLibraryException, PlatformStatUnavailableException {
        throw new PlatformStatUnavailableException();
    }

    protected abstract String[] getSupportedPlatforms();

    protected abstract void terminate() throws PlatformLibraryException;
}

