/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateInterval
implements Comparable {
    private final Date fStartDate;
    private final Date fEndDate;
    private final SimpleDateFormat fDateFormat;
    private String fInterval;
    private static final String kWeeklyFormat = "EEE MMM d yyyy";
    private static final String kMonthlyFormat = "MMM yyyy";

    public DateInterval(String startDate, String endDate, String format) throws ParseException {
        this.fDateFormat = new SimpleDateFormat(format);
        this.fStartDate = this.fDateFormat.parse(startDate);
        this.fEndDate = this.fDateFormat.parse(endDate);
    }

    public DateInterval(Date startDate, Date endDate) {
        this.fStartDate = startDate;
        this.fEndDate = endDate;
        this.fDateFormat = null;
    }

    public DateInterval(Date startDate, Date endDate, String interval) {
        this(startDate, endDate);
        this.fInterval = interval;
    }

    public Date getStartDate() {
        return this.fStartDate;
    }

    public Date getEndDate() {
        return this.fEndDate;
    }

    public String getFormattedStartDate() {
        if (this.fDateFormat != null) {
            return this.fDateFormat.format(this.fStartDate);
        }
        return this.fStartDate.toString();
    }

    public String getFormattedEndDate() {
        if (this.fDateFormat != null) {
            return this.fDateFormat.format(this.fEndDate);
        }
        return this.fEndDate.toString();
    }

    public String toString() {
        if (this.fInterval != null) {
            return DateInterval.getIntervalFormat(this.fStartDate, this.fInterval);
        }
        return this.fStartDate.toString();
    }

    public int compareTo(Object o) {
        DateInterval interval = (DateInterval)o;
        return this.getStartDate().compareTo(interval.getStartDate());
    }

    public static final String getIntervalFormat(Date date, String interval) {
        if (interval.equalsIgnoreCase("y") || interval.equalsIgnoreCase("m")) {
            return DateInterval.getMonthlyFormat(date);
        }
        if (interval.equalsIgnoreCase("w") || interval.equalsIgnoreCase("d")) {
            return DateInterval.getWeeklyFormat(date);
        }
        return date.toString();
    }

    private static final String getWeeklyFormat(Date date) {
        return new SimpleDateFormat(kWeeklyFormat).format(date);
    }

    private static final String getMonthlyFormat(Date date) {
        return new SimpleDateFormat(kMonthlyFormat).format(date);
    }

    public boolean contains(long timestamp) {
        return timestamp >= this.fStartDate.getTime() && timestamp <= this.fEndDate.getTime();
    }
}

