/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.servlet.BytecodeClassLoader;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ServletHelperFactory {
    private static final IWeakIdentityMap repository = ServletHelperFactory.getCache("ServletHelpers");
    static volatile Class helperClass;
    static volatile ClassLoader helperClassLoader;
    static volatile Class helperClassforServlet3;
    static volatile ClassLoader helperClassLoaderforServlet3;
    static volatile String[] helperClasses;
    static volatile String[] helperClassesForServlet3;
    static volatile IServletRequestHelper helperForSystemLoader;

    private static final IWeakIdentityMap getCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory mapFactory = agent.IAgent_getConcurrentMapFactory();
            return mapFactory.getConcurrentCappedWeakIdentityMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    private static boolean isServlet3(Object request) {
        try {
            Class<?> clazz = request.getClass();
            clazz.getMethod("getServletContext", new Class[0]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static IServletRequestHelper getServletHelper(Object request, ClassLoader loader, IModuleFeedbackChannel feedback) {
        boolean useSystemLoader = loader == null;
        IServletRequestHelper result = null;
        result = useSystemLoader ? helperForSystemLoader : (IServletRequestHelper)repository.getWeak(loader);
        if (result == null) {
            String[] helperClazzes;
            Class helperClazz;
            ClassLoader helperClazzloader;
            Object helper = null;
            boolean isServlet3 = ServletHelperFactory.isServlet3(request);
            if (isServlet3) {
                helperClazzloader = helperClassLoaderforServlet3;
                helperClazz = helperClassforServlet3;
                helperClazzes = helperClassesForServlet3;
            } else {
                helperClazzloader = helperClassLoader;
                helperClazz = helperClass;
                helperClazzes = helperClasses;
            }
            try {
                BytecodeClassLoader newClassLoader = new BytecodeClassLoader(useSystemLoader ? ClassLoader.getSystemClassLoader() : loader, helperClazzloader, helperClazzes, feedback);
                Class<?> cachedClassLoaderClass = Class.forName(helperClazz.getName(), true, newClassLoader);
                helper = cachedClassLoaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                StringWriter stack = new StringWriter();
                t.printStackTrace(new PrintWriter(stack));
                feedback.error(stack.toString());
            }
            if (helper != null) {
                result = helper;
                result.setFeedback(feedback);
            }
            if (useSystemLoader) {
                helperForSystemLoader = result;
            } else {
                IServletRequestHelper existingHelper = (IServletRequestHelper)repository.putWeak(loader, result);
                if (existingHelper != null) {
                    result = existingHelper;
                }
            }
        }
        return result;
    }

    public static void setHelperClass(Class class1) {
        helperClass = class1;
        helperClassLoader = class1.getClassLoader();
    }

    public static void setHelperClassforServlet3(Class class1) {
        helperClassforServlet3 = class1;
        helperClassLoaderforServlet3 = class1.getClassLoader();
    }

    public static void setHelperClasses(String[] class1) {
        helperClasses = class1;
    }

    public static void setHelperClassesForServlet3(String[] classes) {
        helperClassesForServlet3 = classes;
    }
}

