/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.data.IIsengardCachedData;
import com.wily.isengard.data.IIsengardStaticExternalizable;
import com.wily.isengard.data.IIsengardWriteReplace;
import com.wily.isengard.postofficehub.link.ClassNameAndLoaderNamePair;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectInputStream;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectStreamConstants;
import com.wily.isengard.util.io.DefaultSerializationHandler;
import com.wily.isengard.util.io.ISerializationHandler;
import com.wily.isengard.util.io.WireFormatClassNameMapper;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.adt.FastIdentityCache;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.AbstractByteArrayOutputStream;
import com.wily.util.io.IConstructorExternalizable;
import com.wily.util.io.IKeyedClassLoader;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import com.wily.util.io.NonSyncDataOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class IsengardObjectOutputStream
implements ObjectOutput {
    private static Module sModule = new Module("IsengardObjectOutputStream");
    private final ISerializationHandler fSerializationHandler;
    private DataOutputStream fOut;
    private DataOutputStream fTempOutHolder;
    private AbstractByteArrayOutputStream fObjectSizeOut;
    private DataOutputStream fObjectSizeDataOut;
    private IModuleFeedbackChannel fFeedback;
    private final IKeyedClassLoader fKeyedClassLoader;
    private final int fInputStreamVersion;
    private final StreamState fStreamState;
    private volatile int fStartIndex = 0;
    public static CacheFactory factory = new CacheFactory(){

        @Override
        public ObjectCacheMap create() {
            return new DefaultCacheMap();
        }

        @Override
        public IdentityObjectMap createIdentityMap() {
            return new DefaultIdentityObjectMap();
        }
    };

    public IsengardObjectOutputStream(OutputStream out, int inputStreamVersion, IKeyedClassLoader keyedClassLoader, IModuleFeedbackChannel feedback) throws IOException {
        this(out, inputStreamVersion, keyedClassLoader, new DefaultSerializationHandler(), feedback);
    }

    public IsengardObjectOutputStream(OutputStream out, int inputStreamVersion, IKeyedClassLoader keyedClassLoader, IModuleFeedbackChannel feedback, int stringCacheSz) throws IOException {
        this(out, inputStreamVersion, keyedClassLoader, new DefaultSerializationHandler(), feedback, stringCacheSz);
    }

    public IsengardObjectOutputStream(OutputStream out, AbstractByteArrayOutputStream tempOut, int inputStreamVersion, IKeyedClassLoader keyedClassLoader, ISerializationHandler serializationHandler, IModuleFeedbackChannel feedback) throws IOException {
        this(out, tempOut, inputStreamVersion, keyedClassLoader, serializationHandler, feedback, new StreamState(IsengardObjectStreamConstants.kStringCacheSize));
    }

    public IsengardObjectOutputStream(OutputStream out, int inputStreamVersion, IKeyedClassLoader keyedClassLoader, ISerializationHandler serializationHandler, IModuleFeedbackChannel feedback) throws IOException {
        this(out, null, inputStreamVersion, keyedClassLoader, serializationHandler, feedback, new StreamState(IsengardObjectStreamConstants.kStringCacheSize));
    }

    public IsengardObjectOutputStream(OutputStream out, int inputStreamVersion, IKeyedClassLoader keyedClassLoader, ISerializationHandler serializationHandler, IModuleFeedbackChannel feedback, int stringCacheSz) throws IOException {
        this(out, null, inputStreamVersion, keyedClassLoader, serializationHandler, feedback, new StreamState(stringCacheSz));
    }

    public IsengardObjectOutputStream(IsengardObjectOutputStream isengardStream, OutputStream out) throws IOException {
        this(out, null, isengardStream.getInputStreamVersion(), isengardStream.getKeyedClassLoader(), isengardStream.getSerializationHandler(), isengardStream.getModuleFeedback(), isengardStream.getStreamState());
    }

    private IsengardObjectOutputStream(OutputStream out, AbstractByteArrayOutputStream tempOut, int inputStreamVersion, IKeyedClassLoader keyedClassLoader, ISerializationHandler serializationHandler, IModuleFeedbackChannel feedback, StreamState state) throws IOException {
        CheckParameter.notNull("Output Stream", out);
        CheckParameter.notNull("KeyedClassloader", keyedClassLoader);
        CheckParameter.notNull("Serialization Handler", serializationHandler);
        CheckParameter.notNull("Feedback Channel", feedback);
        this.fStreamState = state;
        this.fInputStreamVersion = inputStreamVersion;
        this.fOut = new NonSyncDataOutputStream(out);
        this.fKeyedClassLoader = keyedClassLoader;
        this.fFeedback = feedback;
        if (inputStreamVersion < 1 || inputStreamVersion > 2) {
            throw new IOException("Invalid stream version: " + inputStreamVersion);
        }
        this.fOut.write(inputStreamVersion);
        this.fOut.flush();
        this.fSerializationHandler = serializationHandler;
        this.fObjectSizeOut = tempOut == null ? new NonSyncByteArrayOutputStream(32768) : tempOut;
        this.fObjectSizeDataOut = new NonSyncDataOutputStream(this.fObjectSizeOut);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.fOut.close();
    }

    private StreamState getStreamState() {
        return this.fStreamState;
    }

    protected int getInputStreamVersion() {
        return this.fInputStreamVersion;
    }

    public void reset() throws IOException {
        this.fStreamState.fNeedsReset = true;
        this.fStreamState.fObjectMap = factory.createIdentityMap();
    }

    public void resetCache() {
        this.fStreamState.fNeedsResetCache = true;
        this.fStreamState.fCachedObjects = factory.create();
        this.fStreamState.fCachedStrings.clear();
        this.fStreamState.fStringID = 0;
    }

    public IKeyedClassLoader getKeyedClassLoader() {
        return this.fKeyedClassLoader;
    }

    public boolean isCached(Class clazz) {
        ClassNameAndLoaderNamePair key;
        int id;
        String className = clazz.getName();
        String classLoaderName = this.fKeyedClassLoader.getClassLoaderKey(clazz);
        if (classLoaderName == null) {
            classLoaderName = "";
        }
        return (id = this.fStreamState.fCachedObjects.get(key = new ClassNameAndLoaderNamePair(classLoaderName, className))) == 0 ? false : id != -1;
    }

    public void removeCache(Class clazz) {
        String className = clazz.getName();
        String classLoaderName = this.fKeyedClassLoader.getClassLoaderKey(clazz);
        if (classLoaderName == null) {
            classLoaderName = "";
        }
        ClassNameAndLoaderNamePair key = new ClassNameAndLoaderNamePair(classLoaderName, className);
        this.fStreamState.fCachedObjects.remove(key);
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public ISerializationHandler getSerializationHandler() {
        return this.fSerializationHandler;
    }

    @Override
    public void flush() throws IOException {
        this.fOut.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.fOut.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.fOut.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.fOut.write(b, off, len);
    }

    public void writeObjectNoDataOutput(Object obj) throws IOException {
        this.writeObject2(obj);
    }

    public int getBytesOut() {
        return this.fStartIndex;
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.writeObject2(obj);
        if (this.checkEndObjectGraph()) {
            this.writeToDataOutput();
        }
    }

    private void writeObject2(Object obj) throws IOException {
        if (this.isStartObjectGraph()) {
            this.setUpStartObjectGraph();
        }
        int id = this.fStreamState.fObjectMap.get(obj);
        if (this.fStreamState.fNeedsReset) {
            this.fOut.write(74);
            this.fStreamState.fNeedsReset = false;
        }
        if (this.fStreamState.fNeedsResetCache) {
            this.fOut.write(86);
            this.fStreamState.fNeedsResetCache = false;
        }
        this.fOut.write(72);
        if (obj == null) {
            this.fOut.write(67);
        } else if (obj instanceof Object[]) {
            this.fOut.write(68);
            this.writeClass(obj.getClass());
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Write object array class " + obj.getClass());
            }
            Object[] temp = (Object[])obj;
            this.writeInt(temp.length);
            int i = 0;
            while (i < temp.length) {
                this.writeObject(temp[i]);
                ++i;
            }
        } else if (id != 0) {
            this.fOut.write(64);
            this.writeInt(id);
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Write circular referenced object " + id + ": " + obj.getClass());
            }
        } else if (obj instanceof IIsengardCachedData && (id = this.fStreamState.fCachedObjects.get(obj)) != 0) {
            this.fOut.write(84);
            this.writeInt(id);
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Write cached object " + id + ": " + obj.getClass());
            }
        } else if (obj instanceof IConstructorExternalizable || obj instanceof IIsengardWriteReplace || obj instanceof IIsengardStaticExternalizable || obj instanceof Externalizable) {
            this.writeIsengardData(obj);
        } else {
            this.writeSerializable(obj);
        }
        if (this.isEndObjectGraph()) {
            this.prependGraphSizeToOutput();
        }
    }

    private boolean isStartObjectGraph() {
        return this.fStreamState.fNestedObjectCount++ == 0;
    }

    private void setUpStartObjectGraph() throws IOException {
        this.fTempOutHolder = this.fOut;
        this.fOut = this.fObjectSizeDataOut;
        this.fObjectSizeDataOut.writeInt(-1);
    }

    private boolean isEndObjectGraph() {
        return --this.fStreamState.fNestedObjectCount == 0;
    }

    private boolean checkEndObjectGraph() {
        return this.fStreamState.fNestedObjectCount == 0;
    }

    private void prependGraphSizeToOutput() throws IOException {
        int size = 0;
        this.fOut = this.fTempOutHolder;
        this.fTempOutHolder = null;
        if (IsengardObjectStreamConstants.kDebugStream) {
            this.getFeedbackChannel().warn(sModule, "Write Isengard object size: " + this.fObjectSizeOut.size());
        }
        size = this.fObjectSizeOut.size() - this.fStartIndex;
        this.fObjectSizeOut.rewriteInt(this.fStartIndex, size - 4);
        this.fStartIndex += size;
    }

    public int writeToDataOutput() throws IOException {
        int remaining = 0;
        try {
            remaining = this.fObjectSizeOut.writeTo(this.fOut);
        }
        finally {
            if (remaining == 0) {
                this.fObjectSizeOut.reset();
                this.fStartIndex = 0;
            }
        }
        return remaining;
    }

    private void writeIsengardData(Object obj) throws IOException {
        if (obj instanceof IIsengardWriteReplace) {
            obj = ((IIsengardWriteReplace)obj).writeReplace();
        }
        if (obj instanceof IIsengardCachedData) {
            this.fOut.write(83);
            this.writeInt(++this.fStreamState.fCachedObjectID);
            this.fStreamState.fCachedObjects.put(obj, this.fStreamState.fCachedObjectID);
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Write Isengard cached object " + this.fStreamState.fCachedObjectID + ": " + obj.getClass());
                this.getFeedbackChannel().warn(sModule, "  Object Value: " + obj);
            }
        } else {
            this.fOut.write(65);
            this.writeInt(++this.fStreamState.fObjectID);
            this.fStreamState.fObjectMap.put(obj, this.fStreamState.fObjectID);
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Write Isengard object " + this.fStreamState.fObjectID + ": " + obj.getClass());
                this.getFeedbackChannel().warn(sModule, "  Object Value: " + obj);
            }
        }
        this.writeClass(obj.getClass());
        if (obj instanceof IConstructorExternalizable) {
            ((IConstructorExternalizable)obj).writeExternal(this);
        } else if (obj instanceof IIsengardStaticExternalizable) {
            ((IIsengardStaticExternalizable)obj).writeExternal(this);
        } else if (obj instanceof Externalizable) {
            ((Externalizable)obj).writeExternal(this);
        } else {
            throw new IOException("Isengard can't serialize object of class " + obj.getClass());
        }
    }

    private void writeSerializable(Object obj) throws IOException {
        if (obj instanceof IIsengardCachedData) {
            this.fOut.write(85);
            this.writeInt(++this.fStreamState.fCachedObjectID);
            this.fStreamState.fCachedObjects.put(obj, this.fStreamState.fCachedObjectID);
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Write Serializable cached object " + this.fStreamState.fCachedObjectID + ": " + obj.getClass());
                this.getFeedbackChannel().warn(sModule, "  Object: " + obj);
            }
        } else {
            this.fOut.write(66);
            this.writeInt(++this.fStreamState.fObjectID);
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Write Serializable object " + this.fStreamState.fObjectID + ": " + obj.getClass());
                this.getFeedbackChannel().warn(sModule, "  Object: " + obj);
            }
            this.fStreamState.fObjectMap.put(obj, this.fStreamState.fObjectID);
        }
        this.writeClass(obj.getClass());
        this.writeKnownSerializables(obj);
    }

    private void writeKnownSerializables(Object obj) throws IOException {
        if (obj.getClass() == Integer.class) {
            this.writeInt((Integer)obj);
        } else if (obj.getClass() == Long.class) {
            this.writeLong((Long)obj);
        } else if (obj.getClass() == Double.class) {
            this.writeDouble((Double)obj);
        } else if (obj.getClass() == String.class) {
            this.fOut.writeUTF((String)obj);
        } else if (obj.getClass() == ArrayList.class) {
            this.writeArrayList((ArrayList)obj);
        } else if (obj.getClass() == LinkedList.class) {
            this.writeLinkedList((LinkedList)obj);
        } else if (obj.getClass() == HashMap.class) {
            this.writeHashMap((HashMap)obj);
        } else if (obj.getClass() == HashSet.class) {
            this.writeHashSet((HashSet)obj);
        } else if (Collection.class.isAssignableFrom(obj.getClass())) {
            this.writeCollection((Collection)obj);
        } else if (obj instanceof Class) {
            this.writeClass((Class)obj);
        } else if (obj.getClass() == Boolean.class) {
            this.writeBoolean((Boolean)obj);
        } else if (IsengardObjectInputStream.isArrayOfPrimitivesClass(obj.getClass())) {
            this.writeArrayOfPrimitives(obj);
        } else if (obj instanceof Serializable) {
            this.fSerializationHandler.serialize(this, obj, this.fKeyedClassLoader);
        } else {
            throw new InvalidClassException("The class " + obj.getClass().getName() + " cannot be serialized by Isengard serialization. Classes must be Externalizable, Serializable, or implement one of the Isengard specific serialization interfaces");
        }
    }

    private void writeArrayOfPrimitives(Object o) throws IOException {
        int type = IsengardObjectInputStream.getPrimitiveClassType(o.getClass());
        this.writeByte(type);
        switch (type) {
            case 76: {
                this.writeBooleanArray(o);
                return;
            }
            case 79: {
                this.writeByteArray(o);
                return;
            }
            case 82: {
                this.writeCharArray(o);
                return;
            }
            case 78: {
                this.writeDoubleArray(o);
                return;
            }
            case 80: {
                this.writeFloatArray(o);
                return;
            }
            case 75: {
                this.writeIntegerArray(o);
                return;
            }
            case 77: {
                this.writeLongArray(o);
                return;
            }
            case 81: {
                this.writeShortArray(o);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown primitive array type");
    }

    public void writeByteArray(Object o) throws IOException {
        byte[] bytes = (byte[])o;
        this.writeInt(bytes.length);
        int x = 0;
        while (x < bytes.length) {
            this.writeByte(bytes[x]);
            ++x;
        }
    }

    public void writeCharArray(Object o) throws IOException {
        char[] prims = (char[])o;
        if (this.fInputStreamVersion == 1) {
            this.writeInt(prims.length);
            int x = 0;
            while (x < prims.length) {
                this.writeChar(prims[x]);
                ++x;
            }
        } else {
            byte[] byteArray = new byte[prims.length << 1];
            int byteIndex = 0;
            int i = 0;
            while (i < prims.length) {
                byteArray[byteIndex++] = (byte)(prims[i] >> 8 & 0xFF);
                byteArray[byteIndex++] = (byte)(prims[i] & 0xFF);
                ++i;
            }
            this.writeInt(byteArray.length);
            this.write(byteArray);
        }
    }

    public void writeDoubleArray(Object o) throws IOException {
        double[] prims = (double[])o;
        this.writeInt(prims.length);
        int x = 0;
        while (x < prims.length) {
            this.writeDouble(prims[x]);
            ++x;
        }
    }

    public void writeBooleanArray(Object o) throws IOException {
        boolean[] prims = (boolean[])o;
        this.writeInt(prims.length);
        int x = 0;
        while (x < prims.length) {
            this.writeBoolean(prims[x]);
            ++x;
        }
    }

    public void writeFloatArray(Object o) throws IOException {
        float[] prims = (float[])o;
        this.writeInt(prims.length);
        int x = 0;
        while (x < prims.length) {
            this.writeFloat(prims[x]);
            ++x;
        }
    }

    public void writeIntegerArray(Object o) throws IOException {
        int[] prims = (int[])o;
        this.writeInt(prims.length);
        int x = 0;
        while (x < prims.length) {
            this.writeInt(prims[x]);
            ++x;
        }
    }

    public void writeLongArray(Object o) throws IOException {
        long[] prims = (long[])o;
        this.writeInt(prims.length);
        int x = 0;
        while (x < prims.length) {
            this.writeLong(prims[x]);
            ++x;
        }
    }

    public void writeShortArray(Object o) throws IOException {
        short[] prims = (short[])o;
        this.writeInt(prims.length);
        int x = 0;
        while (x < prims.length) {
            this.writeShort(prims[x]);
            ++x;
        }
    }

    private void writeCollection(Collection list) throws IOException {
        this.writeInt(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.writeObject(iter.next());
        }
    }

    private void writeArrayList(ArrayList list) throws IOException {
        this.writeInt(list.size());
        Iterator entries = list.iterator();
        int i = 0;
        while (i < list.size()) {
            Object obj = entries.next();
            this.writeObject(obj);
            ++i;
        }
    }

    private void writeLinkedList(LinkedList list) throws IOException {
        this.writeInt(list.size());
        Iterator entries = list.iterator();
        int i = 0;
        while (i < list.size()) {
            Object obj = entries.next();
            this.writeObject(obj);
            ++i;
        }
    }

    private void writeHashMap(HashMap map) throws IOException {
        this.writeInt(map.size());
        Iterator entries = map.entrySet().iterator();
        int i = 0;
        while (i < map.size()) {
            Map.Entry entry = entries.next();
            this.writeObject(entry.getKey());
            this.writeObject(entry.getValue());
            ++i;
        }
    }

    private void writeHashSet(HashSet set) throws IOException {
        this.writeInt(set.size());
        Iterator entries = set.iterator();
        int i = 0;
        while (i < set.size()) {
            this.writeObject(entries.next());
            ++i;
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.fOut.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.fOut.writeFloat(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.fOut.writeByte(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.fOut.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.fOut.writeInt(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.fOut.writeShort(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.fOut.writeLong(v);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.fOut.writeBoolean(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.fOut.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.fOut.writeChars(s);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        if (this.fInputStreamVersion == 1) {
            this.fOut.writeUTF(str);
        } else {
            this.writeReferencedString(str);
        }
    }

    private void writeReferencedString(String s) throws IOException {
        Integer id = (Integer)this.fStreamState.fCachedStrings.get(s);
        if (id != null) {
            this.fOut.write(89);
            this.writeInt(id);
        } else {
            this.fOut.write(90);
            this.writeInt(this.fStreamState.fStringID);
            this.fStreamState.fCachedStrings.put(s, new Integer(this.fStreamState.fStringID++));
            if (this.fStreamState.fStringID == this.fStreamState.fCachedStrings.size()) {
                this.fStreamState.fStringID = 0;
            }
            this.fOut.writeUTF(s);
        }
    }

    public void writeClass(Class clazz) throws IOException {
        ClassNameAndLoaderNamePair key;
        int id;
        String className = clazz.getName();
        String classLoaderName = this.fKeyedClassLoader.getClassLoaderKey(clazz);
        if (IsengardObjectStreamConstants.kDebugStream) {
            this.getFeedbackChannel().warn(sModule, "Writing class type " + className + " with classloader named " + classLoaderName);
        }
        if ((id = this.fStreamState.fCachedObjects.get(key = new ClassNameAndLoaderNamePair(classLoaderName, className))) != 0) {
            this.fOut.write(69);
            this.writeInt(id);
        } else {
            this.fOut.write(70);
            this.writeInt(++this.fStreamState.fCachedObjectID);
            this.fStreamState.fCachedObjects.put(key, this.fStreamState.fCachedObjectID);
            this.fOut.writeUTF(classLoaderName);
            this.fOut.writeUTF(WireFormatClassNameMapper.mapInternalToWire(className));
        }
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    public void writeMethod(Method method) throws IOException {
        int id = this.fStreamState.fCachedObjects.get(method);
        if (id != 0) {
            this.fOut.write(88);
            this.writeInt(id);
        } else {
            this.fOut.write(87);
            this.writeInt(++this.fStreamState.fCachedObjectID);
            this.fStreamState.fCachedObjects.put(method, this.fStreamState.fCachedObjectID);
            this.writeClass(method.getDeclaringClass());
            this.fOut.writeUTF(method.getName());
            this.writeObject(method.getParameterTypes());
        }
    }

    public static interface CacheFactory {
        public ObjectCacheMap create();

        public IdentityObjectMap createIdentityMap();
    }

    public static class DefaultCacheMap
    implements ObjectCacheMap {
        Map<Object, Integer> map = new HashMap<Object, Integer>();

        @Override
        public int get(Object key) {
            Integer value = this.map.get(key);
            return value == null ? 0 : value;
        }

        @Override
        public void put(Object key, int value) {
            this.map.put(key, value);
        }

        @Override
        public void remove(Object key) {
            this.map.remove(key);
        }
    }

    public static class DefaultIdentityObjectMap
    implements IdentityObjectMap {
        Map<Object, Integer> map = new IdentityHashMap<Object, Integer>();

        @Override
        public int get(Object key) {
            Integer value = this.map.get(key);
            return value == null ? 0 : value;
        }

        @Override
        public void put(Object key, int value) {
            this.map.put(key, value);
        }

        @Override
        public void remove(Object key) {
            this.map.remove(key);
        }
    }

    public static interface IdentityObjectMap {
        public int get(Object var1);

        public void put(Object var1, int var2);

        public void remove(Object var1);
    }

    public static interface ObjectCacheMap {
        public int get(Object var1);

        public void put(Object var1, int var2);

        public void remove(Object var1);
    }

    private static class StreamState {
        boolean fNeedsResetCache;
        IdentityObjectMap fObjectMap = factory.createIdentityMap();
        int fObjectID = 0;
        FastIdentityCache fCachedStrings;
        int fStringID;
        boolean fNeedsReset;
        ObjectCacheMap fCachedObjects = factory.create();
        int fCachedObjectID = 0;
        int fNestedObjectCount;

        public StreamState(int stringCacheSz) {
            this.fCachedStrings = new FastIdentityCache(stringCacheSz);
            this.fStringID = 0;
            this.fNeedsReset = false;
        }
    }
}

