/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongMonotonicallyIncreasingCounterDataAccumulator;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import com.wily.introscope.spec.metric.AgentMetric;

public class SustainabilityMetricsHelper {
    public static volatile boolean sIsSustainabilityEnabled = false;
    public static volatile boolean sIsExitPointSustainabilityEnabled = false;
    public static final ASharedMetricsHolder kSharedMetricHolder = new ASharedMetricsHolder();
    private static volatile RepositoryFactory sRepositoryFactory = null;
    private static DataAccumulatorFactory sDaf;
    public static final String sSustainabilityBaseMetricName = "Agent Stats|Sustainability|Deep Tracing";
    public static final String sAutoTracingSustainabilityBaseMetricName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing";
    public static final String sEntryPointDetectionSustainabilityBaseMetricName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection";
    public static final String sExitPointDetectionSustainabilityBaseMetricName = "Agent Stats|Sustainability|Automatic Backend Detection";
    public static final String sSqlSustainabilityBaseMetricName = "Agent Stats|Sustainability|SQL";
    public static final String sURLGroupsSustainabilityBaseMetricName = "Agent Stats|Sustainability|URL Groups";
    public static final String kInstrumentedMethodsMetricName = "Agent Stats|Sustainability|Deep Tracing:Instrumented Methods Count";
    public static final String kAnalyzedMethodsMetricName = "Agent Stats|Sustainability|Deep Tracing:Analyzed Methods Count";
    public static final String kProbeInfoMapSizeMetricName = "Agent Stats|Sustainability|Deep Tracing:ProbeInfo Collection Size";
    public static final String kMaxInstrumentableMethodsMetricName = "Agent Stats|Sustainability|Deep Tracing:Max Instrumentable Methods Count";
    public static final String kInstrumentationLevelMetricName = "Agent Stats|Sustainability|Deep Tracing|Instrumentation Level:Current Instrumentation Level";
    public static final String kProcessedClassesMetricName = "Agent Stats|Sustainability|Deep Tracing:Classes Processed Per Interval";
    public static final String kAverageDeepComponentPerTxnMetricName = "Agent Stats|Sustainability|Deep Tracing:Average Deep Component Count Per Transaction";
    public static final String kAverageComponentPerTxnMetricName = "Agent Stats|Sustainability|Deep Tracing:Average Component Count Per Transaction";
    public static final String kAverageComponentArraySizeMetricName = "Agent Stats|Sustainability|Deep Tracing:Average Component Array Size";
    public static final IUpdater kIntAverageUpdater;
    public static volatile IRepository sAverageDeepComponentPerTxnRep;
    public static volatile IRepository sAverageComponentPerTxnRep;
    public static volatile IRepository sAverageComponentArraySizeRep;
    public static volatile IRepository sAveragCachePollCountRep;
    public static volatile IRepository sAveragRuntimeComponentsPerTx;
    public static final String kCachedTransactions = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Cache Size";
    public static final String kClampedAutoTracesName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Clamped Traces";
    public static final String kSentAutoTracesName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Sent Traces";
    public static final String kSentNumberOfTraceFromCacheName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Trace Cache Hits";
    public static final String kNumberOfTraceMissedInCacheName = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Trace Cache Misses";
    public static final String kUpstreamGuidCount = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Upstream GUID Count Per Interval";
    public static final String kDownstreamGuidCount = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Downstream GUID Count Per Interval";
    public static final String kCachedTransactionCount = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Cached Transaction Count Per Interval";
    public static final String kDeepstackCheckoutCount = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Deepstack Checkout Count Per Interval";
    public static final String kDeepstackCachePollCount = "Agent Stats|Sustainability|Deep Tracing|Auto Tracing:Average Cache Poll Count Per Transaction";
    public static final String kInitialCandidatesName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Initial Candidates Current";
    public static final String kInitialCandidatesTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Initial Candidates Total";
    public static final String kTrackedCandidatesName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Tracked Candidates Current";
    public static final String kTrackedCandidatesTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Tracked Candidates Total";
    public static final String kBlacklistedCandidatesTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Candidates Discarded";
    public static final String kEntryPointsDiscoveredTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Entry Points Discovered";
    public static final String kBlacklistedEntryPointsTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Entry Points Discarded";
    public static final String kEvaluatedStacksTotalName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Total Analyzed Stack Snapshots";
    public static final String kStackSnapshotQueueLenName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Stack Snapshot Queue Length";
    public static final String kTrackedStacksName = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Tracked Threads";
    public static final String kExitPointAnalyzedStacksName = "Agent Stats|Sustainability|Automatic Backend Detection:Total Analyzed Stack Snapshots";
    public static final String kExitPointDetectedName = "Agent Stats|Sustainability|Automatic Backend Detection:Total Backends Discovered";
    public static final String kExitPointPersistedName = "Agent Stats|Sustainability|Automatic Backend Detection:Total Backends Persisted";
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sInitialCandidatesTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sTrackedCandidatesTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sBlacklistedCandidatesTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sEntryPointsDiscoveredTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sBlacklistedEntryPointsTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sAnalyzedStacksTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sExitPointAnalyzedStacksTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sExitPointExitPointsDiscoveredTotal;
    private static ILongMonotonicallyIncreasingCounterDataAccumulator sExitPointExitPointsPersistedTotal;
    public static final String kEntryPointsCount = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Total Entry Points";
    public static final String kSkippedMethodsCount = "Agent Stats|Sustainability|Deep Tracing|Entry Point Detection:Total Entry Points Discarded";
    public static final String kSQLStatementCount = "Agent Stats|Sustainability|SQL:SQL Statement Count";
    private static IAgent sAgent;
    public static final String kFrontendURLGroupsMatched = "Agent Stats|Sustainability|URL Groups: Frontend URL Groups Matched";
    public static final String kBackendURLGroupsMatched = "Agent Stats|Sustainability|URL Groups: Backend URL Groups Matched";
    public static final String sRuntimeVisibilityBaseMetricName = "Agent Stats|Sustainability|Runtime Visibility";
    public static final String sRuntimeVisibilityGapsFound = "Agent Stats|Sustainability|Runtime Visibility: Gaps Found Per Interval";
    public static final String sRuntimeVisibilityComponentsInTrace = "Agent Stats|Sustainability|Runtime Visibility: Runtime Components Per Transaction";
    public static final String sRuntimeVisibilityMethodsInstrumented = "Agent Stats|Sustainability|Runtime Visibility: Methods Instrumented Per Interval";
    public static final String sRuntimeVisibilityMethodsUnInstrumented = "Agent Stats|Sustainability|Runtime Visibility: Methods UnInstrumented Per Interval";
    public static final String sRuntimeVisibilityTotalMethodsInstrumented = "Agent Stats|Sustainability|Runtime Visibility: Total Methods Instrumented";

    static {
        kIntAverageUpdater = UpdaterFactory.getCombiningUpdater();
        sAverageDeepComponentPerTxnRep = null;
        sAverageComponentPerTxnRep = null;
        sAverageComponentArraySizeRep = null;
        sAveragCachePollCountRep = null;
        sAveragRuntimeComponentsPerTx = null;
        sAgent = null;
    }

    public static void initializeSustainabilityRepositories() {
        sAverageDeepComponentPerTxnRep = sRepositoryFactory.safeGetLongAverageDataAccumulator(kAverageDeepComponentPerTxnMetricName, kSharedMetricHolder);
        sAverageComponentPerTxnRep = sRepositoryFactory.safeGetLongAverageDataAccumulator(kAverageComponentPerTxnMetricName, kSharedMetricHolder);
        sAverageComponentArraySizeRep = sRepositoryFactory.safeGetLongAverageDataAccumulator(kAverageComponentArraySizeMetricName, kSharedMetricHolder);
        sAveragCachePollCountRep = sRepositoryFactory.safeGetLongAverageDataAccumulator(kDeepstackCachePollCount, kSharedMetricHolder);
        sAveragRuntimeComponentsPerTx = sRepositoryFactory.safeGetLongAverageDataAccumulator(sRuntimeVisibilityComponentsInTrace, kSharedMetricHolder);
    }

    public static void initializeSustainabilityAccumulators() {
        sInitialCandidatesTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kInitialCandidatesTotalName);
        sTrackedCandidatesTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kTrackedCandidatesTotalName);
        sBlacklistedCandidatesTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kBlacklistedCandidatesTotalName);
        sEntryPointsDiscoveredTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kEntryPointsDiscoveredTotalName);
        sBlacklistedEntryPointsTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kBlacklistedEntryPointsTotalName);
        sAnalyzedStacksTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kEvaluatedStacksTotalName);
    }

    private static void initializeExitPointSustainabilityAccumulators() {
        sExitPointAnalyzedStacksTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kExitPointAnalyzedStacksName);
        sExitPointExitPointsDiscoveredTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kExitPointDetectedName);
        sExitPointExitPointsPersistedTotal = sDaf.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(kExitPointPersistedName);
    }

    public static void setSustainabilityEnabled(boolean value) {
        sIsSustainabilityEnabled = value;
        if (sIsSustainabilityEnabled && sRepositoryFactory == null) {
            SustainabilityMetricsHelper.initializeAccumulatorFactory();
            if (sDaf != null) {
                SustainabilityMetricsHelper.initializeSustainabilityAccumulators();
                if (sRepositoryFactory == null) {
                    sRepositoryFactory = new RepositoryFactory(sAgent.IAgent_getDataAccumulatorFactory(), true);
                    SustainabilityMetricsHelper.initializeSustainabilityRepositories();
                }
            }
            if (sRepositoryFactory == null) {
                sIsSustainabilityEnabled = false;
            }
        }
    }

    public static void setExitPointSustainabilityEnabled(boolean value) {
        sIsExitPointSustainabilityEnabled = value;
        if (sIsExitPointSustainabilityEnabled && sExitPointExitPointsPersistedTotal == null) {
            SustainabilityMetricsHelper.initializeAccumulatorFactory();
            if (sDaf == null) {
                sIsExitPointSustainabilityEnabled = false;
            } else {
                SustainabilityMetricsHelper.initializeExitPointSustainabilityAccumulators();
            }
        }
    }

    private static void initializeAccumulatorFactory() {
        if (sAgent == null) {
            try {
                sAgent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException e) {
                Logger.logException(e);
            }
        }
        if (sAgent != null && sDaf == null) {
            sDaf = sAgent.IAgent_getDataAccumulatorFactory();
        }
    }

    public static void reportDeepTraceSustainabilityMetrics(int deepCount, int elementCount, int stackLen) {
        if (sIsSustainabilityEnabled) {
            sAverageDeepComponentPerTxnRep.update(kIntAverageUpdater, (long)deepCount, 0L, 0);
            sAverageComponentPerTxnRep.update(kIntAverageUpdater, (long)elementCount, 0L, 0);
            sAverageComponentArraySizeRep.update(kIntAverageUpdater, (long)stackLen, 0L, 0);
        }
    }

    public static void reportAutoTracingSustainibilityMetricsSent(int tracesMatched) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kSentAutoTracesName).ILongAggregatingDataAccumulator_recordDataPoint(tracesMatched);
        }
    }

    public static void reportAutoTracingSustainabilityMetricsClamped(int tracesClamped) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kClampedAutoTracesName).ILongAggregatingDataAccumulator_recordDataPoint(tracesClamped);
        }
    }

    public static void reportNumberOfTracesFromCacheMetric(int sentNumberDownStreamTraces) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kSentNumberOfTraceFromCacheName).ILongAggregatingDataAccumulator_recordDataPoint(sentNumberDownStreamTraces);
        }
    }

    public static void reportNumberOfTracesMissedInCacheMetric(int numberOfMissedDownStreamTraces) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kNumberOfTraceMissedInCacheName).ILongAggregatingDataAccumulator_recordDataPoint(numberOfMissedDownStreamTraces);
        }
    }

    public static void reportUpstreamGuidCountSustainabilityMetrics(int upstreamGuidCount) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kUpstreamGuidCount).ILongAggregatingDataAccumulator_recordDataPoint(upstreamGuidCount);
        }
    }

    public static void reportDownstreamGuidCountSustainabilityMetrics(int downstreamGuidCount) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kDownstreamGuidCount).ILongAggregatingDataAccumulator_recordDataPoint(downstreamGuidCount);
        }
    }

    public static void reportCachedTransactionCountSustainabilityMetrics(int cachedTransactionCount) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kCachedTransactionCount).ILongAggregatingDataAccumulator_recordDataPoint(cachedTransactionCount);
        }
    }

    public static void reportInitialCandidateSustainabilityMetrics() {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kInitialCandidatesName).ILongCounterDataAccumulator_setValue(FrontEndCandidateAnalyzer.fInitalFrontendMap.size());
        }
    }

    public static void reportTrackedCandidateSustainabilityMetrics() {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kTrackedCandidatesName).ILongCounterDataAccumulator_setValue(FrontEndCandidateAnalyzer.fCandidatePerformanceMap.size());
            if (FrontEndCandidateAnalyzer.fDeepStacks != null) {
                sDaf.safeGetLongFluctuatingCounterDataAccumulator(kTrackedStacksName).ILongCounterDataAccumulator_setValue(FrontEndCandidateAnalyzer.fDeepStacks.getSize());
            }
        }
    }

    public static void reportInitialCandidate() {
        if (sIsSustainabilityEnabled) {
            sInitialCandidatesTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportEntryPointsPersisted(int val) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kEntryPointsCount).ILongCounterDataAccumulator_setValue(val);
        }
    }

    public static void reportSkippedMethodsPersisted(int val) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kSkippedMethodsCount).ILongCounterDataAccumulator_setValue(val);
        }
    }

    public static void reportTrackedCandidate() {
        if (sIsSustainabilityEnabled) {
            sTrackedCandidatesTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportBlacklistedCandidate() {
        if (sIsSustainabilityEnabled) {
            sBlacklistedCandidatesTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportIdentifiedEntryPoint() {
        if (sIsSustainabilityEnabled) {
            sEntryPointsDiscoveredTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportBlacklistedEntryPoint() {
        if (sIsSustainabilityEnabled) {
            sBlacklistedEntryPointsTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_increment();
        }
    }

    public static void reportAnalyzedStacks(int num) {
        if (sIsSustainabilityEnabled) {
            sAnalyzedStacksTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_add(num);
        }
    }

    public static void reportStackQueueLength(int len) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kStackSnapshotQueueLenName).ILongCounterDataAccumulator_setValue(len);
        }
    }

    public static void reportDeepInstrumentationMetrics(int instrumentedMethods, int analyzedMethods, int probeInfoSize, int maxIntrumentableMethods, int instrumentationLevel, long classesProcessed) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kInstrumentedMethodsMetricName).IIntegerCounterDataAccumulator_setValue(instrumentedMethods);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kAnalyzedMethodsMetricName).IIntegerCounterDataAccumulator_setValue(analyzedMethods);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kProbeInfoMapSizeMetricName).IIntegerCounterDataAccumulator_setValue(probeInfoSize);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kMaxInstrumentableMethodsMetricName).IIntegerCounterDataAccumulator_setValue(maxIntrumentableMethods);
            sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kInstrumentationLevelMetricName).IIntegerCounterDataAccumulator_setValue(instrumentationLevel);
            sDaf.safeGetLongIntervalCounterDataAccumulator(kProcessedClassesMetricName).ILongAggregatingDataAccumulator_recordDataPoint(classesProcessed);
        }
    }

    public static void reportExitPointAnalyzedStacks(int num) {
        if (sIsExitPointSustainabilityEnabled) {
            sExitPointAnalyzedStacksTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_add(num);
        }
    }

    public static void reportExitPointDiscovered(int num) {
        if (sIsExitPointSustainabilityEnabled) {
            sExitPointExitPointsDiscoveredTotal.ILongMonotonicallyIncreasingCounterDataAccumulator_add(num);
        }
    }

    public static void reportExitPointPersisted(int num) {
        if (sIsExitPointSustainabilityEnabled) {
            sExitPointExitPointsPersistedTotal.ILongCounterDataAccumulator_setValue(num);
        }
    }

    public static void reportSQLStatementNodesCreated(int val) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kSQLStatementCount).ILongCounterDataAccumulator_setValue(val);
        }
    }

    public static void reportFrontendURLGroupsMatched(int val) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kFrontendURLGroupsMatched).ILongCounterDataAccumulator_setValue(val);
        }
    }

    public static void reportBackendURLGroupsMatched(int val) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongFluctuatingCounterDataAccumulator(kBackendURLGroupsMatched).ILongCounterDataAccumulator_setValue(val);
        }
    }

    public static void reportCheckoutSustainabilityMetrics(int checkoutCount) {
        if (sIsSustainabilityEnabled) {
            sDaf.safeGetLongIntervalCounterDataAccumulator(kDeepstackCheckoutCount).ILongAggregatingDataAccumulator_recordDataPoint(checkoutCount);
        }
    }

    public static void reportCacheQueuePolls(int count) {
        if (sIsSustainabilityEnabled) {
            sAveragCachePollCountRep.update(kIntAverageUpdater, (long)count, 0L, 0);
        }
    }

    public static void reportCacheQueueSize() {
        if (sIsSustainabilityEnabled) {
            try {
                HighPerformanceTransactionCache cache = HighPerformanceTransactionCache.getInstance();
                if (cache != null) {
                    int count = cache.getCurrentCacheSize();
                    sDaf.safeGetIntegerFluctuatingCounterDataAccumulator(kCachedTransactions).IIntegerCounterDataAccumulator_setValue(count);
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void reportRuntimeComponentsInTransaction(int count) {
        if (sIsSustainabilityEnabled) {
            sAveragRuntimeComponentsPerTx.update(kIntAverageUpdater, (long)count, 0L, 0);
        }
    }

    public static void reportVisibilityGapSustainability(long instrumentationCount, long instrumentedMethods, long uninstrumentedMethods, long gapsFoundPerInt) {
        if (sIsSustainabilityEnabled) {
            try {
                sDaf.safeGetLongFluctuatingCounterDataAccumulator(sRuntimeVisibilityTotalMethodsInstrumented).ILongCounterDataAccumulator_setValue(instrumentationCount);
                sDaf.safeGetLongIntervalCounterDataAccumulator(sRuntimeVisibilityMethodsInstrumented).ILongAggregatingDataAccumulator_recordDataPoint(instrumentedMethods);
                sDaf.safeGetLongIntervalCounterDataAccumulator(sRuntimeVisibilityMethodsUnInstrumented).ILongAggregatingDataAccumulator_recordDataPoint(uninstrumentedMethods);
                sDaf.safeGetLongIntervalCounterDataAccumulator(sRuntimeVisibilityGapsFound).ILongAggregatingDataAccumulator_recordDataPoint(gapsFoundPerInt);
            }
            catch (Exception exception) {}
        }
    }

    private static class ASharedMetricsHolder
    implements ISharedMetricHolder {
        AAgentMetricArray metric;
        IRepository rep;

        private ASharedMetricsHolder() {
        }

        @Override
        public void addMetric(AgentMetric addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance(addedMetric);
        }

        @Override
        public void addMetric(AgentMetric[] addedMetric, IRepository structure) {
            this.rep = structure;
            this.metric = AAgentMetricArray.getInstance(addedMetric);
        }
    }
}

