/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge;

import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.MergeCustomMessageFormatter;
import com.wily.introscope.agent.upgrade.merge.MergeException;
import com.wily.introscope.agent.upgrade.merge.pbd.PBD;
import com.wily.introscope.agent.upgrade.merge.pbl.PBL;
import com.wily.introscope.agent.upgrade.merge.profile.Profile;
import com.wily.introscope.agent.upgrade.merge.rules.RulesEngine;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MergeAdministrator {
    private static Logger sLogger = Logger.getLogger(MergeAdministrator.class.getName());

    public static void doMergeMain(String updateDir, String configDir, String mergeRules) throws MergeException {
        MergeCustomMessageFormatter formatter = new MergeCustomMessageFormatter();
        FileHandler fileHandler = null;
        ConsoleHandler consoleHandler = null;
        try {
            fileHandler = new FileHandler("mergeutility.log");
            fileHandler.setFormatter(formatter);
            fileHandler.setLevel(Level.ALL);
            sLogger.addHandler(fileHandler);
            consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(formatter);
            consoleHandler.setLevel(Level.ALL);
            sLogger.addHandler(consoleHandler);
            sLogger.setUseParentHandlers(false);
        }
        catch (Exception exception) {}
        MergeAdministrator.doMerge(updateDir, configDir, mergeRules, true);
    }

    private static IMergeable readConfig(BufferedReader reader, String ext) throws IOException {
        IMergeable<Profile> config = null;
        if ("profile".equalsIgnoreCase(ext)) {
            config = Profile.read(reader);
        } else if ("pbl".equalsIgnoreCase(ext)) {
            config = PBL.read(reader);
        } else if ("pbd".equalsIgnoreCase(ext)) {
            config = PBD.read(reader);
        }
        return config;
    }

    public static void doMerge(String updateDir, String configDir, String mergeRules, boolean fromMergeUtility) throws MergeException {
        String ext;
        RulesEngine engine = new RulesEngine(mergeRules);
        Map<String, String> updateFiles = MergeAdministrator.getConfigFiles(updateDir);
        Map<String, String> customerFiles = MergeAdministrator.getConfigFiles(configDir);
        HashMap<String, String> customerFilesAfterDelete = new HashMap<String, String>();
        customerFilesAfterDelete.putAll(customerFiles);
        for (String customerFile : customerFiles.keySet()) {
            ext = MergeAdministrator.getFileExtension(customerFile);
            if (!("profile".equalsIgnoreCase(ext) && engine.isDelete(IRulesEngine.MergeableType.PROFILE, customerFile) || "pbl".equalsIgnoreCase(ext) && engine.isDelete(IRulesEngine.MergeableType.PBL, customerFile)) && (!"pbd".equalsIgnoreCase(ext) || !engine.isDelete(IRulesEngine.MergeableType.PBD, customerFile))) continue;
            File custFile = new File(customerFiles.get(customerFile));
            custFile.delete();
            customerFilesAfterDelete.remove(customerFile);
            sLogger.info("Deleted " + customerFile + " successfully.");
        }
        customerFiles = customerFilesAfterDelete;
        for (String updateFile : updateFiles.keySet()) {
            if (!customerFiles.containsKey(updateFile)) continue;
            ext = MergeAdministrator.getFileExtension(updateFile);
            String destDir = String.valueOf(System.getProperty("user.dir")) + File.separator + "mergedoutput";
            if (fromMergeUtility) {
                new File(destDir).mkdir();
            }
            try {
                if ("profile".equalsIgnoreCase(ext) && engine.isOverwrite(IRulesEngine.MergeableType.PROFILE, updateFile) || "pbl".equalsIgnoreCase(ext) && engine.isOverwrite(IRulesEngine.MergeableType.PBL, updateFile) || "pbd".equalsIgnoreCase(ext) && engine.isOverwrite(IRulesEngine.MergeableType.PBD, updateFile)) {
                    BufferedReader overWriteReader = new BufferedReader(new FileReader(updateFiles.get(updateFile)));
                    IMergeable ovreWrittenConfig = MergeAdministrator.readConfig(overWriteReader, ext);
                    if (fromMergeUtility) {
                        MergeAdministrator.write(ovreWrittenConfig, String.valueOf(destDir) + File.separator + updateFile);
                    } else {
                        MergeAdministrator.write(ovreWrittenConfig, customerFiles.get(updateFile));
                    }
                    sLogger.info("Overwritten " + updateFile + " successfully.");
                    continue;
                }
                if (!("profile".equalsIgnoreCase(ext) && engine.isMerge(IRulesEngine.MergeableType.PROFILE, updateFile) || "pbl".equalsIgnoreCase(ext) && engine.isMerge(IRulesEngine.MergeableType.PBL, updateFile)) && (!"pbd".equalsIgnoreCase(ext) || !engine.isMerge(IRulesEngine.MergeableType.PBL, updateFile))) continue;
                IMergeable mergedConfig = null;
                BufferedReader rightReader = new BufferedReader(new FileReader(updateFiles.get(updateFile)));
                IMergeable updateConfig = MergeAdministrator.readConfig(rightReader, ext);
                rightReader.close();
                BufferedReader leftReader = new BufferedReader(new FileReader(customerFiles.get(updateFile)));
                IMergeable customerConfig = MergeAdministrator.readConfig(leftReader, ext);
                leftReader.close();
                mergedConfig = customerConfig.merge(updateConfig, engine);
                if (fromMergeUtility) {
                    MergeAdministrator.write(mergedConfig, String.valueOf(destDir) + File.separator + updateFile);
                } else {
                    MergeAdministrator.write(mergedConfig, customerFiles.get(updateFile));
                }
                sLogger.info("Merged " + updateFile + " successfully.");
            }
            catch (IOException e) {
                String msg = MessageFormat.format("Failed to merge {0} because {1}.", updateFile, "\n" + e.getMessage());
                throw new MergeException(msg);
            }
        }
        customerFiles.clear();
        updateFiles.clear();
        customerFilesAfterDelete.clear();
        customerFiles = null;
        updateFiles = null;
        customerFilesAfterDelete = null;
    }

    private static Map<String, String> getConfigFiles(String dirPath) throws MergeException {
        HashMap<String, String> result = new HashMap<String, String>();
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new MergeException(String.valueOf(KMergeConstants.kNewline) + "ERROR: The directory \"" + dirPath + "\" given as input doesn't exist.Please check the input.");
        }
        if (dir.isDirectory()) {
            File[] children;
            File[] fileArray = children = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String ext;
                    boolean retValue = false;
                    if (pathname.isFile() && ("profile".equalsIgnoreCase(ext = MergeAdministrator.getFileExtension(pathname.getName())) || "pbl".equalsIgnoreCase(ext) || "pbd".equalsIgnoreCase(ext))) {
                        retValue = true;
                    }
                    return retValue;
                }
            });
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result.put(child.getName().toLowerCase(), child.getPath());
                ++n2;
            }
        }
        return result;
    }

    private static String getFileExtension(String filename) {
        String ext = null;
        int dotPos = filename.lastIndexOf(".");
        if (dotPos > 0 && dotPos <= filename.length() - 2) {
            ext = filename.substring(dotPos + 1);
        }
        return ext;
    }

    @Deprecated
    private static void mergeProfile(String customerFilePath, String updateFilePath, IRulesEngine engine) throws IOException {
        Profile mergedConfig = null;
        BufferedReader rightReader = new BufferedReader(new FileReader(updateFilePath));
        Profile updateConfig = Profile.read(rightReader);
        rightReader.close();
        BufferedReader leftReader = new BufferedReader(new FileReader(customerFilePath));
        Profile customerConfig = Profile.read(leftReader);
        leftReader.close();
        mergedConfig = customerConfig.merge(updateConfig, engine);
        MergeAdministrator.write(mergedConfig, customerFilePath);
    }

    @Deprecated
    public static void mergePbd(String customerFilePath, String updateFilePath, IRulesEngine engine) throws IOException {
        PBD mergedConfig = null;
        BufferedReader rightReader = new BufferedReader(new FileReader(updateFilePath));
        PBD updateConfig = PBD.read(rightReader);
        rightReader.close();
        BufferedReader leftReader = new BufferedReader(new FileReader(customerFilePath));
        PBD customerConfig = PBD.read(leftReader);
        leftReader.close();
        mergedConfig = customerConfig.merge(updateConfig, engine);
        MergeAdministrator.write(mergedConfig, customerFilePath);
    }

    @Deprecated
    private static void mergePbl(String customerFilePath, String updateFilePath, IRulesEngine engine) throws IOException {
        PBL mergedConfig = null;
        BufferedReader rightReader = new BufferedReader(new FileReader(updateFilePath));
        PBL updateConfig = PBL.read(rightReader);
        rightReader.close();
        BufferedReader leftReader = new BufferedReader(new FileReader(customerFilePath));
        PBL customerConfig = PBL.read(leftReader);
        leftReader.close();
        mergedConfig = customerConfig.merge(updateConfig, engine);
        MergeAdministrator.write(mergedConfig, customerFilePath);
    }

    private static void write(IMergeable<?> config, String destination) throws IOException {
        FileWriter writer = null;
        BufferedWriter bufferedWriter = null;
        try {
            writer = new FileWriter(destination);
            bufferedWriter = new BufferedWriter(writer);
            config.write(bufferedWriter);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
    }
}

